/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.Messages;
import org.opencms.loader.CmsJspLoader;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.I_CmsResourceStringDumpLoader;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;

public class CmsJspTagInclude
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    private static final long serialVersionUID = 705978510743164951L;
    private String m_attribute;
    private boolean m_cacheable = true;
    private boolean m_editable;
    private String m_element;
    private Map<String, String[]> m_parameterMap;
    private String m_property;
    private String m_suffix;
    private String m_target;

    public static void addParameter(Map<String, String[]> parameters, String name, String value, boolean overwrite) {
        if (parameters == null || name == null || value == null) {
            return;
        }
        if (parameters.containsKey(name) && !overwrite) {
            String[] values = parameters.get(name);
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            parameters.put(name, newValues);
        } else {
            String[] values = new String[]{value};
            parameters.put(name, values);
        }
    }

    public static void includeTagAction(PageContext context, String target, String element, boolean editable, Map<String, String[]> paramMap, Map<String, Object> attrMap, ServletRequest req, ServletResponse res) throws JspException {
        CmsJspTagInclude.includeTagAction(context, target, element, null, editable, true, paramMap, attrMap, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeTagAction(PageContext context, String target, String element, Locale locale, boolean editable, boolean cacheable, Map<String, String[]> paramMap, Map<String, Object> attrMap, ServletRequest req, ServletResponse res) throws JspException {
        CmsFlexController controller = CmsFlexController.getController(req);
        if (target == null) {
            target = controller.getCmsObject().getRequestContext().getUri();
        }
        target = CmsLinkManager.getAbsoluteUri(target, controller.getCurrentRequest().getElementUri());
        try {
            controller.getCmsObject().readResource(target);
        }
        catch (CmsException e) {
            controller.setThrowable(e, target);
            throw new JspException((Throwable)e);
        }
        boolean directEditOpen = editable && CmsJspTagEditable.startDirectEdit(context, new CmsDirectEditParams(target, element));
        Map<String, String[]> oldParameterMap = CmsCollectionsGenericWrapper.map(req.getParameterMap());
        try {
            HashMap<String, String[]> parameterMap;
            HashMap<String, String[]> hashMap = parameterMap = paramMap == null ? new HashMap<String, String[]>() : new HashMap<String, String[]>(paramMap);
            if (cacheable && element != null) {
                CmsJspTagInclude.addParameter(parameterMap, "__element", element, true);
            }
            controller.getCurrentRequest().addParameterMap(parameterMap);
            HashMap<String, Object> attributeMap = attrMap == null ? new HashMap<String, Object>() : new HashMap<String, Object>(attrMap);
            controller.getCurrentRequest().addAttributeMap(attributeMap);
            Set<String> dynamicParams = controller.getCurrentRequest().getDynamicParameters();
            HashMap<String, String[]> extendedParameterMap = null;
            if (!dynamicParams.isEmpty()) {
                extendedParameterMap = Maps.newHashMap();
                extendedParameterMap.putAll(parameterMap);
                for (String dynamicParam : dynamicParams) {
                    String[] val = (String[])req.getParameterMap().get(dynamicParam);
                    if (val == null) continue;
                    extendedParameterMap.put(dynamicParam, val);
                }
            }
            if (cacheable) {
                CmsJspTagInclude.includeActionWithCache(controller, context, target, extendedParameterMap != null ? extendedParameterMap : parameterMap, attributeMap, req, res);
            } else {
                CmsJspTagInclude.includeActionNoCache(controller, context, target, element, locale, req, res);
            }
        }
        finally {
            if (oldParameterMap != null) {
                controller.getCurrentRequest().setParameterMap(oldParameterMap);
            }
        }
        if (directEditOpen) {
            CmsJspTagEditable.endDirectEdit(context);
        }
    }

    private static void includeActionNoCache(CmsFlexController controller, PageContext context, String target, String element, Locale locale, ServletRequest req, ServletResponse res) throws JspException {
        try {
            String content;
            I_CmsResourceLoader loader;
            CmsFile file = controller.getCmsObject().readFile(target);
            CmsObject cms = controller.getCmsObject();
            if (locale == null) {
                locale = cms.getRequestContext().getLocale();
            }
            if ((loader = OpenCms.getResourceManager().getLoader(file)) instanceof I_CmsResourceStringDumpLoader) {
                I_CmsResourceStringDumpLoader strLoader = (I_CmsResourceStringDumpLoader)((Object)loader);
                content = strLoader.dumpAsString(cms, file, element, locale, req, res);
            } else {
                if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
                    CmsLoaderException e = new CmsLoaderException(Messages.get().container("ERR_BAD_REQUEST_RESPONSE_0"));
                    throw new JspException((Throwable)e);
                }
                byte[] result = loader.dump(cms, file, element, locale, (HttpServletRequest)req, (HttpServletResponse)res);
                String encoding = loader instanceof CmsJspLoader ? res.getCharacterEncoding() : cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
                if (result == null) {
                    result = new byte[]{};
                }
                content = new String(result, encoding);
            }
            context.getOut().print(content);
        }
        catch (ServletException e) {
            Throwable t = e.getRootCause() != null ? e.getRootCause() : e;
            t = controller.setThrowable(t, target);
            throw new JspException(t);
        }
        catch (IOException e) {
            Throwable t = controller.setThrowable(e, target);
            throw new JspException(t);
        }
        catch (CmsException e) {
            Throwable t = controller.setThrowable(e, target);
            throw new JspException(t);
        }
    }

    private static void includeActionWithCache(CmsFlexController controller, PageContext context, String target, Map<String, String[]> parameterMap, Map<String, Object> attributeMap, ServletRequest req, ServletResponse res) throws JspException {
        try {
            controller.getCurrentResponse().addToIncludeList(target, parameterMap, attributeMap);
            controller.getCurrentRequest().getRequestDispatcher(target).include(req, res);
            context.getOut().print('\u0000');
        }
        catch (ServletException e) {
            Throwable t = e.getRootCause() != null ? e.getRootCause() : e;
            t = controller.setThrowable(t, target);
            throw new JspException(t);
        }
        catch (IOException e) {
            Throwable t = controller.setThrowable(e, target);
            throw new JspException(t);
        }
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.m_parameterMap == null) {
            this.m_parameterMap = new HashMap<String, String[]>();
        }
        CmsJspTagInclude.addParameter(this.m_parameterMap, name, value, false);
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        ServletResponse res = this.pageContext.getResponse();
        if (CmsFlexController.isCmsRequest(req)) {
            CmsObject cms = CmsFlexController.getCmsObject(req);
            String target = null;
            if (this.m_target != null) {
                target = this.m_target + this.getSuffix();
            } else if (this.m_property != null) {
                try {
                    String prop = cms.readPropertyObject(cms.getRequestContext().getUri(), this.m_property, true).getValue();
                    if (prop != null) {
                        target = prop + this.getSuffix();
                    }
                }
                catch (RuntimeException e) {
                    target = null;
                }
                catch (Exception e2) {
                    Object e2 = null;
                }
            } else if (this.m_attribute != null) {
                try {
                    String attr = (String)req.getAttribute(this.m_attribute);
                    if (attr != null) {
                        target = attr + this.getSuffix();
                    }
                }
                catch (RuntimeException e) {
                    target = null;
                }
                catch (Exception e3) {
                    Object e3 = null;
                }
            } else {
                String body = null;
                if (this.getBodyContent() != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(body = this.getBodyContent().getString())) {
                    target = body + this.getSuffix();
                }
            }
            CmsJspTagInclude.includeTagAction(this.pageContext, target, this.m_element, null, this.m_editable, this.m_cacheable, this.m_parameterMap, CmsRequestUtil.getAtrributeMap(req), req, res);
            this.release();
        }
        return 6;
    }

    public int doStartTag() {
        return 2;
    }

    public String getAttribute() {
        return this.m_attribute != null ? this.m_attribute : "";
    }

    public String getCacheable() {
        return String.valueOf(this.m_cacheable);
    }

    public String getEditable() {
        return String.valueOf(this.m_editable);
    }

    public String getElement() {
        return this.m_element;
    }

    public String getFile() {
        return this.getPage();
    }

    public String getPage() {
        return this.m_target != null ? this.m_target : "";
    }

    public String getProperty() {
        return this.m_property != null ? this.m_property : "";
    }

    public String getSuffix() {
        return this.m_suffix != null ? this.m_suffix : "";
    }

    public void release() {
        super.release();
        this.m_target = null;
        this.m_suffix = null;
        this.m_property = null;
        this.m_element = null;
        this.m_parameterMap = null;
        this.m_editable = false;
        this.m_cacheable = true;
    }

    public void setAttribute(String attribute) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(attribute)) {
            this.m_attribute = attribute;
        }
    }

    public void setCacheable(String cacheable) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(cacheable)) {
            this.m_cacheable = Boolean.valueOf(cacheable);
        }
    }

    public void setEditable(String editable) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(editable)) {
            this.m_editable = Boolean.valueOf(editable);
        }
    }

    public void setElement(String element) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(element)) {
            this.m_element = element;
        }
    }

    public void setFile(String file) {
        this.setPage(file);
    }

    public void setPage(String target) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(target)) {
            this.m_target = target;
        }
    }

    public void setProperty(String property) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(property)) {
            this.m_property = property;
        }
    }

    public void setSuffix(String suffix) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(suffix)) {
            this.m_suffix = suffix.toLowerCase();
        }
    }
}

