/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.pdftools.CmsPdfLink;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagPdf
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    private static final Log LOG = CmsLog.getLog(CmsJspTagPdf.class);
    private static final long serialVersionUID = 1L;
    private String m_content;
    private String m_format;
    private String m_locale;
    private SortedMap<String, String> m_parameters;
    private String m_paramEncoding;

    public static String pdfTagAction(ServletRequest request, String format, String content, String localeStr, SortedMap<String, String> params, String paramEncoding) throws CmsException {
        CmsFlexController controller = CmsFlexController.getController(request);
        CmsObject cms = OpenCms.initCmsObject(controller.getCmsObject());
        if (localeStr != null) {
            Locale localeObj = CmsLocaleManager.getLocale(localeStr);
            cms.getRequestContext().setLocale(localeObj);
        }
        CmsResource formatterRes = cms.readResource(format);
        CmsResource contentRes = cms.readResource(content, CmsResourceFilter.ignoreExpirationOffline(cms));
        CmsPdfLink pdfLink = new CmsPdfLink(cms, formatterRes, contentRes);
        StringBuilder paramBuf = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            paramBuf.append("?");
            ArrayList<String> paramList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                try {
                    paramList.add(URLEncoder.encode(entry.getKey(), paramEncoding) + "=" + URLEncoder.encode(entry.getValue(), paramEncoding));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            paramBuf.append(CmsStringUtil.listAsString(paramList, "&amp;"));
        }
        return pdfLink.getLink() + paramBuf.toString();
    }

    @Override
    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public int doEndTag() {
        try {
            this.pageContext.getOut().print(CmsJspTagPdf.pdfTagAction(this.pageContext.getRequest(), this.m_format, this.m_content, this.m_locale, this.m_parameters, this.getParamEncoding()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 6;
    }

    public int doStartTag() {
        this.m_parameters = new TreeMap<String, String>();
        return 2;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public void setParamEncoding(String encoding) {
        this.m_paramEncoding = encoding;
    }

    private String getParamEncoding() {
        if (this.m_paramEncoding != null) {
            return this.m_paramEncoding;
        }
        return "UTF-8";
    }
}

