/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsPublishListHelper;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsCollectorPublishListProvider;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsContentLoadCollectorInfo;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.jsp.search.config.CmsSearchConfiguration;
import org.opencms.jsp.search.config.parser.CmsJSONSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.CmsPlainQuerySearchConfigurationParser;
import org.opencms.jsp.search.config.parser.CmsXMLSearchConfigurationParser;
import org.opencms.jsp.search.controller.CmsSearchController;
import org.opencms.jsp.search.controller.I_CmsSearchControllerCommon;
import org.opencms.jsp.search.controller.I_CmsSearchControllerMain;
import org.opencms.jsp.search.result.CmsSearchResultWrapper;
import org.opencms.jsp.search.result.I_CmsSearchResultWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsJspTagSearch
extends CmsJspScopedVarBodyTagSuport
implements I_CmsCollectorPublishListProvider {
    private static final Log LOG = CmsLog.getLog(CmsJspTagSearch.class);
    private static final long serialVersionUID = 6048771777971251L;
    public static final int DEFAULT_CONTENTINFO_ROWS = 200;
    protected transient CmsObject m_cms;
    protected CmsFlexController m_controller;
    private Integer m_addContentInfoForEntries;
    private Object m_configFile;
    private String m_configString;
    private FileFormat m_fileFormat = FileFormat.XML;
    private I_CmsSearchControllerMain m_searchController;
    private CmsSolrIndex m_index;

    public static Set<CmsResource> getPublishResourcesInternal(CmsObject cms, I_CmsContentLoadCollectorInfo info) throws CmsException {
        CmsSolrIndex solrOnline = OpenCms.getSearchManager().getIndexSolr("Solr Online");
        CmsSolrIndex solrOffline = OpenCms.getSearchManager().getIndexSolr("Solr Offline");
        HashSet<CmsResource> result = new HashSet<CmsResource>();
        try {
            CmsSolrResultList offlineResults = solrOffline.search(CmsPublishListHelper.adjustCmsObject(cms, false), new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(info.getCollectorParams())), true);
            HashSet<String> offlineIds = new HashSet<String>(offlineResults.size());
            for (CmsSearchResource offlineResult : offlineResults) {
                offlineIds.add(offlineResult.getField("id"));
            }
            for (String id : offlineIds) {
                CmsResource resource = cms.readResource(new CmsUUID(id));
                if (resource.getState().isUnchanged()) continue;
                result.add(resource);
            }
            CmsSolrResultList onlineResults = solrOnline.search(CmsPublishListHelper.adjustCmsObject(cms, true), new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(info.getCollectorParams())), true);
            HashSet<String> deletedIds = new HashSet<String>(onlineResults.size());
            for (CmsSearchResource onlineResult : onlineResults) {
                String uuid = onlineResult.getField("id");
                if (offlineIds.contains(uuid)) continue;
                deletedIds.add(uuid);
            }
            for (String uuid : deletedIds) {
                CmsResource resource = cms.readResource(new CmsUUID(uuid));
                if (resource.getState().isUnchanged()) continue;
                result.add(resource);
            }
        }
        catch (CmsSearchException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_TAG_SEARCH_SEARCH_FAILED_0"), (Throwable)e);
        }
        return result;
    }

    public int doEndTag() throws JspException {
        this.release();
        return super.doEndTag();
    }

    public int doStartTag() throws JspException, CmsIllegalArgumentException {
        this.init();
        this.addContentInfo();
        return 1;
    }

    public Object getConfigFile() {
        return this.m_configFile;
    }

    public String getConfigString() {
        return this.m_configString;
    }

    public String getFileFormat() {
        return this.m_fileFormat.toString();
    }

    @Override
    public Set<CmsResource> getPublishResources(CmsObject cms, I_CmsContentLoadCollectorInfo info) throws CmsException {
        return CmsJspTagSearch.getPublishResourcesInternal(cms, info);
    }

    @Override
    public void release() {
        this.m_cms = null;
        this.m_configFile = null;
        this.setConfigString(null);
        this.m_searchController = null;
        this.m_index = null;
        this.m_controller = null;
        super.release();
    }

    public void setAddContentInfo(Boolean doAddInfo) {
        if (null != doAddInfo && doAddInfo.booleanValue() && null != this.m_addContentInfoForEntries) {
            this.m_addContentInfoForEntries = 200;
        }
    }

    public void setConfigFile(Object fileName) {
        this.m_configFile = fileName;
    }

    public void setConfigString(String configString) {
        this.m_configString = configString;
    }

    public void setContentInfoMaxItems(Integer maxItems) {
        if (null != maxItems) {
            this.m_addContentInfoForEntries = maxItems;
        }
    }

    public void setFileFormat(String fileFormat) {
        if (fileFormat.toUpperCase().equals(FileFormat.JSON.toString())) {
            this.m_fileFormat = FileFormat.JSON;
        }
    }

    protected void init() throws JspException {
        this.m_controller = CmsFlexController.getController(this.pageContext.getRequest());
        this.m_cms = this.m_controller.getCmsObject();
        try {
            CmsSearchConfiguration config = null;
            if (this.m_configFile != null) {
                CmsFile configFile = this.m_cms.readFile(CmsJspElFunctions.convertRawResource(this.m_cms, this.m_configFile));
                if (this.m_fileFormat == FileFormat.JSON) {
                    OpenCms.getLocaleManager();
                    String configString = new String(configFile.getContents(), CmsLocaleManager.getResourceEncoding(this.m_cms, configFile));
                    config = new CmsSearchConfiguration(new CmsJSONSearchConfigurationParser(configString));
                } else {
                    CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_cms, configFile);
                    config = new CmsSearchConfiguration(new CmsXMLSearchConfigurationParser(xmlContent, this.m_cms.getRequestContext().getLocale()));
                }
            }
            if (this.m_configString != null) {
                config = this.m_configString.trim().startsWith("{") ? new CmsSearchConfiguration(new CmsJSONSearchConfigurationParser(this.m_configString, config)) : new CmsSearchConfiguration(new CmsPlainQuerySearchConfigurationParser(this.m_configString, config));
            }
            this.m_searchController = new CmsSearchController(config);
            String indexName = this.m_searchController.getCommon().getConfig().getSolrIndex();
            if (indexName != null && !indexName.trim().isEmpty()) {
                this.m_index = OpenCms.getSearchManager().getIndexSolr(indexName);
            }
            if (this.m_index == null) {
                this.m_index = OpenCms.getSearchManager().getIndexSolr(this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline");
            }
            this.storeAttribute(this.getVar(), this.getSearchResults());
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_controller.setThrowable(e, this.m_cms.getRequestContext().getUri());
            throw new JspException((Throwable)e);
        }
    }

    private void addContentInfo() {
        if (!this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() && null == this.m_searchController.getCommon().getConfig().getSolrIndex() && null != this.m_addContentInfoForEntries) {
            CmsSolrQuery query = new CmsSolrQuery();
            this.m_searchController.addQueryParts(query, this.m_cms);
            query.setStart(0);
            query.setRows(this.m_addContentInfoForEntries);
            CmsContentLoadCollectorInfo info = new CmsContentLoadCollectorInfo();
            info.setCollectorClass(this.getClass().getName());
            info.setCollectorParams(query.getQuery());
            info.setId(new CmsUUID().getStringValue());
            if (CmsJspTagEditable.getDirectEditProvider(this.pageContext) != null) {
                try {
                    CmsJspTagEditable.getDirectEditProvider(this.pageContext).insertDirectEditListMetadata(this.pageContext, info);
                }
                catch (JspException e) {
                    LOG.error((Object)"Could not write content info.", (Throwable)e);
                }
            }
        }
    }

    private I_CmsSearchResultWrapper getSearchResults() {
        this.m_searchController.updateFromRequestParameters(this.pageContext.getRequest().getParameterMap(), false);
        I_CmsSearchControllerCommon common = this.m_searchController.getCommon();
        if (common.getState().getQuery().isEmpty() && !common.getConfig().getIgnoreQueryParam() && !common.getConfig().getSearchForEmptyQueryParam()) {
            return new CmsSearchResultWrapper(this.m_searchController, null, null, this.m_cms, null);
        }
        Map<String, String[]> queryParams = null;
        boolean isEditMode = CmsJspTagEditable.isEditableRequest(this.pageContext.getRequest());
        if (isEditMode) {
            String params = "";
            if (common.getConfig().getIgnoreReleaseDate()) {
                params = params + "&fq=released:[* TO *]";
            }
            if (common.getConfig().getIgnoreExpirationDate()) {
                params = params + "&fq=expired:[* TO *]";
            }
            if (!params.isEmpty()) {
                queryParams = CmsRequestUtil.createParameterMap(params.substring(1));
            }
        }
        CmsSolrQuery query = new CmsSolrQuery(null, queryParams);
        this.m_searchController.addQueryParts(query, this.m_cms);
        try {
            CmsSolrResultList solrResultList = this.m_index.search(this.m_cms, query.clone(), true, isEditMode ? CmsResourceFilter.IGNORE_EXPIRATION : null);
            return new CmsSearchResultWrapper(this.m_searchController, solrResultList, query, this.m_cms, null);
        }
        catch (CmsSearchException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_TAG_SEARCH_SEARCH_FAILED_0"), (Throwable)e);
            return new CmsSearchResultWrapper(this.m_searchController, null, query, this.m_cms, e);
        }
    }

    private static enum FileFormat {
        XML,
        JSON;

    }
}

