/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.decorator;

import java.util.Locale;
import org.opencms.jsp.decorator.CmsDecorationDefintion;
import org.opencms.jsp.decorator.I_CmsDecoratorConfiguration;
import org.opencms.util.CmsMacroResolver;

public class CmsDecorationObject {
    public static final String MACRO_DECORATION = "decoration";
    public static final String MACRO_DECORATIONKEY = "decorationkey";
    public static final String MACRO_LANGUAGE = "language";
    public static final String MACRO_LOCALE = "locale";
    private String m_decoration;
    private CmsDecorationDefintion m_decorationDefinition;
    private String m_decorationKey;
    private Locale m_locale;

    public CmsDecorationObject() {
        this.m_decorationDefinition = new CmsDecorationDefintion();
    }

    public CmsDecorationObject(String decorationKey, String decoration, CmsDecorationDefintion decDef, Locale locale) {
        this.m_decorationKey = decorationKey;
        this.m_decoration = decoration;
        this.m_decorationDefinition = decDef;
        this.m_locale = locale;
    }

    public String getContentDecoration(I_CmsDecoratorConfiguration config, String text, String contentLocale) {
        StringBuffer content = new StringBuffer();
        if (!config.hasUsed(this.m_decorationKey) && this.m_decorationDefinition.isMarkFirst()) {
            content.append(this.m_decorationDefinition.getPreTextFirst());
        } else {
            content.append(this.m_decorationDefinition.getPreText());
        }
        content.append(text);
        if (!config.hasUsed(this.m_decorationKey) && this.m_decorationDefinition.isMarkFirst()) {
            content.append(this.m_decorationDefinition.getPostTextFirst());
            config.markAsUsed(this.m_decorationKey);
        } else {
            content.append(this.m_decorationDefinition.getPostText());
        }
        return this.replaceMacros(content.toString(), contentLocale);
    }

    public String getDecoration() {
        return this.m_decoration;
    }

    public CmsDecorationDefintion getDecorationDefinition() {
        return this.m_decorationDefinition;
    }

    public String getDecorationKey() {
        return this.m_decorationKey;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" [name = '");
        buf.append(this.m_decorationKey);
        buf.append("', decoration = '");
        buf.append(this.m_decoration);
        buf.append("', locale = '");
        buf.append(this.m_locale);
        buf.append("' decorationDefinition ='");
        buf.append(this.m_decorationDefinition);
        buf.append("']");
        return buf.toString();
    }

    private String replaceMacros(String msg, String contentLocale) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.addMacro(MACRO_DECORATION, this.m_decoration);
        resolver.addMacro(MACRO_DECORATIONKEY, this.m_decorationKey);
        if (this.m_locale != null) {
            resolver.addMacro(MACRO_LOCALE, this.m_locale.toString());
            if (!contentLocale.equals(this.m_locale.toString())) {
                resolver.addMacro(MACRO_LANGUAGE, "lang=\"" + this.m_locale.toString() + "\"");
            }
        }
        return resolver.resolveMacros(msg);
    }
}

