/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config;

import java.util.ArrayList;
import java.util.Map;
import org.opencms.jsp.search.config.I_CmsSearchConfiguration;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.parser.I_CmsSearchConfigurationParser;

public class CmsSearchConfiguration
implements I_CmsSearchConfiguration {
    private final I_CmsSearchConfigurationCommon m_general;
    private final I_CmsSearchConfigurationPagination m_pagination;
    private final Map<String, I_CmsSearchConfigurationFacetField> m_fieldFacets;
    private final Map<String, I_CmsSearchConfigurationFacetRange> m_rangeFacets;
    private final I_CmsSearchConfigurationFacetQuery m_queryFacet;
    private final I_CmsSearchConfigurationSorting m_sorting;
    private final I_CmsSearchConfigurationHighlighting m_highlighting;
    private final I_CmsSearchConfigurationDidYouMean m_didYouMean;

    public CmsSearchConfiguration(I_CmsSearchConfigurationParser parser) {
        this.m_general = parser.parseCommon();
        this.m_pagination = parser.parsePagination();
        this.m_sorting = parser.parseSorting();
        this.m_fieldFacets = parser.parseFieldFacets();
        this.m_rangeFacets = parser.parseRangeFacets();
        this.m_queryFacet = parser.parseQueryFacet();
        this.m_highlighting = parser.parseHighlighter();
        this.m_didYouMean = parser.parseDidYouMean();
        this.propagateFacetNames();
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean getDidYouMeanConfig() {
        return this.m_didYouMean;
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> getFieldFacetConfigs() {
        return this.m_fieldFacets;
    }

    @Override
    public I_CmsSearchConfigurationCommon getGeneralConfig() {
        return this.m_general;
    }

    @Override
    public I_CmsSearchConfigurationHighlighting getHighlighterConfig() {
        return this.m_highlighting;
    }

    @Override
    public I_CmsSearchConfigurationPagination getPaginationConfig() {
        return this.m_pagination;
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery getQueryFacetConfig() {
        return this.m_queryFacet;
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> getRangeFacetConfigs() {
        return this.m_rangeFacets;
    }

    @Override
    public I_CmsSearchConfigurationSorting getSortConfig() {
        return this.m_sorting;
    }

    private void propagateFacetNames() {
        ArrayList<String> facetNames = new ArrayList<String>();
        ArrayList<I_CmsSearchConfigurationFacet> facetConfigs = new ArrayList<I_CmsSearchConfigurationFacet>();
        facetNames.addAll(this.m_fieldFacets.keySet());
        facetConfigs.addAll(this.m_fieldFacets.values());
        facetNames.addAll(this.m_rangeFacets.keySet());
        facetConfigs.addAll(this.m_rangeFacets.values());
        if (null != this.m_queryFacet) {
            facetNames.add(this.m_queryFacet.getName());
            facetConfigs.add(this.m_queryFacet);
        }
        for (I_CmsSearchConfigurationFacet facetConfig : facetConfigs) {
            facetConfig.propagateAllFacetNames(facetNames);
        }
    }
}

