/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.jsp.search.config.CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfiguration;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.parser.I_CmsSearchConfigurationParser;
import org.opencms.main.CmsLog;

public class CmsPlainQuerySearchConfigurationParser
implements I_CmsSearchConfigurationParser {
    protected static final Log LOG = CmsLog.getLog(CmsPlainQuerySearchConfigurationParser.class);
    private static final String DEFAULT_FL = "id,path";
    protected String m_queryString;
    private I_CmsSearchConfiguration m_baseConfig;

    public CmsPlainQuerySearchConfigurationParser(String query) {
        this(query, null);
    }

    public CmsPlainQuerySearchConfigurationParser(String query, I_CmsSearchConfiguration baseConfig) {
        if (null != query && !query.startsWith("fl=") && !query.contains("&fl=")) {
            query = query + "&fl=" + DEFAULT_FL;
        }
        this.m_queryString = query;
        this.m_baseConfig = baseConfig;
    }

    @Override
    public I_CmsSearchConfigurationCommon parseCommon() {
        return new CmsSearchConfigurationCommon(null, null, null, null, Boolean.TRUE, Boolean.TRUE, null, null, null, this.m_queryString, null, null, null);
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean parseDidYouMean() {
        return null != this.m_baseConfig ? this.m_baseConfig.getDidYouMeanConfig() : null;
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        return null != this.m_baseConfig ? this.m_baseConfig.getFieldFacetConfigs() : Collections.emptyMap();
    }

    @Override
    public I_CmsSearchConfigurationHighlighting parseHighlighter() {
        return null != this.m_baseConfig ? this.m_baseConfig.getHighlighterConfig() : null;
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        return null != this.m_baseConfig ? this.m_baseConfig.getPaginationConfig() : null;
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery parseQueryFacet() {
        return null != this.m_baseConfig ? this.m_baseConfig.getQueryFacetConfig() : null;
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        return null != this.m_baseConfig ? this.m_baseConfig.getRangeFacetConfigs() : Collections.emptyMap();
    }

    @Override
    public I_CmsSearchConfigurationSorting parseSorting() {
        return null != this.m_baseConfig ? this.m_baseConfig.getSortConfig() : null;
    }
}

