/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.I_CmsSearchConfiguration;
import org.opencms.jsp.search.controller.CmsSearchControllerCommon;
import org.opencms.jsp.search.controller.CmsSearchControllerDidYouMean;
import org.opencms.jsp.search.controller.CmsSearchControllerFacetQuery;
import org.opencms.jsp.search.controller.CmsSearchControllerFacetsField;
import org.opencms.jsp.search.controller.CmsSearchControllerFacetsRange;
import org.opencms.jsp.search.controller.CmsSearchControllerHighlighting;
import org.opencms.jsp.search.controller.CmsSearchControllerPagination;
import org.opencms.jsp.search.controller.CmsSearchControllerSorting;
import org.opencms.jsp.search.controller.I_CmsSearchController;
import org.opencms.jsp.search.controller.I_CmsSearchControllerCommon;
import org.opencms.jsp.search.controller.I_CmsSearchControllerDidYouMean;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetQuery;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetsField;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetsRange;
import org.opencms.jsp.search.controller.I_CmsSearchControllerHighlighting;
import org.opencms.jsp.search.controller.I_CmsSearchControllerMain;
import org.opencms.jsp.search.controller.I_CmsSearchControllerPagination;
import org.opencms.jsp.search.controller.I_CmsSearchControllerSorting;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchController
implements I_CmsSearchControllerMain {
    Collection<I_CmsSearchController> m_controllers = new ArrayList<I_CmsSearchController>();
    I_CmsSearchControllerCommon m_common;
    I_CmsSearchControllerSorting m_sorting;
    I_CmsSearchControllerPagination m_pagination;
    I_CmsSearchControllerFacetsField m_fieldFacets;
    I_CmsSearchControllerFacetsRange m_rangeFacets;
    I_CmsSearchControllerFacetQuery m_queryFacet;
    I_CmsSearchControllerHighlighting m_highlighting;
    I_CmsSearchControllerDidYouMean m_didyoumean;

    public CmsSearchController(I_CmsSearchConfiguration config) {
        this.m_common = new CmsSearchControllerCommon(config.getGeneralConfig());
        this.m_controllers.add(this.m_common);
        if (config.getPaginationConfig() != null) {
            this.m_pagination = new CmsSearchControllerPagination(config.getPaginationConfig());
            this.m_controllers.add(this.m_pagination);
        }
        if (config.getSortConfig() != null) {
            this.m_sorting = new CmsSearchControllerSorting(config.getSortConfig());
            this.m_controllers.add(this.m_sorting);
        }
        this.m_fieldFacets = new CmsSearchControllerFacetsField(config.getFieldFacetConfigs());
        this.m_controllers.add(this.m_fieldFacets);
        this.m_rangeFacets = new CmsSearchControllerFacetsRange(config.getRangeFacetConfigs());
        this.m_controllers.add(this.m_rangeFacets);
        if (config.getHighlighterConfig() != null) {
            this.m_highlighting = new CmsSearchControllerHighlighting(config.getHighlighterConfig());
            this.m_controllers.add(this.m_highlighting);
        }
        if (config.getDidYouMeanConfig() != null) {
            this.m_didyoumean = new CmsSearchControllerDidYouMean(config.getDidYouMeanConfig());
            this.m_controllers.add(this.m_didyoumean);
        }
        if (config.getQueryFacetConfig() != null) {
            this.m_queryFacet = new CmsSearchControllerFacetQuery(config.getQueryFacetConfig());
            this.m_controllers.add(this.m_queryFacet);
        }
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        for (I_CmsSearchController controller : this.m_controllers) {
            controller.addParametersForCurrentState(parameters);
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query, CmsObject cms) {
        Iterator<I_CmsSearchController> it = this.m_controllers.iterator();
        it.next().addQueryParts(query, cms);
        while (it.hasNext()) {
            it.next().addQueryParts(query, cms);
        }
        if (this.getHighlighting() != null && query.getParams("df") == null && query.getParams("type") == null) {
            String df = this.getHighlighting().getConfig().getHightlightField().trim();
            int index = df.indexOf(32);
            query.add("df", new String[]{index > 0 ? df.substring(0, index) : df});
        }
    }

    @Override
    public I_CmsSearchControllerCommon getCommon() {
        return this.m_common;
    }

    @Override
    public I_CmsSearchControllerDidYouMean getDidYouMean() {
        return this.m_didyoumean;
    }

    @Override
    public I_CmsSearchControllerFacetsField getFieldFacets() {
        return this.m_fieldFacets;
    }

    @Override
    public I_CmsSearchControllerHighlighting getHighlighting() {
        return this.m_highlighting;
    }

    @Override
    public I_CmsSearchControllerPagination getPagination() {
        return this.m_pagination;
    }

    @Override
    public I_CmsSearchControllerFacetQuery getQueryFacet() {
        return this.m_queryFacet;
    }

    @Override
    public I_CmsSearchControllerFacetsRange getRangeFacets() {
        return this.m_rangeFacets;
    }

    @Override
    public I_CmsSearchControllerSorting getSorting() {
        return this.m_sorting;
    }

    @Override
    public void updateForQueryChange() {
        for (I_CmsSearchController controller : this.m_controllers) {
            controller.updateForQueryChange();
        }
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean unused) {
        String lastQueryParam = this.m_common.getConfig().getLastQueryParam();
        String queryParam = this.m_common.getConfig().getQueryParam();
        String firstCallParam = this.m_common.getConfig().getReloadedParam();
        if (!this.m_common.getConfig().getIgnoreQueryParam() && parameters.containsKey(lastQueryParam) && parameters.containsKey(queryParam) && parameters.get(lastQueryParam).length > 0 && parameters.get(queryParam).length > 0 && !parameters.get(queryParam)[0].equals(parameters.get(lastQueryParam)[0])) {
            this.updateForQueryChange();
        }
        boolean isReloaded = parameters.containsKey(firstCallParam);
        for (I_CmsSearchController controller : this.m_controllers) {
            controller.updateFromRequestParameters(parameters, isReloaded);
        }
    }
}

