/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.controller.I_CmsSearchControllerCommon;
import org.opencms.jsp.search.state.CmsSearchStateCommon;
import org.opencms.jsp.search.state.I_CmsSearchStateCommon;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.util.CmsRequestUtil;

public class CmsSearchControllerCommon
implements I_CmsSearchControllerCommon {
    private static final String MACRO_VALUE = "value";
    private static final String MACRO_SITE_ROOT = "site_root";
    private final I_CmsSearchConfigurationCommon m_config;
    private final I_CmsSearchStateCommon m_state;

    public CmsSearchControllerCommon(I_CmsSearchConfigurationCommon config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateCommon();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (!this.m_state.getQuery().isEmpty()) {
            parameters.put(this.m_config.getQueryParam(), new String[]{this.m_state.getQuery()});
        }
        parameters.put(this.m_config.getReloadedParam(), null);
        for (Map.Entry<String, String> e : this.m_state.getAdditionalParameters().entrySet()) {
            parameters.put(e.getKey(), new String[]{e.getValue()});
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query, CmsObject cms) {
        String queryString = this.m_state.getQuery();
        if (!this.m_config.getIgnoreQueryParam()) {
            String modifiedQuery;
            if (this.m_config.getEscapeQueryChars()) {
                queryString = ClientUtils.escapeQueryChars((String)queryString);
            }
            if (queryString.isEmpty() && this.m_config.getSearchForEmptyQueryParam()) {
                queryString = "*";
            }
            modifiedQuery = (modifiedQuery = this.m_config.getModifiedQuery(queryString)).startsWith("{!") ? "{!tag=q " + modifiedQuery.substring(2) : "{!tag=q}" + modifiedQuery;
            query.set("q", new String[]{modifiedQuery});
        }
        if (this.m_config.getSolrIndex() != null) {
            query.set("index", new String[]{this.m_config.getSolrIndex()});
        }
        if (this.m_config.getSolrCore() != null) {
            query.set("core", new String[]{this.m_config.getSolrCore()});
        }
        if (!this.m_config.getExtraSolrParams().isEmpty()) {
            String currentSiteRoot;
            String string = currentSiteRoot = null == cms ? null : cms.getRequestContext().getSiteRoot();
            if (null != currentSiteRoot && !currentSiteRoot.endsWith("/")) {
                currentSiteRoot = currentSiteRoot + "/";
            }
            Map<String, String[]> extraParamsMap = CmsRequestUtil.createParameterMap(this.m_config.getExtraSolrParams());
            for (String key : extraParamsMap.keySet()) {
                for (String string2 : Arrays.asList((Object[])extraParamsMap.get(key))) {
                    String string3 = this.resolveMacro(string2, MACRO_SITE_ROOT, currentSiteRoot);
                    if (SET_VARIABLES.contains(key)) {
                        if (key.equals("fl")) {
                            query.setReturnFields(string3);
                            continue;
                        }
                        query.set(key, new String[]{string3});
                        continue;
                    }
                    query.add(key, new String[]{string3});
                }
            }
        }
        for (String additionalParam : this.m_state.getAdditionalParameters().keySet()) {
            String solrValue = this.m_config.getAdditionalParameters().get(additionalParam);
            if (null == solrValue) continue;
            String additionalParamString = this.resolveMacro(solrValue, MACRO_VALUE, this.m_state.getAdditionalParameters().get(additionalParam));
            Map<String, String[]> extraParamsMap = CmsRequestUtil.createParameterMap(additionalParamString);
            for (String key : extraParamsMap.keySet()) {
                for (String string : Arrays.asList((Object[])extraParamsMap.get(key))) {
                    if (SET_VARIABLES.contains(key)) {
                        query.set(key, new String[]{string});
                        continue;
                    }
                    query.add(key, new String[]{string});
                }
            }
        }
        if (!query.getMap().keySet().contains("TZ")) {
            query.add("TZ", new String[]{TimeZone.getDefault().getID()});
        }
    }

    @Override
    public I_CmsSearchConfigurationCommon getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateCommon getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        String[] queryStrings;
        this.m_state.setQuery("");
        if (parameters.containsKey(this.m_config.getQueryParam()) && (queryStrings = parameters.get(this.m_config.getQueryParam())).length > 0) {
            this.m_state.setQuery(queryStrings[0]);
        }
        if (parameters.containsKey(this.m_config.getLastQueryParam()) && (queryStrings = parameters.get(this.m_config.getLastQueryParam())).length > 0) {
            this.m_state.setLastQuery(queryStrings[0]);
        }
        HashMap<String, String> additionalParameters = new HashMap<String, String>(this.m_config.getAdditionalParameters().size());
        for (String key : this.m_config.getAdditionalParameters().keySet()) {
            if (!parameters.containsKey(key) || parameters.get(key).length <= 0 || parameters.get(key)[0].length() <= 0) continue;
            additionalParameters.put(key, parameters.get(key)[0]);
        }
        this.m_state.setAdditionalParameters(additionalParameters);
    }

    private String resolveMacro(String string, String macroName, String value) {
        return null != value ? string.replaceAll("\\%\\(" + Pattern.quote(macroName) + "\\)", value) : string;
    }
}

