/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Iterator;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetField;
import org.opencms.jsp.search.state.CmsSearchStateFacet;
import org.opencms.jsp.search.state.I_CmsSearchStateFacet;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerFacetField
implements I_CmsSearchControllerFacetField {
    private final I_CmsSearchConfigurationFacetField m_config;
    private final I_CmsSearchStateFacet m_state;

    public CmsSearchControllerFacetField(I_CmsSearchConfigurationFacetField config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateFacet();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (!this.m_state.getCheckedEntries().isEmpty()) {
            parameters.put(this.m_config.getParamKey(), this.m_state.getCheckedEntries().toArray(new String[this.m_state.getCheckedEntries().size()]));
        }
        if (this.m_state.getIgnoreChecked()) {
            parameters.put(this.m_config.getIgnoreMaxParamKey(), null);
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query, CmsObject cms) {
        this.addFacetPart(query);
        this.addFilterQueryParts(query);
    }

    @Override
    public I_CmsSearchConfigurationFacetField getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateFacet getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
        this.m_state.setIgnoreChecked(true);
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        block3: {
            block2: {
                this.m_state.setUseLimit(!parameters.containsKey(this.m_config.getIgnoreMaxParamKey()));
                if (!isReloaded) break block2;
                this.m_state.clearChecked();
                if (this.m_state.getIgnoreChecked() || !parameters.containsKey(this.m_config.getParamKey())) break block3;
                String[] checked = parameters.get(this.m_config.getParamKey());
                for (int i = 0; i < checked.length; ++i) {
                    this.m_state.addChecked(checked[i]);
                }
                break block3;
            }
            for (String checked : this.m_config.getPreSelection()) {
                this.m_state.addChecked(checked);
            }
        }
    }

    protected void addFacetOptions(StringBuffer query, boolean useLimit) {
        if (this.m_config.getMinCount() != null) {
            this.appendFacetOption(query, "mincount", this.m_config.getMinCount().toString());
        }
        if (useLimit && this.m_config.getLimit() != null) {
            this.appendFacetOption(query, "limit", this.m_config.getLimit().toString());
        }
        if (this.m_config.getSortOrder() != null) {
            this.appendFacetOption(query, "sort", this.m_config.getSortOrder().toString());
        }
        if (!this.m_config.getPrefix().isEmpty()) {
            this.appendFacetOption(query, "prefix", this.m_config.getPrefix());
        }
    }

    protected void addFacetPart(CmsSolrQuery query) {
        StringBuffer value = new StringBuffer();
        value.append("{!key=").append(this.m_config.getName());
        this.addFacetOptions(value, this.m_state.getUseLimit());
        if (this.m_config.getIgnoreAllFacetFilters() || !this.m_state.getCheckedEntries().isEmpty() && !this.m_config.getIsAndFacet()) {
            value.append(" ex=").append(this.m_config.getIgnoreTags());
        }
        value.append("}");
        value.append(this.m_config.getField());
        query.add("facet.field", new String[]{value.toString()});
    }

    protected void addFilterQueryParts(CmsSolrQuery query) {
        if (!this.m_state.getCheckedEntries().isEmpty()) {
            String concater;
            StringBuffer value = new StringBuffer();
            value.append("{!tag=").append(this.m_config.getName()).append('}');
            value.append(this.m_config.getField());
            value.append(":(");
            Iterator<String> fieldIterator = this.m_state.getCheckedEntries().iterator();
            value.append(this.m_config.modifyFilterQuery(fieldIterator.next()));
            String string = concater = this.m_config.getIsAndFacet() ? " AND " : " OR ";
            while (fieldIterator.hasNext()) {
                value.append(concater);
                value.append(this.m_config.modifyFilterQuery(fieldIterator.next()));
            }
            value.append(')');
            query.add("fq", new String[]{value.toString()});
        }
    }

    protected void appendFacetOption(StringBuffer query, String name, String value) {
        query.append(" facet.").append(name).append("=").append(value);
    }
}

