/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsFileUtil;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

public class CmsJspContentAttachmentsBean {
    private static final Log LOG = CmsLog.getLog(CmsJspContentAttachmentsBean.class);
    protected CmsContainerPageBean m_page;
    private Map<?, ?> m_byContainer;
    private Map<?, ?> m_byType;
    private boolean m_undefined;
    private CmsObject m_cms;

    public CmsJspContentAttachmentsBean() {
        this.m_page = new CmsContainerPageBean(new ArrayList<CmsContainerBean>());
        this.m_undefined = true;
    }

    public CmsJspContentAttachmentsBean(CmsObject cms, CmsResource pageResource) throws CmsException {
        CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, pageResource);
        this.m_page = xmlContainerPage.getContainerPage(cms);
        this.m_cms = cms;
    }

    public static List<String> getAttachmentLocales(CmsObject cms, CmsResource content) {
        List<CmsResource> detailOnlyResources = CmsDetailOnlyContainerUtil.getDetailOnlyResources(cms, content);
        HashSet validLocaleNames = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            validLocaleNames.add(locale.toString());
        }
        validLocaleNames.add("ALL");
        for (CmsResource resource : detailOnlyResources) {
            String parent = CmsResource.getParentFolder(resource.getRootPath());
            String parentName = CmsResource.getName(parent);
            if (!validLocaleNames.contains(parentName = CmsFileUtil.removeTrailingSeparator(parentName))) continue;
            result.add(parentName);
        }
        return result;
    }

    public static CmsJspContentAttachmentsBean getAttachmentsForCurrentPage(CmsObject cms, CmsResource content) throws CmsException {
        CmsResource page = cms.readResource(cms.getRequestContext().getUri(), CmsResourceFilter.IGNORE_EXPIRATION);
        String locale = CmsDetailOnlyContainerUtil.getDetailContainerLocale(cms, cms.getRequestContext().getLocale().toString(), page);
        Optional<CmsResource> detailOnly = CmsDetailOnlyContainerUtil.getDetailOnlyPage(cms, content, locale);
        if (detailOnly.isPresent()) {
            try {
                return new CmsJspContentAttachmentsBean(cms, (CmsResource)detailOnly.get());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return new CmsJspContentAttachmentsBean();
            }
        }
        return new CmsJspContentAttachmentsBean();
    }

    public static CmsJspContentAttachmentsBean getAttachmentsForLocale(CmsObject cms, CmsResource content, String locale) {
        Optional<CmsResource> detailOnly = CmsDetailOnlyContainerUtil.getDetailOnlyPage(cms, content, locale);
        if (!detailOnly.isPresent()) {
            return new CmsJspContentAttachmentsBean();
        }
        try {
            return new CmsJspContentAttachmentsBean(cms, (CmsResource)detailOnly.get());
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJspContentAttachmentsBean();
        }
    }

    public Map<?, ?> getByContainer() {
        if (this.m_byContainer == null) {
            this.m_byContainer = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object arg0) {
                    String key = (String)arg0;
                    CmsContainerBean container = CmsJspContentAttachmentsBean.this.m_page.getContainers().get(key);
                    if (container == null) {
                        return Collections.emptyList();
                    }
                    return container.getElements();
                }
            });
        }
        return this.m_byContainer;
    }

    public Map<?, ?> getByType() {
        if (this.m_byType == null) {
            this.m_byType = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object arg0) {
                    String key = (String)arg0;
                    ArrayList result = Lists.newArrayList();
                    for (Map.Entry<String, CmsContainerBean> entry : CmsJspContentAttachmentsBean.this.getPage().getContainers().entrySet()) {
                        CmsContainerBean value = entry.getValue();
                        for (CmsContainerElementBean element : value.getElements()) {
                            try {
                                element.initResource(CmsJspContentAttachmentsBean.this.m_cms);
                                if (!key.equals(element.getTypeName())) continue;
                                result.add(element);
                            }
                            catch (CmsException e) {
                                LOG.error((Object)("Could not initialize resource with site path \"" + element.getSitePath() + "\" to determine the container elements type."), (Throwable)e);
                            }
                        }
                    }
                    return result;
                }
            });
        }
        return this.m_byType;
    }

    public Set<String> getContainers() {
        return Sets.newHashSet(this.m_page.getContainers().keySet());
    }

    public boolean isUndefined() {
        return this.m_undefined;
    }

    protected CmsContainerPageBean getPage() {
        return this.m_page;
    }
}

