/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspInstanceDateBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.widgets.serialdate.CmsSerialDateBeanFactory;
import org.opencms.widgets.serialdate.CmsSerialDateValue;
import org.opencms.widgets.serialdate.I_CmsSerialDateBean;

public class CmsJspDateSeriesBean {
    private static final Log LOG = CmsLog.getLog(CmsJspDateSeriesBean.class);
    private Long m_duration;
    private CmsJspInstanceDateBean m_firstEvent;
    private Boolean m_isMultiDay;
    private CmsJspInstanceDateBean m_lastEvent;
    private Locale m_locale;
    private CmsJspDateSeriesBean m_parentSeries;
    private I_CmsSerialDateValue m_seriesDefinition;
    private Map<Object, CmsJspInstanceDateBean> m_singleEvents;
    private CmsJspContentAccessValueWrapper m_value;
    SortedSet<Date> m_dates;

    public CmsJspDateSeriesBean(CmsJspContentAccessValueWrapper value, Locale locale) {
        this.m_value = value;
        this.m_locale = null == locale ? this.m_value.getLocale() : locale;
        this.initFromSeriesDefinition(value.toString());
    }

    CmsJspDateSeriesBean(String seriesDefinition, Locale locale) {
        this.m_locale = locale;
        this.initFromSeriesDefinition(seriesDefinition);
    }

    public List<Date> getDates() {
        return new ArrayList<Date>(this.m_dates);
    }

    public CmsJspInstanceDateBean getFirst() {
        if (this.m_firstEvent == null && this.m_dates != null && !this.m_dates.isEmpty()) {
            this.m_firstEvent = new CmsJspInstanceDateBean((Date)this.m_dates.first().clone(), this);
        }
        return this.m_firstEvent;
    }

    public Long getInstanceDuration() {
        return this.m_duration;
    }

    public Map<Object, CmsJspInstanceDateBean> getInstanceInfo() {
        if (this.m_singleEvents == null) {
            this.m_singleEvents = CmsCollectionsGenericWrapper.createLazyMap(new CmsSeriesSingleEventTransformer());
        }
        return this.m_singleEvents;
    }

    public boolean getIsExtractedDate() {
        return Objects.equal((Object)((Object)this.m_seriesDefinition.getDateType()), (Object)((Object)I_CmsSerialDateValue.DateType.EXTRACTED));
    }

    public boolean getIsSeries() {
        return Objects.equal((Object)((Object)this.m_seriesDefinition.getDateType()), (Object)((Object)I_CmsSerialDateValue.DateType.SERIES));
    }

    public boolean getIsSingleDate() {
        return Objects.equal((Object)((Object)this.m_seriesDefinition.getDateType()), (Object)((Object)I_CmsSerialDateValue.DateType.SINGLE));
    }

    public CmsJspInstanceDateBean getLast() {
        if (this.m_lastEvent == null && this.m_dates != null && !this.m_dates.isEmpty()) {
            this.m_lastEvent = new CmsJspInstanceDateBean((Date)this.m_dates.last().clone(), this);
        }
        return this.m_lastEvent;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CmsJspInstanceDateBean getNext() {
        return this.getNextFor(new Date());
    }

    public CmsJspInstanceDateBean getNextFor(Object date) {
        Date d = this.toDate(date);
        if (d != null && this.m_dates != null && !this.m_dates.isEmpty()) {
            for (Date instanceDate : this.m_dates) {
                if (instanceDate.before(d)) continue;
                return new CmsJspInstanceDateBean((Date)instanceDate.clone(), this);
            }
        }
        return this.getLast();
    }

    public CmsJspDateSeriesBean getParentSeries() {
        if (this.m_parentSeries == null && this.getIsExtractedDate()) {
            CmsObject cms = this.m_value.getCmsObject();
            try {
                CmsResource res = cms.readResource(this.m_seriesDefinition.getParentSeriesId());
                CmsJspContentAccessBean content = new CmsJspContentAccessBean(cms, this.m_value.getLocale(), res);
                CmsJspContentAccessValueWrapper value = content.getValue().get(this.m_value.getPath());
                return new CmsJspDateSeriesBean(value, this.m_locale);
            }
            catch (NullPointerException | CmsException e) {
                LOG.warn((Object)("Parent series with id " + this.m_seriesDefinition.getParentSeriesId() + " could not be read."), (Throwable)e);
            }
        }
        return null;
    }

    public CmsJspInstanceDateBean getPrevious() {
        return this.getPreviousFor(new Date());
    }

    public CmsJspInstanceDateBean getPreviousFor(Object date) {
        Date d = this.toDate(date);
        if (d != null && this.m_dates != null && !this.m_dates.isEmpty()) {
            Date lastDate = this.m_dates.first();
            for (Date instanceDate : this.m_dates) {
                if (instanceDate.after(d)) {
                    return new CmsJspInstanceDateBean((Date)lastDate.clone(), this);
                }
                lastDate = instanceDate;
            }
            return new CmsJspInstanceDateBean((Date)lastDate.clone(), this);
        }
        return this.getLast();
    }

    public String getTitle() {
        try {
            CmsGallerySearchResult result = CmsGallerySearch.searchById(this.m_value.getCmsObject(), this.m_value.getContentValue().getDocument().getFile().getStructureId(), this.m_value.getLocale());
            return result.getTitle();
        }
        catch (CmsException e) {
            LOG.warn((Object)"Could not retrieve title of series content.", (Throwable)e);
            return "";
        }
    }

    public boolean isMultiDay() {
        if (this.m_isMultiDay != null) {
            return this.m_isMultiDay;
        }
        Long instanceDuration = this.getInstanceDuration();
        if (null == instanceDuration || instanceDuration == 0L) {
            this.m_isMultiDay = Boolean.FALSE;
            return false;
        }
        if (this.getInstanceDuration() > 86400000L) {
            this.m_isMultiDay = Boolean.TRUE;
            return true;
        }
        if (this.isWholeDay() && this.getInstanceDuration() <= 86400000L) {
            this.m_isMultiDay = Boolean.FALSE;
            return false;
        }
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(this.m_seriesDefinition.getStart());
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(this.m_seriesDefinition.getEnd());
        if (start.get(5) == end.get(5)) {
            this.m_isMultiDay = Boolean.FALSE;
            return false;
        }
        this.m_isMultiDay = Boolean.TRUE;
        return true;
    }

    public boolean isWholeDay() {
        return this.m_seriesDefinition.isWholeDay();
    }

    public Date toDate(Object date) {
        Date d = null;
        if (null != date) {
            if (date instanceof Date) {
                d = (Date)date;
            } else if (date instanceof Long) {
                d = new Date((Long)date);
            } else {
                try {
                    long l = Long.parseLong(date.toString());
                    d = new Date(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return d;
    }

    private void initFromSeriesDefinition(String seriesDefinition) {
        String seriesDefinitionString = seriesDefinition;
        this.m_seriesDefinition = new CmsSerialDateValue(seriesDefinitionString);
        if (this.m_seriesDefinition.isValid()) {
            I_CmsSerialDateBean bean = CmsSerialDateBeanFactory.createSerialDateBean(this.m_seriesDefinition);
            this.m_dates = bean.getDates();
            this.m_duration = bean.getEventDuration();
        } else {
            try {
                throw new Exception("Could not read series definition: " + seriesDefinitionString);
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.m_dates = new TreeSet<Date>();
            }
        }
    }

    public class CmsSeriesSingleEventTransformer
    implements Transformer {
        public Object transform(Object date) {
            Date d = CmsJspDateSeriesBean.this.toDate(date);
            if (null != d && CmsJspDateSeriesBean.this.m_dates.contains(d)) {
                return new CmsJspInstanceDateBean((Date)d.clone(), CmsJspDateSeriesBean.this);
            }
            if (!CmsJspDateSeriesBean.this.m_dates.isEmpty()) {
                return CmsJspDateSeriesBean.this.getFirst();
            }
            return null;
        }
    }
}

