/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opencms.jsp.util.I_CmsJspDeviceSelector;
import org.opencms.jsp.util.UAgentInfo;
import org.opencms.loader.CmsTemplateContext;

public class CmsJspDeviceSelectorDesktopMobileTablet
implements I_CmsJspDeviceSelector {
    public static final String C_DESKTOP = "desktop";
    public static final String C_MOBILE = "mobile";
    public static final String C_TABLET = "tablet";
    public static final List<String> TYPES = Arrays.asList("mobile", "desktop", "tablet");
    private UAgentInfo m_userAgentInfo;

    @Override
    public String getDeviceType(HttpServletRequest req) {
        CmsTemplateContext templateContext = (CmsTemplateContext)req.getAttribute("templateContext");
        if (templateContext != null && this.isTemplateContextCompatible(templateContext)) {
            return templateContext.getKey();
        }
        this.m_userAgentInfo = new UAgentInfo(req.getHeader("user-agent"), req.getHeader("Accept"));
        if (this.m_userAgentInfo.detectMobileQuick()) {
            return C_MOBILE;
        }
        if (this.m_userAgentInfo.getIsTierTablet()) {
            return C_TABLET;
        }
        return C_DESKTOP;
    }

    @Override
    public List<String> getDeviceTypes() {
        return TYPES;
    }

    public UAgentInfo getUserAgentInfo() {
        return this.m_userAgentInfo;
    }

    protected boolean isTemplateContextCompatible(CmsTemplateContext templateContext) {
        HashSet<String> contextKeys = new HashSet<String>(templateContext.getProvider().getAllContexts().keySet());
        return contextKeys.equals(new HashSet<String>(TYPES));
    }
}

