/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.shared.CmsPoint;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUriSplitter;

public class CmsJspImageBean {
    public static int MIN_DIMENSION = 4;
    static final Log LOG = CmsLog.getLog(CmsJspImageBean.class);
    static final double[] m_sizeVariants = new double[]{1.0, 0.75, 0.5, 0.375, 0.25, 0.125};
    CmsJspResourceWrapper m_resource = null;
    Map<String, CmsJspImageBean> m_scaleRatio = null;
    Map<String, CmsJspImageBean> m_scaleWidth = null;
    TreeMap<Integer, CmsJspImageBean> m_srcSet = null;
    private CmsImageScaler m_baseScaler;
    private CmsObject m_cms = null;
    private CmsImageScaler m_currentScaler;
    private Map<String, CmsJspImageBean> m_hiDpiImages = null;
    private CmsImageScaler m_originalScaler;
    private int m_quality = 0;
    private String m_vfsUri;
    private String m_ratio;
    private String m_ratioHeightPercentage;

    public CmsJspImageBean(CmsObject cms, CmsResource imageRes, String scaleParams) {
        this.init(cms, imageRes, scaleParams);
    }

    public CmsJspImageBean(CmsObject cms, String imageUri) throws CmsException {
        String[] scaleStr;
        this.setCmsObject(cms);
        CmsUriSplitter splitSrc = new CmsUriSplitter(imageUri);
        String scaleParam = null;
        if (splitSrc.getQuery() != null && (scaleStr = CmsRequestUtil.createParameterMap(splitSrc.getQuery()).get("__scale")) != null) {
            scaleParam = scaleStr[0];
        }
        this.init(cms, cms.readResource(splitSrc.getPrefix()), scaleParam);
    }

    public CmsJspImageBean(CmsObject cms, String imageUri, CmsImageScaler initScaler) throws CmsException {
        this(cms, imageUri);
        CmsImageScaler targetScaler = CmsJspImageBean.createVariation(this.getWidth(), this.getHeight(), this.getBaseScaler(), initScaler.getWidth(), initScaler.getHeight(), this.getQuality());
        if (targetScaler != null && targetScaler.isValid()) {
            this.setScaler(targetScaler);
        }
    }

    protected CmsJspImageBean() {
    }

    protected static CmsImageScaler createVariation(int originalWidth, int originalHeight, CmsImageScaler baseScaler, int targetWidth, int targetHeight, int quality) {
        CmsImageScaler result = null;
        if (targetWidth <= 0 || targetHeight <= 0) {
            double baseRatio = baseScaler.isCropping() ? (double)baseScaler.getCropWidth() / (double)baseScaler.getCropHeight() : (double)originalWidth / (double)originalHeight;
            if (targetWidth <= 0) {
                targetWidth = (int)Math.round((double)targetHeight * baseRatio);
            } else if (targetHeight <= 0) {
                targetHeight = (int)Math.round((double)targetWidth / baseRatio);
            }
        }
        if (targetWidth >= MIN_DIMENSION && targetHeight >= MIN_DIMENSION && originalWidth >= targetWidth && originalHeight >= targetHeight) {
            result = new CmsImageScaler();
            result.setWidth(targetWidth);
            result.setHeight(targetHeight);
            if (baseScaler.getFocalPoint() != null && CmsJspImageBean.checkCropRegionContainsFocalPoint(baseScaler, baseScaler.getFocalPoint())) {
                result.setType(8);
                if (baseScaler.isCropping()) {
                    result.setCropArea(baseScaler.getCropX(), baseScaler.getCropY(), baseScaler.getCropWidth(), baseScaler.getCropHeight());
                } else {
                    result.setCropArea(0, 0, originalWidth, originalHeight);
                }
            } else {
                result.setType(2);
                if (baseScaler.isCropping()) {
                    double targetRatio = (double)baseScaler.getCropWidth() / (double)targetWidth;
                    int targetCropWidth = baseScaler.getCropWidth();
                    int targetCropHeight = (int)Math.round((double)targetHeight * targetRatio);
                    if (targetCropHeight > baseScaler.getCropHeight()) {
                        targetRatio = (double)baseScaler.getCropHeight() / (double)targetHeight;
                        targetCropWidth = (int)Math.round((double)targetWidth * targetRatio);
                        targetCropHeight = baseScaler.getCropHeight();
                    }
                    int targetX = baseScaler.getCropX();
                    int targetY = baseScaler.getCropY();
                    if (targetCropWidth != baseScaler.getCropWidth()) {
                        targetX += (int)Math.round((double)(baseScaler.getCropWidth() - targetCropWidth) / 2.0);
                    }
                    if (targetCropHeight != baseScaler.getCropHeight()) {
                        targetY += (int)Math.round((double)(baseScaler.getCropHeight() - targetCropHeight) / 2.0);
                    }
                    result.setCropArea(targetX, targetY, targetCropWidth, targetCropHeight);
                }
            }
        }
        if (result != null && quality > 0) {
            result.setQuality(quality);
        }
        return result;
    }

    private static boolean checkCropRegionContainsFocalPoint(CmsImageScaler scaler, CmsPoint focalPoint) {
        if (!scaler.isCropping()) {
            return true;
        }
        double x = focalPoint.getX();
        double y = focalPoint.getY();
        return (double)scaler.getCropX() <= x && x < (double)(scaler.getCropX() + scaler.getCropWidth()) && (double)scaler.getCropY() <= y && y < (double)(scaler.getCropY() + scaler.getCropHeight());
    }

    public void addHiDpiImage(String factor, CmsJspImageBean image) {
        if (this.m_hiDpiImages == null) {
            this.m_hiDpiImages = CmsCollectionsGenericWrapper.createLazyMap(new CmsScaleHiDpiTransformer());
        }
        this.m_hiDpiImages.put(factor, image);
    }

    public void addSrcSetWidthVariants(int minWidth, int maxWidth) {
        int imageWidth = this.getWidth();
        if (imageWidth > minWidth) {
            double factor;
            long width;
            int srcSetMaxWidth = this.getSrcSetMaxWidth();
            double[] dArray = m_sizeVariants;
            int n = dArray.length;
            for (int i = 0; i < n && (width = Math.round((double)imageWidth * (factor = dArray[i]))) > (long)srcSetMaxWidth; ++i) {
                if (width > (long)maxWidth) continue;
                this.setSrcSets(this.createWidthVariation(String.valueOf(width)));
            }
        }
    }

    public CmsJspImageBean createHiDpiVariation(String hiDpiStr) {
        CmsJspImageBean result = null;
        if (hiDpiStr.matches("^[0-9]+(.[0-9]+)?x$")) {
            double multiplier = Double.valueOf(hiDpiStr.substring(0, hiDpiStr.length() - 1));
            int targetWidth = (int)Math.round((double)this.getScaler().getWidth() * multiplier);
            int targetHeight = (int)Math.round((double)this.getScaler().getHeight() * multiplier);
            CmsImageScaler targetScaler = CmsJspImageBean.createVariation(this.getWidth(), this.getHeight(), this.getBaseScaler(), targetWidth, targetHeight, this.getQuality());
            if (targetScaler != null) {
                result = this.createVariation(targetScaler);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)String.format("Illegal multiplier format: '%s' not usable for image scaling", hiDpiStr));
        }
        return result;
    }

    public CmsJspImageBean createRatioVariation(String ratioStr) {
        CmsJspImageBean result;
        block5: {
            result = null;
            try {
                int i = ratioStr.indexOf(45);
                if (i > 0) {
                    CmsImageScaler targetScaler;
                    ratioStr = ratioStr.replace(',', '.');
                    double ratioW = Double.valueOf(ratioStr.substring(0, i));
                    double ratioH = Double.valueOf(ratioStr.substring(i + 1));
                    double ratioFactorW = (double)this.getScaler().getWidth() / ratioW;
                    int targetWidth = this.getScaler().getWidth();
                    int targetHeight = (int)Math.round(ratioH * ratioFactorW);
                    if (targetHeight > this.getScaler().getHeight()) {
                        double ratioFactorH = (double)this.getScaler().getHeight() / ratioH;
                        targetWidth = (int)Math.round(ratioW * ratioFactorH);
                        targetHeight = this.getScaler().getHeight();
                    }
                    if ((targetScaler = CmsJspImageBean.createVariation(this.getWidth(), this.getHeight(), this.getBaseScaler(), targetWidth, targetHeight, this.getQuality())) != null) {
                        result = this.createVariation(targetScaler);
                        result.m_ratio = ratioStr;
                        result.m_ratioHeightPercentage = this.calcRatioHeightPercentage(ratioW, ratioH);
                    }
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block5;
                LOG.warn((Object)String.format("Illegal ratio format: '%s' not usable for image scaling", ratioStr));
            }
        }
        return result;
    }

    public CmsJspImageBean createWidthVariation(String widthStr) {
        CmsJspImageBean result;
        block3: {
            result = null;
            try {
                double baseRatio = this.getOriginalScaler().getFocalPoint() != null && CmsJspImageBean.checkCropRegionContainsFocalPoint(this.getScaler(), this.getOriginalScaler().getFocalPoint()) ? (double)this.getScaler().getWidth() / (double)this.getScaler().getHeight() : (this.getScaler().isCropping() ? (double)this.getScaler().getCropWidth() / (double)this.getScaler().getCropHeight() : (double)this.getScaler().getWidth() / (double)this.getScaler().getHeight());
                int targetWidth = Integer.valueOf(widthStr);
                int targetHeight = (int)Math.round((double)targetWidth / baseRatio);
                CmsImageScaler targetScaler = CmsJspImageBean.createVariation(this.getWidth(), this.getHeight(), this.getBaseScaler(), targetWidth, targetHeight, this.getQuality());
                if (targetScaler != null) {
                    result = this.createVariation(targetScaler);
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)String.format("Illegal width format: '%s' not usable for image scaling", widthStr));
            }
        }
        return result;
    }

    public int getHeight() {
        return this.m_originalScaler.getHeight();
    }

    @Deprecated
    public Map<String, CmsJspImageBean> getHiDpiImages() {
        return this.getScaleHiDpi();
    }

    public String getImgSrc() {
        StringBuffer result = new StringBuffer(128);
        result.append("src=\"");
        result.append(this.getSrcUrl());
        result.append("\"");
        result.append(" width=\"");
        result.append(this.m_currentScaler.getWidth());
        result.append("\"");
        result.append(" height=\"");
        result.append(this.m_currentScaler.getHeight());
        result.append("\"");
        return result.toString();
    }

    public int getQuality() {
        return this.m_quality;
    }

    public String getRatio() {
        if (this.m_ratio == null) {
            this.m_ratio = "" + this.getScaler().getWidth() + "-" + this.getScaler().getHeight();
        }
        return this.m_ratio;
    }

    public String getRatioHeightPercentage() {
        if (this.m_ratioHeightPercentage == null) {
            this.m_ratioHeightPercentage = this.calcRatioHeightPercentage(this.getScaler().getWidth(), this.getScaler().getHeight());
        }
        return this.m_ratioHeightPercentage;
    }

    public CmsJspResourceWrapper getResource() {
        return this.m_resource;
    }

    public Map<String, CmsJspImageBean> getScaleHiDpi() {
        if (this.m_hiDpiImages == null) {
            this.m_hiDpiImages = CmsCollectionsGenericWrapper.createLazyMap(new CmsScaleHiDpiTransformer());
        }
        return this.m_hiDpiImages;
    }

    public CmsImageScaler getScaler() {
        return this.m_currentScaler;
    }

    public Map<String, CmsJspImageBean> getScaleRatio() {
        if (this.m_scaleRatio == null) {
            this.m_scaleRatio = CmsCollectionsGenericWrapper.createLazyMap(new CmsScaleRatioTransformer());
        }
        return this.m_scaleRatio;
    }

    public Map<String, CmsJspImageBean> getScaleWidth() {
        if (this.m_scaleWidth == null) {
            this.m_scaleWidth = CmsCollectionsGenericWrapper.createLazyMap(new CmsScaleWidthTransformer());
        }
        return this.m_scaleWidth;
    }

    public String getSrcSet() {
        StringBuffer result = new StringBuffer(128);
        if (this.m_srcSet != null) {
            int items = this.m_srcSet.size();
            for (Map.Entry<Integer, CmsJspImageBean> entry : this.m_srcSet.entrySet()) {
                CmsJspImageBean imageBean = entry.getValue();
                result.append(imageBean.getSrcUrl());
                result.append(" ");
                result.append(imageBean.getScaler().getWidth());
                result.append("w");
                if (--items <= 0) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    public String getSrcSetEntry() {
        StringBuffer result = new StringBuffer(128);
        if (this.m_currentScaler.isValid()) {
            result.append(this.getSrcUrl());
            result.append(" ");
            result.append(this.m_currentScaler.getWidth());
            result.append("w");
        }
        return result.toString();
    }

    public Map<Integer, CmsJspImageBean> getSrcSetMap() {
        return this.m_srcSet;
    }

    public CmsJspImageBean getSrcSetMaxImage() {
        CmsJspImageBean result = this;
        if (this.m_srcSet != null) {
            result = this.m_srcSet.lastEntry().getValue();
        }
        return result;
    }

    public int getSrcSetMaxWidth() {
        int result = 0;
        if (this.m_srcSet != null && this.m_srcSet.size() > 0) {
            result = this.m_srcSet.lastKey();
        }
        return result;
    }

    public CmsJspImageBean getSrcSets() {
        return this;
    }

    public String getSrcUrl() {
        String imageSrc = this.getCmsObject().getSitePath(this.getResource());
        if (this.getScaler() != null && this.getScaler().isValid()) {
            imageSrc = imageSrc + this.getScaler().toRequestParam();
        }
        return OpenCms.getLinkManager().substituteLink(this.getCmsObject(), imageSrc);
    }

    public String getVfsUri() {
        return this.m_vfsUri;
    }

    public int getWidth() {
        return this.m_originalScaler.getWidth();
    }

    public boolean isImage() {
        return this.getOriginalScaler().isValid();
    }

    public boolean isScaled() {
        return !this.m_currentScaler.isOriginalScaler();
    }

    public void setQuality(int quality) {
        this.m_quality = quality;
        this.getScaler().setQuality(this.m_quality);
    }

    public void setSrcSetQuality() {
        if (this.m_srcSet != null) {
            for (Map.Entry<Integer, CmsJspImageBean> entry : this.m_srcSet.entrySet()) {
                CmsJspImageBean imageBean = entry.getValue();
                long pixel = imageBean.getScaler().getWidth() * imageBean.getScaler().getWidth();
                int quality = pixel > 960000L ? 75 : (pixel > 786432L ? 80 : 85);
                imageBean.setQuality(quality);
            }
        }
    }

    public void setSrcSets(CmsJspImageBean imageBean) {
        if (this.m_srcSet == null) {
            this.m_srcSet = new TreeMap();
        }
        if (imageBean != null && imageBean.getScaler().isValid()) {
            this.m_srcSet.put(imageBean.getScaler().getWidth(), imageBean);
        }
    }

    public void setVfsUri(String vfsUri) {
        this.m_vfsUri = vfsUri;
    }

    public String toString() {
        return this.getSrcUrl();
    }

    protected String calcRatioHeightPercentage(double width, double height) {
        double p = (double)Math.round(height / width * 1.0E7) / 100000.0;
        return String.valueOf(p) + "%";
    }

    protected CmsJspImageBean createVariation(CmsImageScaler targetScaler) {
        CmsJspImageBean result = new CmsJspImageBean();
        result.setCmsObject(this.getCmsObject());
        result.setResource(this.getCmsObject(), this.getResource());
        result.setOriginalScaler(this.getOriginalScaler());
        result.setBaseScaler(this.getBaseScaler());
        result.setVfsUri(this.getVfsUri());
        result.setScaler(targetScaler);
        result.setQuality(this.getQuality());
        return result;
    }

    protected CmsImageScaler getBaseScaler() {
        return this.m_baseScaler;
    }

    protected CmsObject getCmsObject() {
        return this.m_cms;
    }

    protected CmsImageScaler getOriginalScaler() {
        return this.m_originalScaler;
    }

    protected CmsJspImageBean getSelf() {
        return this;
    }

    protected void init(CmsObject cms, CmsResource imageRes, String scaleParams) {
        this.setCmsObject(cms);
        this.setResource(cms, imageRes);
        this.setVfsUri(cms.getRequestContext().getSitePath(imageRes));
        CmsImageScaler originalScaler = new CmsImageScaler(cms, this.getResource());
        this.setOriginalScaler(originalScaler);
        CmsImageScaler baseScaler = originalScaler;
        if (scaleParams != null) {
            baseScaler = new CmsImageScaler(scaleParams);
            baseScaler.setFocalPoint(originalScaler.getFocalPoint());
        }
        this.setBaseScaler(baseScaler);
        this.setScaler(baseScaler);
    }

    protected void setBaseScaler(CmsImageScaler baseScaler) {
        this.m_baseScaler = baseScaler;
    }

    protected void setCmsObject(CmsObject cms) {
        this.m_cms = cms;
    }

    protected void setOriginalScaler(CmsImageScaler originalScaler) {
        this.m_originalScaler = originalScaler;
    }

    protected void setResource(CmsObject cms, CmsResource resource) {
        this.m_resource = CmsJspResourceWrapper.wrap(cms, resource);
    }

    protected void setScaler(CmsImageScaler scaler) {
        this.m_currentScaler = scaler;
    }

    public class CmsScaleWidthTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspImageBean.this.createWidthVariation(String.valueOf(input));
        }
    }

    public class CmsScaleRatioTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspImageBean.this.createRatioVariation(String.valueOf(input));
        }
    }

    public class CmsScaleHiDpiTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspImageBean.this.createHiDpiVariation(String.valueOf(input));
        }
    }
}

