/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.LocaleUtils;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsCollectionsGenericWrapper;

public final class CmsJspValueTransformers {
    private CmsJspValueTransformers() {
    }

    public static final class CmsPropertyLoaderTransformer
    implements Transformer {
        private CmsObject m_cms;
        private CmsResource m_res;
        private Locale m_locale;
        private boolean m_search;

        public CmsPropertyLoaderTransformer(CmsObject cms, CmsResource resource, boolean search) {
            this.m_cms = cms;
            this.m_res = resource;
            this.m_search = search;
        }

        public CmsPropertyLoaderTransformer(CmsObject cms, CmsResource resource, boolean search, Locale locale) {
            this.m_cms = cms;
            this.m_res = resource;
            this.m_locale = locale;
            this.m_search = search;
        }

        public Object transform(Object input) {
            String result;
            try {
                result = this.m_cms.readPropertyObject(this.m_res, String.valueOf(input), this.m_search, this.m_locale).getValue();
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    public static final class CmsLocalePropertyLoaderTransformer
    implements Transformer {
        private CmsObject m_cms;
        private CmsResource m_res;
        private Map<Locale, Map<String, String>> m_localeProperties;
        private boolean m_search;

        public CmsLocalePropertyLoaderTransformer(CmsObject cms, CmsResource resource, boolean search) {
            this.m_cms = cms;
            this.m_res = resource;
            this.m_search = search;
            this.m_localeProperties = new HashMap<Locale, Map<String, String>>();
        }

        public Object transform(Object inputLocale) {
            Locale locale = null;
            if (null != inputLocale) {
                if (inputLocale instanceof Locale) {
                    locale = (Locale)inputLocale;
                } else if (inputLocale instanceof String) {
                    try {
                        locale = LocaleUtils.toLocale((String)((String)inputLocale));
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
            }
            if (this.m_localeProperties.get(locale) == null) {
                Map lazyMap = CmsCollectionsGenericWrapper.createLazyMap(new CmsPropertyLoaderTransformer(this.m_cms, this.m_res, this.m_search, locale));
                this.m_localeProperties.put(locale, lazyMap);
            }
            return this.m_localeProperties.get(locale);
        }
    }
}

