/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import com.alkacon.simapi.RenderSettings;
import com.alkacon.simapi.Simapi;
import com.alkacon.simapi.filter.GrayscaleFilter;
import com.alkacon.simapi.filter.ShadowFilter;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsPreviewService;
import org.opencms.ade.galleries.shared.CmsPoint;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.loader.CmsImageLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsImageScaler {
    public static final String COLOR_TRANSPARENT = "transparent";
    public static final String FILTER_GRAYSCALE = "grayscale";
    public static final String FILTER_SHADOW = "shadow";
    public static final List<String> FILTERS = Arrays.asList("grayscale", "shadow");
    public static final String PARAM_SCALE = "__scale";
    public static final int SCALE_DEFAULT_MAX_BLUR_SIZE = 6250000;
    public static final int SCALE_DEFAULT_MAX_SIZE = 2500;
    public static final String SCALE_PARAM_COLOR = "c";
    public static final String SCALE_PARAM_CROP_HEIGHT = "ch";
    public static final String SCALE_PARAM_CROP_WIDTH = "cw";
    public static final String SCALE_PARAM_CROP_X = "cx";
    public static final String SCALE_PARAM_CROP_Y = "cy";
    public static final String SCALE_PARAM_FILTER = "f";
    public static final String SCALE_PARAM_HEIGHT = "h";
    public static final String SCALE_PARAM_POS = "p";
    public static final String SCALE_PARAM_QUALITY = "q";
    public static final String SCALE_PARAM_RENDERMODE = "r";
    public static final String SCALE_PARAM_TYPE = "t";
    public static final String SCALE_PARAM_WIDTH = "w";
    protected static final Log LOG = CmsLog.getLog(CmsImageScaler.class);
    private Color m_color;
    private int m_cropHeight;
    private int m_cropWidth;
    private int m_cropX;
    private int m_cropY;
    private List<String> m_filters;
    private CmsPoint m_focalPoint;
    private int m_height;
    private boolean m_isOriginalScaler;
    private int m_maxBlurSize;
    private int m_maxHeight;
    private int m_maxWidth;
    private int m_position;
    private int m_quality;
    private int m_renderMode;
    private String m_scaleParameters;
    private int m_type;
    private int m_width;

    public CmsImageScaler() {
        this.init();
    }

    public CmsImageScaler(byte[] content, String rootPath) {
        this.init();
        try {
            BufferedImage image = Simapi.read((byte[])content);
            this.m_height = image.getHeight();
            this.m_width = image.getWidth();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_EXTRACT_IMAGE_SIZE_1", rootPath), (Throwable)e);
            }
            this.init();
        }
    }

    public CmsImageScaler(CmsImageScaler base, int width, int height) {
        this.initValuesFrom(base);
        this.setWidth(width);
        this.setHeight(height);
    }

    public CmsImageScaler(CmsObject cms, CmsResource res) {
        this.init();
        this.m_isOriginalScaler = true;
        String sizeValue = null;
        if (cms != null && res != null) {
            try {
                CmsProperty sizeProp = cms.readPropertyObject(res, "image.size", false);
                if (!sizeProp.isNullProperty()) {
                    sizeValue = sizeProp.getValue();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            try {
                this.m_focalPoint = CmsPreviewService.readFocalPoint(cms, res);
            }
            catch (Exception e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isNotEmpty(sizeValue)) {
            this.parseParameters(sizeValue);
        }
    }

    public CmsImageScaler(HttpServletRequest request, int maxScaleSize, int maxBlurSize) {
        this.init();
        this.m_maxBlurSize = maxBlurSize;
        String parameters = request.getParameter(PARAM_SCALE);
        if (CmsStringUtil.isNotEmpty(parameters)) {
            this.parseParameters(parameters);
            if (this.isValid() && (this.getWidth() > maxScaleSize || this.getHeight() > maxScaleSize)) {
                this.init();
            }
        }
    }

    public CmsImageScaler(String parameters) {
        this.init();
        if (CmsStringUtil.isNotEmpty(parameters)) {
            this.parseParameters(parameters);
        }
    }

    public static int[] calculateDimension(int sourceWidth, int sourceHeight, int boxWidth, int boxHeight) {
        int[] result = new int[2];
        if (sourceWidth <= boxWidth && sourceHeight <= boxHeight) {
            result[0] = sourceWidth;
            result[1] = sourceHeight;
        } else {
            float scaleWidth = (float)boxWidth / (float)sourceWidth;
            float scaleHeight = (float)boxHeight / (float)sourceHeight;
            float scale = Math.min(scaleHeight, scaleWidth);
            result[0] = Math.round((float)sourceWidth * scale);
            result[1] = Math.round((float)sourceHeight * scale);
        }
        return result;
    }

    public void addFilter(String filter) {
        if (CmsStringUtil.isNotEmpty(filter) && FILTERS.contains(filter = filter.trim().toLowerCase())) {
            this.m_filters.add(filter);
        }
    }

    public Object clone() {
        CmsImageScaler clone = new CmsImageScaler();
        clone.initValuesFrom(this);
        return clone;
    }

    public Color getColor() {
        return this.m_color;
    }

    public String getColorString() {
        StringBuffer result = new StringBuffer();
        if (this.m_color == Simapi.COLOR_TRANSPARENT) {
            result.append(COLOR_TRANSPARENT);
        } else {
            if (this.m_color.getRed() < 16) {
                result.append('0');
            }
            result.append(Integer.toString(this.m_color.getRed(), 16));
            if (this.m_color.getGreen() < 16) {
                result.append('0');
            }
            result.append(Integer.toString(this.m_color.getGreen(), 16));
            if (this.m_color.getBlue() < 16) {
                result.append('0');
            }
            result.append(Integer.toString(this.m_color.getBlue(), 16));
        }
        return result.toString();
    }

    public int getCropHeight() {
        return this.m_cropHeight;
    }

    public CmsImageScaler getCropScaler(CmsImageScaler target) {
        CmsImageScaler result = this.getReScaler(target);
        result.setCropArea(this.m_cropX, this.m_cropY, this.m_cropWidth, this.m_cropHeight);
        return result;
    }

    public int getCropWidth() {
        return this.m_cropWidth;
    }

    public int getCropX() {
        return this.m_cropX;
    }

    public int getCropY() {
        return this.m_cropY;
    }

    public CmsImageScaler getDownScaler(CmsImageScaler downScaler) {
        int width;
        if (!this.isDownScaleRequired(downScaler)) {
            return null;
        }
        int downHeight = downScaler.getHeight();
        int downWidth = downScaler.getWidth();
        int height = this.getHeight();
        if (height > (width = this.getWidth()) && downHeight < downWidth || width > height && downWidth < downHeight) {
            downHeight = downWidth;
            downWidth = downScaler.getHeight();
        }
        if (width > downWidth) {
            float scale = (float)downWidth / (float)width;
            downHeight = Math.round((float)height * scale);
        } else if (height > downHeight) {
            float scale = (float)downHeight / (float)height;
            downWidth = Math.round((float)width * scale);
        } else {
            return null;
        }
        return new CmsImageScaler(downScaler, downWidth, downHeight);
    }

    public List<String> getFilters() {
        return this.m_filters;
    }

    public String getFiltersString() {
        StringBuffer result = new StringBuffer();
        Iterator<String> i = this.m_filters.iterator();
        while (i.hasNext()) {
            String filter = i.next();
            result.append(filter);
            if (!i.hasNext()) continue;
            result.append(':');
        }
        return result.toString();
    }

    public CmsPoint getFocalPoint() {
        return this.m_focalPoint;
    }

    public int getHeight() {
        return this.m_height;
    }

    public String getImageType(String filename) {
        return Simapi.getImageType((String)filename);
    }

    public int getMaxBlurSize() {
        return this.m_maxBlurSize;
    }

    public int getMaxHeight() {
        return this.m_maxHeight;
    }

    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    public int getPixelCount() {
        return this.m_width * this.m_height;
    }

    public int getPosition() {
        return this.m_position;
    }

    public int getQuality() {
        return this.m_quality;
    }

    public int getRenderMode() {
        return this.m_renderMode;
    }

    public String getRequestParam() {
        return this.toRequestParam();
    }

    public CmsImageScaler getReScaler(CmsImageScaler target) {
        int height = target.getHeight();
        int width = target.getWidth();
        int type = target.getType();
        if (type == 5) {
            if (target.isValid()) {
                int[] dimensions;
                float maxWidth = target.getMaxWidth() > 0 ? (float)target.getMaxWidth() : (float)height;
                float maxHeight = target.getMaxHeight() > 0 ? (float)target.getMaxHeight() : (float)width;
                float scaleOfImage = (float)this.getWidth() / (float)this.getHeight();
                float[] scales = new float[]{(float)width / (float)height, (float)width / maxHeight, maxWidth / (float)height};
                int useScale = this.calculateClosest(scaleOfImage, scales);
                switch (useScale) {
                    case 1: {
                        dimensions = CmsImageScaler.calculateDimension(this.getWidth(), this.getHeight(), width, (int)maxHeight);
                        break;
                    }
                    case 2: {
                        dimensions = CmsImageScaler.calculateDimension(this.getWidth(), this.getHeight(), (int)maxWidth, height);
                        break;
                    }
                    default: {
                        dimensions = CmsImageScaler.calculateDimension(this.getWidth(), this.getHeight(), width, height);
                    }
                }
                width = dimensions[0];
                height = dimensions[1];
            } else {
                type = 1;
            }
        }
        if (type != 5) {
            float scale;
            if (width > 0 && this.getWidth() > 0) {
                scale = (float)width / (float)this.getWidth();
                height = Math.round((float)this.getHeight() * scale);
            } else if (height > 0 && this.getHeight() > 0) {
                scale = (float)height / (float)this.getHeight();
                width = Math.round((float)this.getWidth() * scale);
            } else if (this.isValid() && !target.isValid()) {
                width = this.getWidth();
                height = this.getHeight();
            }
        }
        if (type == 1 && !target.isValid()) {
            if (target.getWidth() > 0 && this.getWidth() < width) {
                height = this.getHeight();
            } else if (target.getHeight() > 0 && this.getHeight() < height) {
                width = this.getWidth();
            }
        }
        CmsImageScaler result = new CmsImageScaler(target, width, height);
        result.setType(type);
        return result;
    }

    public int getType() {
        return this.m_type;
    }

    public int getWidth() {
        return this.m_width;
    }

    public CmsImageScaler getWidthScaler(CmsImageScaler downScaler) {
        int height;
        int width = downScaler.getWidth();
        if (this.getWidth() > width) {
            float scale = (float)width / (float)this.getWidth();
            height = Math.round((float)this.getHeight() * scale);
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        return new CmsImageScaler(downScaler, width, height);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isCropping() {
        return this.m_cropX >= 0 && this.m_cropY >= 0 && this.m_cropHeight > 0 && this.m_cropWidth > 0;
    }

    public boolean isDownScaleRequired(CmsImageScaler downScaler) {
        int width;
        int height;
        if (downScaler == null || !this.isValid() || !downScaler.isValid()) {
            return false;
        }
        if (this.getPixelCount() < downScaler.getPixelCount() / 2) {
            return false;
        }
        int downWidth = downScaler.getWidth();
        int downHeight = downScaler.getHeight();
        if (downHeight > downWidth) {
            downWidth = downHeight;
            downHeight = downScaler.getWidth();
        }
        if ((height = this.getHeight()) > (width = this.getWidth())) {
            width = height;
            height = this.getWidth();
        }
        return width > downWidth || height > downHeight;
    }

    public boolean isOriginalScaler() {
        return this.m_isOriginalScaler;
    }

    public boolean isValid() {
        return this.m_width > 0 && this.m_height > 0;
    }

    public void parseParameters(String parameters) {
        this.m_width = -1;
        this.m_height = -1;
        this.m_position = 0;
        this.m_type = 0;
        this.m_color = Simapi.COLOR_TRANSPARENT;
        this.m_cropX = -1;
        this.m_cropY = -1;
        this.m_cropWidth = -1;
        this.m_cropHeight = -1;
        List<String> tokens = CmsStringUtil.splitAsList(parameters, ',');
        for (String t : tokens) {
            String k = null;
            String v = null;
            int idx = t.indexOf(58);
            if (idx >= 0) {
                k = t.substring(0, idx).trim();
                if (t.length() > idx) {
                    v = t.substring(idx + 1).trim();
                }
            }
            if (CmsStringUtil.isNotEmpty(k) && CmsStringUtil.isNotEmpty(v)) {
                if (SCALE_PARAM_HEIGHT.equals(k)) {
                    this.m_height = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_WIDTH.equals(k)) {
                    this.m_width = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_CROP_X.equals(k)) {
                    this.m_cropX = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_CROP_Y.equals(k)) {
                    this.m_cropY = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_CROP_WIDTH.equals(k)) {
                    this.m_cropWidth = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_CROP_HEIGHT.equals(k)) {
                    this.m_cropHeight = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_TYPE.equals(k)) {
                    this.setType(CmsStringUtil.getIntValue(v, -1, SCALE_PARAM_TYPE));
                    continue;
                }
                if (SCALE_PARAM_COLOR.equals(k)) {
                    this.setColor(v);
                    continue;
                }
                if (SCALE_PARAM_POS.equals(k)) {
                    this.setPosition(CmsStringUtil.getIntValue(v, -1, SCALE_PARAM_POS));
                    continue;
                }
                if (SCALE_PARAM_QUALITY.equals(k)) {
                    this.setQuality(CmsStringUtil.getIntValue(v, 0, k));
                    continue;
                }
                if (SCALE_PARAM_RENDERMODE.equals(k)) {
                    this.setRenderMode(CmsStringUtil.getIntValue(v, 0, k));
                    continue;
                }
                if (SCALE_PARAM_FILTER.equals(k)) {
                    this.setFilters(v);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("ERR_INVALID_IMAGE_SCALE_PARAMS_2", k, v));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)Messages.get().getBundle().key("ERR_INVALID_IMAGE_SCALE_PARAMS_2", k, v));
        }
        this.initCropArea();
    }

    public byte[] scaleImage(byte[] content, String rootPath) {
        byte[] result;
        block26: {
            String mimeType;
            RenderSettings renderSettings;
            result = content;
            boolean imageProcessed = false;
            this.initCropArea();
            if (this.m_renderMode == 0 && this.m_quality == 0) {
                renderSettings = new RenderSettings(0);
            } else {
                renderSettings = new RenderSettings(this.m_renderMode);
                if (this.m_quality != 0) {
                    renderSettings.setCompressionQuality((float)this.m_quality / 100.0f);
                }
            }
            renderSettings.setMaximumBlurSize(this.m_maxBlurSize);
            Simapi scaler = new Simapi(renderSettings);
            String imageType = Simapi.getImageType((String)rootPath);
            if (imageType == null && (mimeType = OpenCms.getResourceManager().getMimeType(rootPath, null, null)) == null) {
                imageType = "JPEG";
            }
            if (imageType == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_SCALE_IMAGE_2", rootPath, this.toString()));
                }
                return result;
            }
            try {
                BufferedImage image = Simapi.read((byte[])content);
                if (this.isCropping() && this.getType() == 0 && (this.m_cropHeight > image.getHeight() || this.m_cropWidth > image.getWidth())) {
                    return result;
                }
                Color color = this.getColor();
                if (!this.m_filters.isEmpty()) {
                    for (String filter : this.m_filters) {
                        if (FILTER_GRAYSCALE.equals(filter)) {
                            GrayscaleFilter grayscaleFilter = new GrayscaleFilter();
                            renderSettings.addImageFilter((ImageFilter)grayscaleFilter);
                            continue;
                        }
                        if (!FILTER_SHADOW.equals(filter)) continue;
                        ShadowFilter shadowFilter = new ShadowFilter();
                        shadowFilter.setXOffset(5);
                        shadowFilter.setYOffset(5);
                        shadowFilter.setOpacity(192);
                        shadowFilter.setBackgroundColor(color.getRGB());
                        color = Simapi.COLOR_TRANSPARENT;
                        renderSettings.setTransparentReplaceColor(Simapi.COLOR_TRANSPARENT);
                        renderSettings.addImageFilter((ImageFilter)shadowFilter);
                    }
                }
                if (this.isCropping()) {
                    if (this.getType() == 8 && this.m_focalPoint != null) {
                        image = scaler.cropToSize(image, this.m_cropX, this.m_cropY, this.m_cropWidth, this.m_cropHeight, this.m_cropWidth, this.m_cropHeight, color);
                        double scaling = Math.min(1.0 * (double)this.m_cropWidth / (double)this.m_width, 1.0 * (double)this.m_cropHeight / (double)this.m_height);
                        int relW = (int)(scaling * (double)this.m_width);
                        int relH = (int)(scaling * (double)this.m_height);
                        int relX = (int)(this.m_focalPoint.getX() - (double)this.m_cropX);
                        int relY = (int)(this.m_focalPoint.getY() - (double)this.m_cropY);
                        image = scaler.cropPointToSize(image, relX, relY, false, relW, relH);
                        if (this.m_width != relW || this.m_height != relH) {
                            image = scaler.scale(image, this.m_width, this.m_height);
                        }
                    } else {
                        image = this.getType() == 6 || this.getType() == 7 ? scaler.cropPointToSize(image, this.m_cropX, this.m_cropY, this.getType() == 6, this.m_cropWidth, this.m_cropHeight) : scaler.cropToSize(image, this.m_cropX, this.m_cropY, this.m_cropWidth, this.m_cropHeight, this.getWidth(), this.getHeight(), color);
                    }
                    imageProcessed = true;
                } else {
                    int imageWidth = image.getWidth();
                    int imageHeight = image.getHeight();
                    switch (this.getType()) {
                        case 1: {
                            image = scaler.resize(image, this.getWidth(), this.getHeight(), color, this.getPosition(), false);
                            imageProcessed = true;
                            break;
                        }
                        case 2: {
                            if (imageWidth == this.getWidth() && imageHeight == this.getHeight()) break;
                            image = scaler.resize(image, this.getWidth(), this.getHeight(), this.getPosition());
                            imageProcessed = true;
                            break;
                        }
                        case 3: {
                            if (imageWidth == this.getWidth() && imageHeight == this.getHeight()) break;
                            image = scaler.resize(image, this.getWidth(), this.getHeight(), true);
                            imageProcessed = true;
                            break;
                        }
                        case 4: {
                            if (imageWidth == this.getWidth() && imageHeight == this.getHeight()) break;
                            image = scaler.resize(image, this.getWidth(), this.getHeight(), false);
                            imageProcessed = true;
                            break;
                        }
                        case 5: {
                            if (imageWidth == this.getWidth() && imageHeight == this.getHeight()) break;
                            image = scaler.resize(image, this.getWidth(), this.getHeight(), false);
                            imageProcessed = true;
                            break;
                        }
                        default: {
                            image = scaler.resize(image, this.getWidth(), this.getHeight(), color, this.getPosition(), true);
                            imageProcessed = true;
                        }
                    }
                }
                if (!this.m_filters.isEmpty()) {
                    Rectangle targetSize = scaler.applyFilterDimensions(this.getWidth(), this.getHeight());
                    image = scaler.resize(image, (int)targetSize.getWidth(), (int)targetSize.getHeight(), Simapi.COLOR_TRANSPARENT, 0);
                    image = scaler.applyFilters(image);
                    imageProcessed = true;
                }
                if (imageProcessed) {
                    result = scaler.getBytes(image, imageType);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block26;
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_SCALE_IMAGE_2", rootPath, this.toString()), (Throwable)e);
            }
        }
        return result;
    }

    public byte[] scaleImage(CmsFile file) {
        return this.scaleImage(file.getContents(), file.getRootPath());
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void setColor(String value) {
        if (COLOR_TRANSPARENT.indexOf(value) == 0) {
            this.setColor(Simapi.COLOR_TRANSPARENT);
        } else {
            this.setColor(CmsStringUtil.getColorValue(value, Simapi.COLOR_TRANSPARENT, SCALE_PARAM_COLOR));
        }
    }

    public void setCropArea(int x, int y, int width, int height) {
        this.m_cropX = x;
        this.m_cropY = y;
        this.m_cropWidth = width;
        this.m_cropHeight = height;
    }

    public void setFilters(String value) {
        this.m_filters = new ArrayList<String>();
        List<String> filters = CmsStringUtil.splitAsList(value, ':');
        block0: for (String filter : filters) {
            filter = filter.trim().toLowerCase();
            for (String candidate : FILTERS) {
                if (!candidate.startsWith(filter)) continue;
                this.addFilter(candidate);
                continue block0;
            }
        }
    }

    public void setFocalPoint(CmsPoint point) {
        this.m_focalPoint = point;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public void setMaxBlurSize(int maxBlurSize) {
        this.m_maxBlurSize = maxBlurSize;
    }

    public void setMaxHeight(int maxHeight) {
        this.m_maxHeight = maxHeight;
    }

    public void setMaxWidth(int maxWidth) {
        this.m_maxWidth = maxWidth;
    }

    public void setPosition(int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.m_position = position;
                break;
            }
            default: {
                this.m_position = 0;
            }
        }
    }

    public void setQuality(int quality) {
        this.m_quality = quality < 0 ? 0 : (quality > 100 ? 100 : quality);
    }

    public void setRenderMode(int renderMode) {
        if (renderMode < 0 || renderMode > 2) {
            renderMode = 0;
        }
        this.m_renderMode = renderMode;
    }

    public void setType(int type) {
        this.m_type = type < 0 || type > 8 ? 0 : type;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public String toRequestParam() {
        StringBuffer result = new StringBuffer(128);
        result.append('?');
        result.append(PARAM_SCALE);
        result.append('=');
        result.append(this.toString());
        return result.toString();
    }

    public String toString() {
        if (this.m_scaleParameters != null) {
            return this.m_scaleParameters;
        }
        StringBuffer result = new StringBuffer(64);
        if (this.isCropping()) {
            result.append(SCALE_PARAM_CROP_X);
            result.append(':');
            result.append(this.m_cropX);
            result.append(',');
            result.append(SCALE_PARAM_CROP_Y);
            result.append(':');
            result.append(this.m_cropY);
            result.append(',');
            result.append(SCALE_PARAM_CROP_WIDTH);
            result.append(':');
            result.append(this.m_cropWidth);
            result.append(',');
            result.append(SCALE_PARAM_CROP_HEIGHT);
            result.append(':');
            result.append(this.m_cropHeight);
        }
        if (!this.isCropping() || this.m_width != this.m_cropWidth || this.m_height != this.m_cropHeight) {
            if (this.isCropping()) {
                result.append(',');
            }
            result.append(SCALE_PARAM_WIDTH);
            result.append(':');
            result.append(this.m_width);
            result.append(',');
            result.append(SCALE_PARAM_HEIGHT);
            result.append(':');
            result.append(this.m_height);
        }
        if (this.m_type > 0) {
            result.append(',');
            result.append(SCALE_PARAM_TYPE);
            result.append(':');
            result.append(this.m_type);
        }
        if (this.m_position > 0) {
            result.append(',');
            result.append(SCALE_PARAM_POS);
            result.append(':');
            result.append(this.m_position);
        }
        if (this.m_color != Color.WHITE) {
            result.append(',');
            result.append(SCALE_PARAM_COLOR);
            result.append(':');
            result.append(this.getColorString());
        }
        if (this.m_quality > 0) {
            result.append(',');
            result.append(SCALE_PARAM_QUALITY);
            result.append(':');
            result.append(this.m_quality);
        }
        if (this.m_renderMode > 0) {
            result.append(',');
            result.append(SCALE_PARAM_RENDERMODE);
            result.append(':');
            result.append(this.m_renderMode);
        }
        if (!this.m_filters.isEmpty()) {
            result.append(',');
            result.append(SCALE_PARAM_FILTER);
            result.append(':');
            result.append(this.getFiltersString());
        }
        this.m_scaleParameters = result.toString();
        return this.m_scaleParameters;
    }

    private int calculateClosest(float base, float[] others) {
        int result = -1;
        float bestMatch = Float.MAX_VALUE;
        for (int count = 0; count < others.length; ++count) {
            float difference = Math.abs(base - others[count]);
            if (difference < bestMatch) {
                bestMatch = difference;
                result = count;
            }
            if (bestMatch == 0.0f) break;
        }
        return result;
    }

    private void init() {
        this.m_height = -1;
        this.m_width = -1;
        this.m_maxHeight = -1;
        this.m_maxWidth = -1;
        this.m_type = 0;
        this.m_position = 0;
        this.m_renderMode = 0;
        this.m_quality = 0;
        this.m_cropX = -1;
        this.m_cropY = -1;
        this.m_cropHeight = -1;
        this.m_cropWidth = -1;
        this.m_color = Color.WHITE;
        this.m_filters = new ArrayList<String>();
        this.m_maxBlurSize = CmsImageLoader.getMaxBlurSize();
        this.m_isOriginalScaler = false;
    }

    private void initCropArea() {
        if (this.isCropping()) {
            if (this.m_width < 0) {
                this.m_width = this.m_cropWidth;
            }
            if (this.m_height < 0) {
                this.m_height = this.m_cropHeight;
            }
            if (this.getType() != 6 && this.getType() != 7 && this.getType() != 8) {
                this.setType(0);
            }
        }
    }

    private void initValuesFrom(CmsImageScaler source) {
        this.m_color = source.m_color;
        this.m_cropHeight = source.m_cropHeight;
        this.m_cropWidth = source.m_cropWidth;
        this.m_cropX = source.m_cropX;
        this.m_cropY = source.m_cropY;
        this.m_filters = new ArrayList<String>(source.m_filters);
        this.m_focalPoint = source.m_focalPoint;
        this.m_height = source.m_height;
        this.m_isOriginalScaler = source.m_isOriginalScaler;
        this.m_maxBlurSize = source.m_maxBlurSize;
        this.m_position = source.m_position;
        this.m_quality = source.m_quality;
        this.m_renderMode = source.m_renderMode;
        this.m_type = source.m_type;
        this.m_width = source.m_width;
    }
}

