/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsDefaultFileNameGenerator;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsMimeType;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.CmsTemplateContextManager;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleManager;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsDefaultSet;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsHtmlConverterJTidy;
import org.opencms.util.CmsHtmlConverterOption;
import org.opencms.util.CmsResourceTranslator;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsHtmlConverter;
import org.opencms.xml.CmsXmlContentDefinition;

public class CmsResourceManager {
    public static final String DEFAULT_TEMPLATE = "/system/workplace/commons/template/default.jsp";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_TEXT = "text/plain";
    private static final Log LOG = CmsLog.getLog(CmsResourceManager.class);
    private Map<String, I_CmsResourceCollector> m_collectorNameMappings;
    private List<I_CmsResourceCollector> m_collectors;
    private CmsResourceManagerConfiguration m_configuration;
    private List<CmsHtmlConverterOption> m_configuredHtmlConverters;
    private List<CmsMimeType> m_configuredMimeTypes;
    private List<CmsRelationType> m_configuredRelationTypes;
    private CmsResourceTranslator m_fileTranslator;
    private CmsResourceTranslator m_folderTranslator;
    private boolean m_frozen;
    private Map<String, String> m_htmlConverters;
    private List<I_CmsResourceLoader> m_loaderList;
    private I_CmsResourceLoader[] m_loaders;
    private Map<String, String> m_mimeTypes;
    private I_CmsFileNameGenerator m_nameGenerator;
    private List<I_CmsResourceType> m_resourceTypesFromXml;
    private I_CmsResourceType m_restypeUnknownFile;
    private I_CmsResourceType m_restypeUnknownFolder;
    private CmsVfsMemoryObjectCache m_templateNameCache = new CmsVfsMemoryObjectCache();
    private CmsResourceTranslator m_xsdTranslator;

    public CmsResourceManager() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STARTING_LOADER_CONFIG_0"));
        }
        this.m_resourceTypesFromXml = new ArrayList<I_CmsResourceType>();
        this.m_loaders = new I_CmsResourceLoader[16];
        this.m_loaderList = new ArrayList<I_CmsResourceLoader>();
        this.m_configuredMimeTypes = new ArrayList<CmsMimeType>();
        this.m_configuredRelationTypes = new ArrayList<CmsRelationType>();
        this.m_configuredHtmlConverters = new ArrayList<CmsHtmlConverterOption>();
    }

    public synchronized I_CmsResourceCollector addContentCollector(String className, String order) throws CmsConfigurationException {
        I_CmsResourceCollector collector;
        Class<?> classClazz;
        try {
            classClazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CONTENT_COLLECTOR_CLASS_NOT_FOUND_1", className), (Throwable)e);
            return null;
        }
        try {
            collector = (I_CmsResourceCollector)classClazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_COLLECTOR_NAME_1", className));
        }
        catch (IllegalAccessException e) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_COLLECTOR_NAME_1", className));
        }
        catch (ClassCastException e) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_COLLECTOR_NAME_1", className));
        }
        int ord = 0;
        try {
            ord = Integer.valueOf(order);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_COLLECTOR_BAD_ORDER_NUMBER_1", className), (Throwable)e);
        }
        collector.setOrder(ord);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_COLLECTOR_CLASS_2", className, order));
        }
        if (this.m_collectors != null) {
            this.m_collectors = new ArrayList<I_CmsResourceCollector>(this.m_collectors);
            this.m_collectorNameMappings = new HashMap<String, I_CmsResourceCollector>(this.m_collectorNameMappings);
        } else {
            this.m_collectors = new ArrayList<I_CmsResourceCollector>();
            this.m_collectorNameMappings = new HashMap<String, I_CmsResourceCollector>();
        }
        if (!this.m_collectors.contains(collector)) {
            this.m_collectors.add(collector);
            for (String name : collector.getCollectorNames()) {
                if (this.m_collectorNameMappings.containsKey(name)) {
                    I_CmsResourceCollector otherCollector = this.m_collectorNameMappings.get(name);
                    if (collector.getOrder() > otherCollector.getOrder()) {
                        this.m_collectorNameMappings.put(name, collector);
                        if (!CmsLog.INIT.isInfoEnabled()) continue;
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_COLLECTOR_REPLACED_1", name));
                        continue;
                    }
                    if (!CmsLog.INIT.isInfoEnabled()) continue;
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DUPLICATE_COLLECTOR_SKIPPED_1", name));
                    continue;
                }
                this.m_collectorNameMappings.put(name, collector);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_COLLECTOR_1", name));
            }
        }
        Collections.sort(this.m_collectors);
        this.m_collectors = Collections.unmodifiableList(this.m_collectors);
        this.m_collectorNameMappings = Collections.unmodifiableMap(this.m_collectorNameMappings);
        return collector;
    }

    public I_CmsHtmlConverter addHtmlConverter(String name, String className) throws CmsConfigurationException {
        I_CmsHtmlConverter converter;
        Class<?> classClazz;
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        try {
            classClazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_HTML_CONVERTER_CLASS_NOT_FOUND_1", className), (Throwable)e);
            return null;
        }
        try {
            converter = (I_CmsHtmlConverter)classClazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_HTMLCONVERTER_NAME_1", className));
        }
        catch (IllegalAccessException e) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_HTMLCONVERTER_NAME_1", className));
        }
        catch (ClassCastException e) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_HTMLCONVERTER_NAME_1", className));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_HTML_CONVERTER_CLASS_2", className, name));
        }
        this.m_configuredHtmlConverters.add(new CmsHtmlConverterOption(name, className));
        return converter;
    }

    public void addLoader(I_CmsResourceLoader loader) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        int pos = loader.getLoaderId();
        if (pos >= this.m_loaders.length) {
            I_CmsResourceLoader[] buffer = new I_CmsResourceLoader[pos * 2];
            System.arraycopy(this.m_loaders, 0, buffer, 0, this.m_loaders.length);
            this.m_loaders = buffer;
        }
        this.m_loaders[pos] = loader;
        this.m_loaderList.add(loader);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_LOADER_2", loader.getClass().getName(), new Integer(pos)));
        }
    }

    public CmsMimeType addMimeType(String extension, String type) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        CmsMimeType mimeType = new CmsMimeType(extension, type);
        this.m_configuredMimeTypes.add(mimeType);
        return mimeType;
    }

    public CmsRelationType addRelationType(String name, String type) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        CmsRelationType relationType = new CmsRelationType(this.m_configuredRelationTypes.size(), name, type);
        this.m_configuredRelationTypes.add(relationType);
        return relationType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addResourceType(I_CmsResourceType resourceType) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        I_CmsResourceType conflictingType = null;
        if (resourceType.getTypeId() == -1) {
            if (this.m_restypeUnknownFile == null) {
                this.m_restypeUnknownFile = resourceType;
                return;
            }
            conflictingType = this.m_restypeUnknownFile;
        } else if (resourceType.getTypeId() == -2) {
            if (this.m_restypeUnknownFolder == null) {
                this.m_restypeUnknownFolder = resourceType;
                return;
            }
            conflictingType = this.m_restypeUnknownFolder;
        } else {
            int conflictIndex = this.m_resourceTypesFromXml.indexOf(resourceType);
            if (conflictIndex >= 0) {
                conflictingType = this.m_resourceTypesFromXml.get(conflictIndex);
            }
        }
        if (conflictingType != null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFLICTING_RESOURCE_TYPES_4", new Object[]{resourceType.getTypeName(), new Integer(resourceType.getTypeId()), conflictingType.getTypeName(), new Integer(conflictingType.getTypeId())}));
        }
        this.m_resourceTypesFromXml.add(resourceType);
    }

    public Map<String, CmsDefaultSet<String>> getAllowedContextMap(CmsObject cms) {
        HashMap<String, CmsDefaultSet<String>> result = new HashMap<String, CmsDefaultSet<String>>();
        for (I_CmsResourceType resType : this.getResourceTypes()) {
            if (!(resType instanceof CmsResourceTypeXmlContent)) continue;
            String schema = null;
            try {
                schema = ((CmsResourceTypeXmlContent)resType).getSchema();
                if (schema != null) {
                    CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
                    CmsDefaultSet<String> allowedContexts = contentDefinition.getContentHandler().getAllowedTemplates();
                    result.put(resType.getTypeName(), allowedContexts);
                    continue;
                }
                LOG.info((Object)("No schema for XML type " + resType.getTypeName() + " / " + resType.getClass().getName()));
            }
            catch (Exception e) {
                LOG.error((Object)("Error in getAllowedContextMap, schema=" + schema + ", type=" + resType.getTypeName() + ", " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return result;
    }

    public I_CmsResourceCollector getContentCollector(String collectorName) {
        return this.m_collectorNameMappings.get(collectorName);
    }

    public I_CmsResourceType getDefaultTypeForName(String resourcename) throws CmsException {
        int pos;
        String typeName = null;
        String suffix = null;
        if (CmsStringUtil.isNotEmpty(resourcename) && (pos = resourcename.lastIndexOf(46)) >= 0 && CmsStringUtil.isNotEmpty(suffix = resourcename.substring(pos))) {
            suffix = suffix.toLowerCase();
            typeName = this.m_configuration.m_extensionMappings.get(suffix);
        }
        if (typeName == null) {
            typeName = CmsResourceTypePlain.getStaticTypeName();
        }
        if (CmsLog.INIT.isDebugEnabled()) {
            CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_GET_RESTYPE_2", typeName, suffix));
        }
        return this.getResourceType(typeName);
    }

    public Map<String, String> getExtensionMapping() {
        return this.m_configuration.m_extensionMappings;
    }

    public CmsResourceTranslator getFileTranslator() {
        return this.m_fileTranslator;
    }

    public CmsResourceTranslator getFolderTranslator() {
        return this.m_folderTranslator;
    }

    public String getHtmlConverter(String name) {
        return this.m_htmlConverters.get(name);
    }

    public List<CmsHtmlConverterOption> getHtmlConverters() {
        return this.m_configuredHtmlConverters;
    }

    public I_CmsResourceLoader getLoader(CmsResource resource) throws CmsLoaderException {
        return this.getLoader(this.getResourceType(resource.getTypeId()).getLoaderId());
    }

    public I_CmsResourceLoader getLoader(int id) {
        return this.m_loaders[id];
    }

    public List<I_CmsResourceLoader> getLoaders() {
        return this.m_loaderList;
    }

    public String getMimeType(String filename, String encoding) {
        return this.getMimeType(filename, encoding, MIMETYPE_HTML);
    }

    public String getMimeType(String filename, String encoding, String defaultMimeType) {
        String mimeType = null;
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            mimeType = this.m_mimeTypes.get(filename.substring(lastDot).toLowerCase(Locale.ENGLISH));
        }
        if (mimeType == null && (mimeType = defaultMimeType) == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(mimeType);
        if (encoding != null && (mimeType.startsWith("text") || mimeType.endsWith("javascript")) && mimeType.indexOf("charset") == -1) {
            result.append("; charset=");
            result.append(encoding);
        }
        return result.toString();
    }

    public List<CmsMimeType> getMimeTypes() {
        return this.m_configuredMimeTypes;
    }

    public I_CmsFileNameGenerator getNameGenerator() {
        if (this.m_nameGenerator == null) {
            this.m_nameGenerator = new CmsDefaultFileNameGenerator();
        }
        return this.m_nameGenerator;
    }

    public List<I_CmsResourceCollector> getRegisteredContentCollectors() {
        return this.m_collectors;
    }

    public List<CmsRelationType> getRelationTypes() {
        return this.m_configuredRelationTypes;
    }

    public I_CmsResourceType getResourceType(CmsResource resource) {
        I_CmsResourceType result = this.m_configuration.getResourceTypeById(resource.getTypeId());
        if (result == null) {
            result = resource.isFolder() ? (this.m_restypeUnknownFolder != null ? this.m_restypeUnknownFolder : this.m_configuration.getResourceTypeByName(CmsResourceTypeFolder.getStaticTypeName())) : (this.m_restypeUnknownFile != null ? this.m_restypeUnknownFile : this.m_configuration.getResourceTypeByName(CmsResourceTypeBinary.getStaticTypeName()));
        }
        return result;
    }

    public I_CmsResourceType getResourceType(int typeId) throws CmsLoaderException {
        I_CmsResourceType result = this.m_configuration.getResourceTypeById(typeId);
        if (result == null) {
            throw new CmsLoaderException(Messages.get().container("ERR_UNKNOWN_RESTYPE_ID_REQ_1", new Integer(typeId)));
        }
        return result;
    }

    public I_CmsResourceType getResourceType(String typeName) throws CmsLoaderException {
        I_CmsResourceType result = this.m_configuration.getResourceTypeByName(typeName);
        if (result != null) {
            return result;
        }
        throw new CmsLoaderException(Messages.get().container("ERR_UNKNOWN_RESTYPE_NAME_REQ_1", typeName));
    }

    public List<I_CmsResourceType> getResourceTypes() {
        return this.m_configuration.m_resourceTypeList;
    }

    public List<I_CmsResourceType> getResourceTypesWithUnknown() {
        return this.m_configuration.m_resourceTypeListWithUnknown;
    }

    public I_CmsResourceType getResTypeUnknownFile() {
        return this.m_restypeUnknownFile;
    }

    public I_CmsResourceType getResTypeUnknownFolder() {
        return this.m_restypeUnknownFolder;
    }

    public CmsTemplateLoaderFacade getTemplateLoaderFacade(CmsObject cms, CmsResource resource, String templateProperty) throws CmsException {
        return this.getTemplateLoaderFacade(cms, null, resource, templateProperty);
    }

    public CmsTemplateLoaderFacade getTemplateLoaderFacade(CmsObject cms, HttpServletRequest request, CmsResource resource, String templateProperty) throws CmsException {
        NamedTemplate namedTemplate;
        String templateProp = cms.readPropertyObject(resource, templateProperty, true).getValue();
        CmsTemplateContext templateContext = null;
        String templateName = null;
        if (templateProp == null) {
            templateProp = DEFAULT_TEMPLATE;
            namedTemplate = this.readTemplateWithName(cms, templateProp);
            if (namedTemplate == null) {
                throw new CmsLoaderException(Messages.get().container("ERR_NONDEF_PROP_2", templateProperty, cms.getSitePath(resource)));
            }
            templateName = namedTemplate.getName();
        } else {
            if (CmsTemplateContextManager.hasPropertyPrefix(templateProp) && (templateContext = OpenCms.getTemplateContextManager().getTemplateContext(templateProp, cms, request, resource)) != null) {
                templateProp = templateContext.getTemplatePath();
            }
            if ((namedTemplate = this.readTemplateWithName(cms, templateProp)) == null) {
                namedTemplate = this.readTemplateWithName(cms, DEFAULT_TEMPLATE);
                if (namedTemplate != null) {
                    templateProp = DEFAULT_TEMPLATE;
                    templateName = namedTemplate.getName();
                }
            } else {
                templateName = namedTemplate.getName();
            }
        }
        CmsFile template = cms.readFile(templateProp, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsTemplateLoaderFacade result = new CmsTemplateLoaderFacade(this.getLoader(template), resource, template);
        result.setTemplateContext(templateContext);
        result.setTemplateName(templateName);
        return result;
    }

    public CmsResourceTranslator getXsdTranslator() {
        return this.m_xsdTranslator;
    }

    public boolean hasResourceType(I_CmsResourceType type) {
        return this.hasResourceType(type.getTypeName());
    }

    @Deprecated
    public boolean hasResourceType(int typeId) {
        return this.m_configuration.getResourceTypeById(typeId) != null;
    }

    public boolean hasResourceType(String typeName) {
        return this.m_configuration.getResourceTypeByName(typeName) != null;
    }

    public void initConfiguration() throws CmsConfigurationException {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_CONFIG_FINISHED_0"));
        }
        this.m_resourceTypesFromXml = Collections.unmodifiableList(this.m_resourceTypesFromXml);
        this.m_loaderList = Collections.unmodifiableList(this.m_loaderList);
        Collections.sort(this.m_configuredMimeTypes);
        this.m_configuredMimeTypes = Collections.unmodifiableList(this.m_configuredMimeTypes);
        this.m_configuredRelationTypes = Collections.unmodifiableList(this.m_configuredRelationTypes);
        this.initHtmlConverters();
        this.m_configuredHtmlConverters = Collections.unmodifiableList(this.m_configuredHtmlConverters);
        this.initResourceTypes();
        this.initMimeTypes();
    }

    public synchronized void initialize(CmsObject cms) throws CmsRoleViolationException, CmsConfigurationException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        this.initResourceTypes();
        for (I_CmsResourceType type : this.m_configuration.m_resourceTypeList) {
            type.initialize(cms);
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_CONFIG_FINISHED_0"));
        }
    }

    public void loadResource(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        res.setContentType(this.getMimeType(resource.getName(), cms.getRequestContext().getEncoding()));
        I_CmsResourceLoader loader = this.getLoader(resource);
        loader.load(cms, resource, req, res);
    }

    public boolean matchResourceType(String name, int id) {
        if (this.hasResourceType(name)) {
            try {
                return this.getResourceType(name).getTypeId() == id;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public void setNameGenerator(I_CmsFileNameGenerator nameGenerator) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        this.m_nameGenerator = nameGenerator;
    }

    public void setTranslators(CmsResourceTranslator folderTranslator, CmsResourceTranslator fileTranslator, CmsResourceTranslator xsdTranslator) {
        this.m_folderTranslator = folderTranslator;
        this.m_fileTranslator = fileTranslator;
        this.m_xsdTranslator = xsdTranslator;
    }

    public synchronized void shutDown() throws Exception {
        for (I_CmsResourceLoader loader : this.m_loaderList) {
            loader.destroy();
        }
        this.m_loaderList = null;
        this.m_loaders = null;
        this.m_collectorNameMappings = null;
        this.m_mimeTypes = null;
        this.m_configuredMimeTypes = null;
        this.m_configuredRelationTypes = null;
        this.m_configuredHtmlConverters = null;
        this.m_htmlConverters = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    private String getTemplateName(CmsObject cms, CmsResource resource) throws CmsException {
        String templateName = (String)this.m_templateNameCache.getCachedObject(cms, resource.getRootPath());
        if (templateName == null) {
            CmsProperty nameProperty = cms.readPropertyObject(resource, "template-elements", false);
            String nameFromProperty = "";
            if (!nameProperty.isNullProperty()) {
                nameFromProperty = nameProperty.getValue();
            }
            this.m_templateNameCache.putCachedObject(cms, resource.getRootPath(), nameFromProperty);
            return nameFromProperty;
        }
        return templateName;
    }

    private void initHtmlConverters() {
        if (this.m_configuredHtmlConverters.size() == 0) {
            String classJTidy = CmsHtmlConverterJTidy.class.getName();
            this.m_configuredHtmlConverters.add(new CmsHtmlConverterOption(CmsHtmlConverter.PARAM_ENABLED, classJTidy, true));
            this.m_configuredHtmlConverters.add(new CmsHtmlConverterOption("xhtml", classJTidy, true));
            this.m_configuredHtmlConverters.add(new CmsHtmlConverterOption("cleanup", classJTidy, true));
            this.m_configuredHtmlConverters.add(new CmsHtmlConverterOption("replace-paragraphs", classJTidy, true));
        }
        this.m_htmlConverters = new HashMap<String, String>(this.m_configuredHtmlConverters.size());
        for (CmsHtmlConverterOption converterOption : this.m_configuredHtmlConverters) {
            this.m_htmlConverters.put(converterOption.getName(), converterOption.getClassName());
        }
    }

    private void initMimeTypes() {
        Properties mimeTypes;
        block7: {
            mimeTypes = new Properties();
            try {
                mimeTypes.load(this.getClass().getClassLoader().getResourceAsStream("mimetypes.properties"));
            }
            catch (Throwable t) {
                try {
                    mimeTypes.load(this.getClass().getClassLoader().getResourceAsStream("org/opencms/loader/mimetypes.properties"));
                }
                catch (Throwable t2) {
                    if (!LOG.isInfoEnabled()) break block7;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_READ_MIMETYPES_FAILED_2", "mimetypes.properties", "org/opencms/loader/mimetypes.properties"));
                }
            }
        }
        ArrayList<CmsMimeType> combinedMimeTypes = new ArrayList<CmsMimeType>(mimeTypes.size() + this.m_configuredMimeTypes.size());
        combinedMimeTypes.addAll(this.m_configuredMimeTypes);
        for (Map.Entry<Object, Object> entry : mimeTypes.entrySet()) {
            CmsMimeType mimeType = new CmsMimeType(entry.getKey().toString(), entry.getValue().toString(), false);
            if (combinedMimeTypes.contains(mimeType)) continue;
            combinedMimeTypes.add(mimeType);
        }
        this.m_mimeTypes = new HashMap<String, String>(mimeTypes.size());
        for (CmsMimeType mimeType : combinedMimeTypes) {
            this.m_mimeTypes.put(mimeType.getExtension(), mimeType.getType());
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_MIMETYPES_1", new Integer(this.m_mimeTypes.size())));
        }
    }

    private synchronized void initResourceType(I_CmsResourceType resourceType, CmsResourceManagerConfiguration configuration) {
        configuration.addResourceType(resourceType);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_RESTYPE_3", resourceType.getTypeName(), new Integer(resourceType.getTypeId()), resourceType.getClass().getName()));
        }
        List<String> mappings = resourceType.getConfiguredMappings();
        for (String mapping : mappings) {
            if (configuration.m_extensionMappings.containsKey(mapping)) continue;
            configuration.m_extensionMappings.put(mapping, resourceType.getTypeName());
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MAP_RESTYPE_2", mapping, resourceType.getTypeName()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void initResourceTypes() throws CmsConfigurationException {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STARTING_LOADER_CONFIG_0"));
        }
        CmsResourceManagerConfiguration newConfiguration = new CmsResourceManagerConfiguration();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_RESTYPE_FROM_FILE_2", new Integer(this.m_resourceTypesFromXml.size()), "opencms-vfs.xml"));
        }
        for (I_CmsResourceType resourceType : this.m_resourceTypesFromXml) {
            this.initResourceType(resourceType, newConfiguration);
        }
        CmsModuleManager moduleManager = OpenCms.getModuleManager();
        if (moduleManager != null) {
            Iterator<String> modules = moduleManager.getModuleNames().iterator();
            while (modules.hasNext()) {
                CmsModule module = moduleManager.getModule(modules.next());
                if (module == null || module.getResourceTypes().size() <= 0) continue;
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_NUM_RESTYPES_FROM_MOD_2", new Integer(module.getResourceTypes().size()), module.getName()));
                }
                for (I_CmsResourceType resourceType : module.getResourceTypes()) {
                    I_CmsResourceType conflictingType;
                    block15: {
                        conflictingType = null;
                        if (resourceType.getTypeId() == -1) {
                            if (this.m_restypeUnknownFile != null) {
                                conflictingType = this.m_restypeUnknownFile;
                                break block15;
                            } else {
                                this.m_restypeUnknownFile = resourceType;
                                continue;
                            }
                        }
                        if (resourceType.getTypeId() == -2) {
                            if (this.m_restypeUnknownFolder != null) {
                                conflictingType = this.m_restypeUnknownFolder;
                                break block15;
                            } else {
                                this.m_restypeUnknownFile = resourceType;
                                continue;
                            }
                        }
                        conflictingType = newConfiguration.getResourceTypeById(resourceType.getTypeId());
                    }
                    if (conflictingType != null) {
                        throw new CmsConfigurationException(Messages.get().container("ERR_CONFLICTING_MODULE_RESOURCE_TYPES_5", new Object[]{resourceType.getTypeName(), new Integer(resourceType.getTypeId()), module.getName(), conflictingType.getTypeName(), new Integer(conflictingType.getTypeId())}));
                    }
                    this.initResourceType(resourceType, newConfiguration);
                }
            }
        }
        newConfiguration.freeze(this.m_restypeUnknownFile, this.m_restypeUnknownFile);
        this.m_configuration = newConfiguration;
        this.m_frozen = true;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RESOURCE_TYPE_INITIALIZED_0"));
        }
    }

    private NamedTemplate readTemplateWithName(CmsObject cms, String path) {
        try {
            CmsResource resource = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
            String name = this.getTemplateName(cms, resource);
            return new NamedTemplate(resource, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    static final class CmsResourceManagerConfiguration {
        protected Map<String, String> m_extensionMappings;
        protected List<I_CmsResourceType> m_resourceTypeList;
        protected List<I_CmsResourceType> m_resourceTypeListWithUnknown;
        private Map<Integer, I_CmsResourceType> m_resourceTypeIdMap = new HashMap<Integer, I_CmsResourceType>(128);
        private Map<String, I_CmsResourceType> m_resourceTypeNameMap = new HashMap<String, I_CmsResourceType>(128);

        protected CmsResourceManagerConfiguration() {
            this.m_extensionMappings = new HashMap<String, String>(128);
            this.m_resourceTypeList = new ArrayList<I_CmsResourceType>(32);
        }

        protected void addResourceType(I_CmsResourceType type) {
            this.m_resourceTypeIdMap.put(type.getTypeId(), type);
            this.m_resourceTypeNameMap.put(type.getTypeName(), type);
            this.m_resourceTypeList.add(type);
        }

        protected void freeze(I_CmsResourceType restypeUnknownFolder, I_CmsResourceType restypeUnknownFile) {
            this.m_resourceTypeListWithUnknown = new ArrayList<I_CmsResourceType>(this.m_resourceTypeList.size() + 2);
            if (restypeUnknownFolder != null) {
                this.m_resourceTypeListWithUnknown.add(restypeUnknownFolder);
            }
            if (restypeUnknownFile != null) {
                this.m_resourceTypeListWithUnknown.add(restypeUnknownFile);
            }
            this.m_resourceTypeListWithUnknown.addAll(this.m_resourceTypeList);
            this.m_resourceTypeListWithUnknown = Collections.unmodifiableList(this.m_resourceTypeListWithUnknown);
            this.m_resourceTypeList = Collections.unmodifiableList(this.m_resourceTypeList);
            this.m_extensionMappings = Collections.unmodifiableMap(this.m_extensionMappings);
        }

        protected I_CmsResourceType getResourceTypeById(int typeId) {
            return this.m_resourceTypeIdMap.get(typeId);
        }

        protected I_CmsResourceType getResourceTypeByName(String typeName) {
            return this.m_resourceTypeNameMap.get(typeName);
        }
    }

    public static class NamedTemplate {
        private String m_name;
        private CmsResource m_resource;

        public NamedTemplate(CmsResource resource, String name) {
            this.m_resource = resource;
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsResource getResource() {
            return this.m_resource;
        }
    }
}

