/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.I_CmsMessageContainer;
import org.opencms.loader.CmsClientVariant;
import org.opencms.loader.I_CmsTemplateContextProvider;

public class CmsTemplateContext {
    private Map<String, CmsClientVariant> m_clientVariants;
    private boolean m_forced;
    private String m_key;
    private I_CmsMessageContainer m_messageContainer;
    private I_CmsTemplateContextProvider m_provider;
    private String m_templatePath;

    public CmsTemplateContext(String key, String path, CmsMessageContainer container, I_CmsTemplateContextProvider provider) {
        this(key, path, container, provider, new ArrayList<CmsClientVariant>(), false);
    }

    public CmsTemplateContext(String key, String path, I_CmsMessageContainer container, I_CmsTemplateContextProvider provider, Collection<CmsClientVariant> clientVariants, boolean forced) {
        this.m_key = key;
        this.m_templatePath = path;
        this.m_messageContainer = container;
        this.m_provider = provider;
        this.m_forced = forced;
        this.m_clientVariants = new LinkedHashMap<String, CmsClientVariant>();
        for (CmsClientVariant variant : clientVariants) {
            this.m_clientVariants.put(variant.getName(), variant);
        }
    }

    public Map<String, CmsClientVariant> getClientVariants() {
        return this.m_clientVariants;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getLocalizedName(Locale locale) {
        if (this.m_messageContainer != null) {
            return this.m_messageContainer.key(locale);
        }
        return this.m_key;
    }

    public I_CmsMessageContainer getMessageContainer() {
        return this.m_messageContainer;
    }

    public I_CmsTemplateContextProvider getProvider() {
        return this.m_provider;
    }

    public String getTemplatePath() {
        return this.m_templatePath;
    }

    public boolean isForced() {
        return this.m_forced;
    }

    public String toString() {
        return this.getKey();
    }
}

