/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.lock;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.gwt.Messages;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;

public final class CmsLockUtil {
    private static final Log LOG = CmsLog.getLog(CmsLockUtil.class);

    private CmsLockUtil() {
    }

    public static CmsLockActionRecord ensureLock(CmsObject cms, CmsResource resource) throws CmsException {
        CmsLockActionRecord.LockChange change = CmsLockActionRecord.LockChange.unchanged;
        List<CmsResource> blockingResources = cms.getBlockingLockedResources(resource);
        if (blockingResources != null && !blockingResources.isEmpty()) {
            throw new CmsException(Messages.get().container("ERR_RESOURCE_HAS_BLOCKING_LOCKED_CHILDREN_1", cms.getSitePath(resource)));
        }
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(resource);
        if (!lock.isOwnedBy(user)) {
            cms.lockResourceTemporary(resource);
            change = CmsLockActionRecord.LockChange.locked;
            lock = cms.getLock(resource);
        } else if (!lock.isOwnedInProjectBy(user, cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(resource);
            change = CmsLockActionRecord.LockChange.changed;
            lock = cms.getLock(resource);
        }
        return new CmsLockActionRecord(lock, change);
    }

    public static void tryUnlock(CmsObject cms, CmsResource resource) {
        try {
            cms.unlockResource(resource);
        }
        catch (CmsException e) {
            LOG.debug((Object)("Unable to unlock " + resource.getRootPath()), (Throwable)e);
        }
    }

    public static AutoCloseable withLockedResources(final CmsObject cms, CmsResource ... resources) throws Exception {
        final HashMap lockMap = Maps.newHashMap();
        Closeable result = new Closeable(){

            @Override
            public void close() {
                for (Map.Entry entry : lockMap.entrySet()) {
                    if (((CmsLockActionRecord)entry.getValue()).getChange() != CmsLockActionRecord.LockChange.locked) continue;
                    CmsResource resourceToUnlock = (CmsResource)entry.getKey();
                    try {
                        resourceToUnlock = cms.readResource(((CmsResource)entry.getKey()).getStructureId(), CmsResourceFilter.ALL);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    try {
                        cms.unlockResource(resourceToUnlock);
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        };
        try {
            for (CmsResource resource : resources) {
                CmsLockActionRecord record = CmsLockUtil.ensureLock(cms, resource);
                lockMap.put(resource, record);
            }
        }
        catch (CmsException e) {
            result.close();
            throw e;
        }
        return result;
    }

    public static final class LockedFile
    implements AutoCloseable {
        private CmsObject m_cms;
        private CmsFile m_file;
        private CmsLockActionRecord m_lockRecord;
        private boolean m_new;
        private CmsResource m_res;

        private LockedFile(CmsObject cms, CmsResource resource) throws CmsException {
            this.m_lockRecord = CmsLockUtil.ensureLock(cms, resource);
            this.m_res = resource;
            this.m_new = false;
            this.m_cms = cms;
        }

        public static LockedFile lockResource(CmsObject cms, CmsResource resource) throws CmsException {
            return new LockedFile(cms, resource);
        }

        @Override
        public void close() throws Exception {
            this.tryUnlock();
        }

        public String getEncoding() {
            return CmsFileUtil.getEncoding(this.m_cms, this.m_res);
        }

        public CmsFile getFile() {
            if (null == this.m_file && this.m_res.isFile()) {
                try {
                    this.m_file = this.m_cms.readFile(this.m_res);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return this.m_file;
        }

        public CmsLockActionRecord getLockActionRecord() {
            return this.m_lockRecord;
        }

        public boolean isCreated() {
            return this.m_new;
        }

        public void setCreated(boolean isNew) {
            this.m_new = isNew;
        }

        public boolean tryUnlock() {
            if (!this.m_lockRecord.getChange().equals((Object)CmsLockActionRecord.LockChange.unchanged) || this.m_new) {
                try {
                    this.m_cms.unlockResource(this.m_res);
                    return true;
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

