/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;

public class CmsMailSettings {
    public static final String MAIL_DEFAULT_PROTOCOL = "smtp";
    public static final String MAIL_DEFAULT_SENDER = "opencms@unconfigured.com";
    private static final Log LOG = CmsLog.getLog(CmsMailSettings.class);
    private String m_mailFromDefault = "opencms@unconfigured.com";
    private List<CmsMailHost> m_mailHosts = new ArrayList<CmsMailHost>();
    private int m_orderDefault;

    public CmsMailSettings() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_EMPTY_CONSTRUCTOR_CALLED_1"));
        }
    }

    public void addMailHost(String hostname, String order, String protocol, String username, String password) {
        this.addMailHost(hostname, "25", order, protocol, null, username, password);
    }

    public void addMailHost(String hostname, String port, String order, String protocol, String security, String username, String password) {
        Integer theOrder;
        Integer thePort;
        try {
            thePort = Integer.valueOf(port);
        }
        catch (Throwable t) {
            thePort = 25;
        }
        this.m_orderDefault += 10;
        try {
            theOrder = Integer.valueOf(order);
            if (theOrder > this.m_orderDefault) {
                this.m_orderDefault = theOrder;
            }
        }
        catch (Throwable t) {
            theOrder = this.m_orderDefault;
        }
        CmsMailHost host = new CmsMailHost(hostname, thePort, theOrder, protocol, security, username, password);
        this.m_mailHosts.add(host);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_ADD_HOST_1", host));
        }
        Collections.sort(this.m_mailHosts);
    }

    public CmsMailHost getDefaultMailHost() {
        return this.m_mailHosts.get(0);
    }

    public String getMailFromDefault() {
        return this.m_mailFromDefault;
    }

    public List<CmsMailHost> getMailHosts() {
        return Collections.unmodifiableList(this.m_mailHosts);
    }

    public void setMailFromDefault(String sender) {
        this.m_mailFromDefault = sender;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_DEFAULT_SENDER_1", this.m_mailFromDefault));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[hosts:" + this.m_mailHosts.toString());
        sb.append(", order:" + this.m_orderDefault);
        sb.append(", from:" + this.m_mailFromDefault);
        return sb.toString();
    }
}

