/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.util.Loader;

public final class CmsLog {
    public static final String FILE_LOG = "opencms.log";
    public static final String FOLDER_LOGS = "logs" + File.separatorChar;
    public static Log INIT;
    private static String m_logFileRfsFolder;
    private static String m_logFileRfsPath;

    private CmsLog() {
    }

    public static Log getLog(Object obj) {
        if (obj instanceof String) {
            return LogFactory.getLog((String)((String)obj));
        }
        if (obj instanceof Class) {
            return LogFactory.getLog((Class)((Class)obj));
        }
        return LogFactory.getLog(obj.getClass());
    }

    public static String[] render(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            throwable.printStackTrace(pw);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            if (ex instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            lines.add(ex.toString());
        }
        return lines.toArray(new String[0]);
    }

    protected static String getLogFileRfsPath() {
        return m_logFileRfsPath;
    }

    static {
        try {
            URL url = Loader.getResource((String)"log4j2.xml", null);
            if (url != null) {
                boolean setLogFile;
                File log4jProps = new File(URLDecoder.decode(url.getPath(), Charset.defaultCharset().name()));
                String path = log4jProps.getAbsolutePath();
                String webInfPath = log4jProps.getParent();
                String tldFilePath = (webInfPath = webInfPath.substring(0, webInfPath.lastIndexOf(File.separatorChar) + 1)) + "opencms.tld";
                File tldFile = new File(tldFilePath);
                if (tldFile.exists() && (setLogFile = Boolean.parseBoolean(System.getProperty("opencms.set.logfile", "true")))) {
                    String logFilePath = webInfPath + FOLDER_LOGS + FILE_LOG;
                    File logFile = new File(logFilePath);
                    m_logFileRfsPath = logFile.getAbsolutePath();
                    m_logFileRfsFolder = logFile.getParent() + File.separatorChar;
                    System.setProperty("opencms.logfile", m_logFileRfsPath);
                    System.setProperty("opencms.logfolder", m_logFileRfsFolder);
                    ConfigurationSource source = ConfigurationSource.fromUri((URI)Loader.getResource((String)"log4j2.xml", null).toURI());
                    Configurator.initialize(null, (ConfigurationSource)source);
                }
                INIT = LogFactory.getLog((String)"org.opencms.init");
                INIT.info((Object)(". Log4j config file    : " + path));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

