/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.db.CmsAliasManager;
import org.opencms.db.CmsDefaultUsers;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.CmsLoginManager;
import org.opencms.db.CmsSqlManager;
import org.opencms.db.CmsSubscriptionManager;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexCache;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.importexport.CmsImportExportManager;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.loader.CmsResourceManager;
import org.opencms.loader.CmsTemplateContextManager;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsEventManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.CmsThreadStore;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCmsCore;
import org.opencms.module.CmsModuleManager;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.publish.CmsPublishManager;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.search.CmsSearchManager;
import org.opencms.security.CmsOrgUnitManager;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleManager;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.I_CmsCredentialsResolver;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsValidationHandler;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.ui.apps.CmsWorkplaceAppManager;
import org.opencms.workflow.I_CmsWorkflowManager;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.xml.CmsXmlContentTypeManager;

public final class OpenCms {
    public static final int RUNLEVEL_0_OFFLINE = 0;
    public static final int RUNLEVEL_1_CORE_OBJECT = 1;
    public static final int RUNLEVEL_2_INITIALIZING = 2;
    public static final int RUNLEVEL_3_SHELL_ACCESS = 3;
    public static final int RUNLEVEL_4_SERVLET_ACCESS = 4;

    private OpenCms() {
    }

    public static void addCmsEventListener(I_CmsEventListener listener) {
        OpenCmsCore.getInstance().getEventManager().addCmsEventListener(listener);
    }

    public static void addCmsEventListener(I_CmsEventListener listener, int[] eventTypes) {
        OpenCmsCore.getInstance().getEventManager().addCmsEventListener(listener, eventTypes);
    }

    public static void fireCmsEvent(CmsEvent event) {
        OpenCmsCore.getInstance().getEventManager().fireEvent(event);
    }

    public static void fireCmsEvent(int type, Map<String, Object> data) {
        OpenCmsCore.getInstance().getEventManager().fireEvent(type, data);
    }

    public static CmsADEManager getADEManager() {
        return OpenCmsCore.getInstance().getADEManager();
    }

    public static CmsAliasManager getAliasManager() {
        return OpenCmsCore.getInstance().getAliasManager();
    }

    public static I_CmsAuthorizationHandler getAuthorizationHandler() {
        return OpenCmsCore.getInstance().getAuthorizationHandler();
    }

    public static I_CmsCredentialsResolver getCredentialsResolver() {
        return OpenCmsCore.getInstance().getCredentialsResolver();
    }

    public static List<String> getDbPoolNames() {
        return OpenCmsCore.getInstance().getDbPoolNames();
    }

    public static List<String> getDefaultFiles() {
        return OpenCmsCore.getInstance().getDefaultFiles();
    }

    public static CmsDefaultUsers getDefaultUsers() {
        return OpenCmsCore.getInstance().getDefaultUsers();
    }

    public static CmsEventManager getEventManager() {
        return OpenCmsCore.getInstance().getEventManager();
    }

    public static ScheduledThreadPoolExecutor getExecutor() {
        return OpenCmsCore.getInstance().getExecutor();
    }

    public static Set<CmsExportPoint> getExportPoints() {
        return OpenCmsCore.getInstance().getExportPoints();
    }

    public static CmsFlexCache getFlexCache() {
        return OpenCmsCore.getInstance().getFlexCache();
    }

    public static String getFlexCacheKeyDump() {
        return OpenCmsCore.getInstance().getFlexCacheKeyDump();
    }

    public static CmsImportExportManager getImportExportManager() {
        return OpenCmsCore.getInstance().getImportExportManager();
    }

    public static CmsLetsEncryptConfiguration getLetsEncryptConfig() {
        return OpenCmsCore.getInstance().getLetsEncryptConfig();
    }

    public static CmsLinkManager getLinkManager() {
        return OpenCmsCore.getInstance().getLinkManager();
    }

    public static CmsLocaleManager getLocaleManager() {
        return OpenCmsCore.getInstance().getLocaleManager();
    }

    public static Log getLog(Object obj) {
        return CmsLog.getLog(obj);
    }

    public static CmsLoginManager getLoginManager() {
        return OpenCmsCore.getInstance().getLoginManager();
    }

    public static CmsMemoryMonitor getMemoryMonitor() {
        return OpenCmsCore.getInstance().getMemoryMonitor();
    }

    public static CmsModuleManager getModuleManager() {
        return OpenCmsCore.getInstance().getModuleManager();
    }

    public static CmsOrgUnitManager getOrgUnitManager() {
        return OpenCmsCore.getInstance().getOrgUnitManager();
    }

    public static I_CmsPasswordHandler getPasswordHandler() {
        return OpenCmsCore.getInstance().getPasswordHandler();
    }

    public static CmsPublishManager getPublishManager() {
        return OpenCmsCore.getInstance().getPublishManager();
    }

    public static CmsRepositoryManager getRepositoryManager() {
        return OpenCmsCore.getInstance().getRepositoryManager();
    }

    public static CmsResourceManager getResourceManager() {
        return OpenCmsCore.getInstance().getResourceManager();
    }

    public static CmsRoleManager getRoleManager() {
        return OpenCmsCore.getInstance().getRoleManager();
    }

    public static int getRunLevel() {
        return OpenCmsCore.getInstance().getRunLevel();
    }

    public static Object getRuntimeProperty(Object key) {
        return OpenCmsCore.getInstance().getRuntimeProperty(key);
    }

    public static CmsScheduleManager getScheduleManager() {
        return OpenCmsCore.getInstance().getScheduleManager();
    }

    public static CmsSearchManager getSearchManager() {
        return OpenCmsCore.getInstance().getSearchManager();
    }

    public static CmsSessionManager getSessionManager() {
        return OpenCmsCore.getInstance().getSessionManager();
    }

    public static CmsSiteManagerImpl getSiteManager() {
        return OpenCmsCore.getInstance().getSiteManager();
    }

    public static CmsSqlManager getSqlManager() {
        return OpenCmsCore.getInstance().getSqlManager();
    }

    public static CmsStaticExportManager getStaticExportManager() {
        return OpenCmsCore.getInstance().getStaticExportManager();
    }

    public static CmsSubscriptionManager getSubscriptionManager() {
        return OpenCmsCore.getInstance().getSubscriptionManager();
    }

    public static CmsSystemInfo getSystemInfo() {
        return OpenCmsCore.getInstance().getSystemInfo();
    }

    public static List<CmsRole> getSystemRoles() {
        return CmsRole.getSystemRoles();
    }

    public static CmsTemplateContextManager getTemplateContextManager() {
        return OpenCmsCore.getInstance().getTemplateContextManager();
    }

    public static CmsThreadStore getThreadStore() {
        return OpenCmsCore.getInstance().getThreadStore();
    }

    public static I_CmsValidationHandler getValidationHandler() {
        return OpenCmsCore.getInstance().getValidationHandler();
    }

    public static I_CmsWorkflowManager getWorkflowManager() {
        return OpenCmsCore.getInstance().getWorkflowManager();
    }

    public static CmsWorkplaceAppManager getWorkplaceAppManager() {
        return OpenCmsCore.getInstance().getWorkplaceAppManager();
    }

    public static CmsWorkplaceManager getWorkplaceManager() {
        return OpenCmsCore.getInstance().getWorkplaceManager();
    }

    public static CmsXmlContentTypeManager getXmlContentTypeManager() {
        return OpenCmsCore.getInstance().getXmlContentTypeManager();
    }

    public static CmsObject initCmsObject(CmsObject cms) throws CmsException {
        return OpenCmsCore.getInstance().initCmsObject(cms);
    }

    public static CmsObject initCmsObject(CmsObject adminCms, CmsContextInfo contextInfo) throws CmsException {
        return OpenCmsCore.getInstance().initCmsObject(adminCms, contextInfo);
    }

    public static CmsObject initCmsObject(String user) throws CmsException {
        return OpenCmsCore.getInstance().initCmsObject(user);
    }

    public static CmsResource initResource(CmsObject cms, String resourceName, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        return OpenCmsCore.getInstance().initResource(cms, resourceName, req, res);
    }

    public static void removeCmsEventListener(I_CmsEventListener listener) {
        OpenCmsCore.getInstance().getEventManager().removeCmsEventListener(listener);
    }

    public static void setRuntimeProperty(Object key, Object value) {
        OpenCmsCore.getInstance().setRuntimeProperty(key, value);
    }

    public static void writeConfiguration(Class<?> clazz) {
        OpenCmsCore.getInstance().writeConfiguration(clazz);
    }
}

