/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.search.solr.spellchecking.CmsSolrSpellchecker;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;

public class OpenCmsSpellcheckHandler
extends HttpServlet
implements I_CmsRequestHandler {
    public static final String PARAM_BASE_URI = "baseUri";
    protected static final String HEADER_REFERER_KEY = "referer";
    private static final String HANDLER_NAME = "SpellcheckDictionary";
    private static final String[] HANDLER_NAMES = new String[]{"SpellcheckDictionary"};
    private static final Log LOG = CmsLog.getLog(OpenCmsSpellcheckHandler.class);
    private static final long serialVersionUID = -6028091947126209813L;

    public static String getSpellcheckHandlerPath() {
        return "/handleSpellcheckDictionary";
    }

    public static boolean isSpellcheckingEnabled() {
        return OpenCmsCore.getInstance().getRequestHandler(HANDLER_NAME) != null;
    }

    @Override
    public String[] getHandlerNames() {
        return HANDLER_NAMES;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res, String name) throws IOException {
        try {
            CmsObject cms = this.getCmsObject(req);
            CmsSolrSpellchecker dict = OpenCms.getSearchManager().getSolrDictionary();
            if (dict != null) {
                dict.getSpellcheckingResult(res, (ServletRequest)req, cms);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected CmsObject getCmsObject(HttpServletRequest req) throws CmsException {
        String baseUri;
        CmsObject cms = OpenCmsCore.getInstance().initCmsObjectFromSession(req);
        if (cms == null) {
            cms = OpenCmsCore.getInstance().initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            String siteRoot = OpenCmsCore.getInstance().getSiteManager().matchRequest(req).getSiteRoot();
            cms.getRequestContext().setSiteRoot(siteRoot);
        }
        if ((baseUri = this.getBaseUri(req, cms)) != null) {
            cms.getRequestContext().setUri(baseUri);
        }
        return cms;
    }

    private String getBaseUri(HttpServletRequest req, CmsObject cms) {
        String baseUri = req.getParameter(PARAM_BASE_URI);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(baseUri)) {
            String referer = req.getHeader(HEADER_REFERER_KEY);
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
            if (site != null) {
                String prefix = site.getServerPrefix(cms, "/") + OpenCms.getStaticExportManager().getVfsPrefix();
                if (referer != null && referer.startsWith(prefix)) {
                    baseUri = referer.substring(prefix.length());
                }
            }
        }
        return baseUri;
    }
}

