/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleUpdater;
import org.opencms.module.CmsResourceImportData;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsModuleImportData {
    private static final Log LOG = CmsLog.getLog(CmsModuleImportData.class);
    private CmsObject m_cms;
    private Map<CmsUUID, CmsUUID> m_conflictingIds = new HashMap<CmsUUID, CmsUUID>();
    private CmsModule m_module;
    private CmsObject m_onlineCms;
    private List<CmsResourceImportData> m_resources = new ArrayList<CmsResourceImportData>();

    public void addResource(CmsResourceImportData resourceData) {
        this.m_resources.add(resourceData);
    }

    public boolean checkUpdatable(CmsObject cms) {
        CmsModule newModule = this.getModule();
        LOG.info((Object)("Checking if module " + newModule.getName() + " is updateable"));
        String exportVersion = newModule.getExportVersion();
        CmsModule installedModule = OpenCms.getModuleManager().getModule(this.getModule().getName());
        if (!CmsModuleUpdater.checkCompatibleModuleResources(installedModule, newModule)) {
            LOG.info((Object)"Module is not updateable because of incompatible module resources. ");
            return false;
        }
        if (exportVersion == null || !exportVersion.equals("10")) {
            LOG.info((Object)"Module is not updateable because the export version is not 10.");
            return false;
        }
        try {
            CmsObject onlineCms;
            HashMap<CmsUUID, CmsResourceImportData> importResourcesById = new HashMap<CmsUUID, CmsResourceImportData>();
            for (CmsResourceImportData resData : this.getResourceData()) {
                if (!resData.hasStructureId()) continue;
                importResourcesById.put(resData.getResource().getStructureId(), resData);
            }
            cms = this.getCms();
            this.m_onlineCms = onlineCms = OpenCms.initCmsObject(cms);
            CmsProject online = cms.readProject("Online");
            onlineCms.getRequestContext().setCurrentProject(online);
            for (CmsResourceImportData resData : this.getResourceData()) {
                String importPath = CmsModuleUpdater.normalizePath(resData.getResource().getRootPath());
                if (resData.hasStructureId()) {
                    CmsUUID importId = resData.getResource().getStructureId();
                    for (CmsObject cmsToRead : Arrays.asList(cms, onlineCms)) {
                        try {
                            CmsResource resourceFromVfs = cmsToRead.readResource(importPath, CmsResourceFilter.ALL);
                            boolean skipResourceIdCheck = false;
                            if (!resourceFromVfs.getStructureId().equals(importId)) {
                                if (resData.getResource().isFile() && resourceFromVfs.isFile() && !this.containsStructureId(resourceFromVfs.getStructureId()) && !this.vfsResourceWithStructureId(importId)) {
                                    LOG.info((Object)("Permitting conflicting id in module update for resource " + resData.getPath() + " because the id from the module is not present in the VFS and vice versa."));
                                    this.m_conflictingIds.put(importId, resourceFromVfs.getStructureId());
                                    skipResourceIdCheck = true;
                                } else {
                                    LOG.info((Object)("Module is not updateable because the same path is mapped to different structure ids in the import and in the VFS: " + importPath));
                                    return false;
                                }
                            }
                            if (skipResourceIdCheck || !resData.getResource().isFile() || resData.getResource().getResourceId().equals(resourceFromVfs.getResourceId())) continue;
                            LOG.info((Object)("Module is not updateable because of a resource id conflict for " + resData.getResource().getRootPath()));
                            return false;
                        }
                        catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
                        }
                    }
                    try {
                        CmsResource vfsResource = cms.readResource(importId, CmsResourceFilter.ALL);
                        if (vfsResource.isFolder() == resData.getResource().isFolder()) continue;
                        LOG.info((Object)"Module is not updateable because the same id belongs to a file in the import and a folder in the VFS, or vice versa");
                        return false;
                    }
                    catch (CmsVfsResourceNotFoundException vfsResource) {
                        continue;
                    }
                }
                CmsModule module = this.getModule();
                boolean included = false;
                boolean excluded = false;
                for (String res : module.getResources()) {
                    if (!CmsStringUtil.isPrefixPath(res, resData.getPath())) continue;
                    included = true;
                    break;
                }
                for (String res : module.getExcludeResources()) {
                    if (!CmsStringUtil.isPrefixPath(res, resData.getPath())) continue;
                    excluded = true;
                    break;
                }
                if (!included || excluded) continue;
                LOG.info((Object)"Module is not updateable because one of the resource entries included in the module resources has no structure id in the manifest.");
                return false;
            }
            return true;
        }
        catch (CmsException e) {
            LOG.info((Object)("Module is not updateable because of error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public Map<CmsUUID, CmsUUID> getConflictingIds() {
        return this.m_conflictingIds;
    }

    public CmsModule getModule() {
        return this.m_module;
    }

    public List<CmsResourceImportData> getResourceData() {
        return Collections.unmodifiableList(this.m_resources);
    }

    public void setCms(CmsObject cms) {
        this.m_cms = cms;
    }

    public void setModule(CmsModule module) {
        this.m_module = module;
    }

    private boolean containsStructureId(CmsUUID structureId) {
        for (CmsResourceImportData res : this.m_resources) {
            if (!res.getResource().getStructureId().equals(structureId)) continue;
            return true;
        }
        return false;
    }

    private boolean vfsResourceWithStructureId(CmsUUID importId) {
        return this.m_cms.existsResource(importId, CmsResourceFilter.ALL) || this.m_onlineCms.existsResource(importId, CmsResourceFilter.ALL);
    }
}

