/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.Serializable;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.module.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsModuleVersion
implements Comparable<Object>,
Serializable {
    public static final String DEFAULT_VERSION = "0.1";
    private static final long serialVersionUID = 5871716904011659917L;
    private int m_dots;
    private long m_number;
    private boolean m_updated;
    private String m_version;

    public CmsModuleVersion(String version) {
        this.setVersion(version);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsModuleVersion) {
            if (this.m_version == null) {
                return 0;
            }
            CmsModuleVersion other = (CmsModuleVersion)obj;
            if (this.m_number == other.m_number) {
                return 0;
            }
            return this.m_number > other.m_number ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsModuleVersion) {
            CmsModuleVersion other = (CmsModuleVersion)obj;
            if (this.m_version == null) {
                return other.m_version == null;
            }
            return this.m_version.equals(other.m_version);
        }
        return false;
    }

    public String getVersion() {
        return this.m_version;
    }

    public int hashCode() {
        if (this.m_version == null) {
            return 0;
        }
        return this.m_version.hashCode();
    }

    public void setVersion(String version) {
        int i;
        this.m_number = 0L;
        if (version == null || version.charAt(0) == '.' || version.charAt(version.length() - 1) == '.') {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NOT_NUMBER_0"));
        }
        String[] split = CmsStringUtil.splitAsArray(version, '.');
        this.m_dots = split.length;
        if (this.m_dots > 4) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_VERSION_LENGTH_1", version));
        }
        String[] numbers = new String[5];
        System.arraycopy(split, 0, numbers, 1, this.m_dots);
        numbers[0] = "1";
        for (i = 1 + this.m_dots; i < 5; ++i) {
            numbers[i] = "0";
        }
        for (i = numbers.length - 1; i >= 0; --i) {
            try {
                int number = Integer.valueOf(numbers[numbers.length - i - 1]);
                if (number > 999 || number < 0) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_VERSION_SUBNUMBER_1", new Integer(number)));
                }
                this.m_number = (long)Math.pow(1000.0, i) * (long)number + this.m_number;
                continue;
            }
            catch (NumberFormatException e) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_NOT_NUMBER_0"));
            }
        }
        this.setVersion(this.m_number);
    }

    public String toString() {
        return this.getVersion();
    }

    protected void increment() {
        if (this.m_number < 1999999999999L) {
            this.m_number += (long)Math.pow(1000.0, 4 - this.m_dots);
        } else {
            throw new CmsRuntimeException(Messages.get().container("ERR_MODULE_VERSION_NUMBER_0"));
        }
        this.setVersion(this.m_number);
    }

    protected boolean isUpdated() {
        return this.m_updated;
    }

    protected void setUpdated(boolean updated) {
        this.m_updated = updated;
    }

    private void setVersion(long number) {
        String result = "";
        for (int i = 0; i < 4; ++i) {
            long mod = number % 1000L;
            number /= 1000L;
            if (this.m_dots < 4 - i) continue;
            if (this.m_dots > 4 - i) {
                result = '.' + result;
            }
            result = "" + mod + result;
        }
        this.m_version = result;
    }
}

