/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.monitor;

import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.buffer.SynchronizedBuffer;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.Email;
import org.opencms.cache.CmsLruCache;
import org.opencms.cache.CmsMemoryObjectCache;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.cache.I_CmsLruCacheObject;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexCache;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockManager;
import org.opencms.mail.CmsMailTransport;
import org.opencms.mail.CmsSimpleMail;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitorConfiguration;
import org.opencms.monitor.CmsMemoryStatus;
import org.opencms.monitor.I_CmsMemoryMonitorable;
import org.opencms.monitor.Messages;
import org.opencms.publish.CmsPublishHistory;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.CmsPublishQueue;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.PrintfFormat;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;

public class CmsMemoryMonitor
implements I_CmsScheduledJob {
    private static final int CONCURRENCY_LEVEL = 8;
    private static final int INTERVAL_CLEAR = 600000;
    private static final Log LOG = CmsLog.getLog(CmsMemoryMonitor.class);
    private static boolean m_currentlyRunning;
    private static final int MAX_DEPTH = 5;
    private Map<String, CmsAccessControlList> m_cacheAccessControlList;
    private Map<String, CmsXmlContentDefinition> m_cacheContentDefinitions;
    private Map<String, CmsGroup> m_cacheGroup;
    private Map<String, Boolean> m_cacheHasRoles;
    private Map<String, Locale> m_cacheLocale;
    private Map<String, CmsLock> m_cacheLock;
    private Map<String, Object> m_cacheMemObject;
    private Map<String, CmsOrganizationalUnit> m_cacheOrgUnit;
    private Map<String, I_CmsPermissionHandler.CmsPermissionCheckResult> m_cachePermission;
    private Map<String, CmsProject> m_cacheProject;
    private Map<String, List<CmsResource>> m_cacheProjectResources;
    private Map<String, CmsProperty> m_cacheProperty;
    private Map<String, List<CmsProperty>> m_cachePropertyList;
    private Map<String, List<CmsPublishedResource>> m_cachePublishedResources;
    private Map<String, CmsResource> m_cacheResource;
    private Map<String, List<CmsResource>> m_cacheResourceList;
    private Map<String, List<CmsRole>> m_cacheRoleLists;
    private Map<String, CmsUser> m_cacheUser;
    private Map<String, List<CmsGroup>> m_cacheUserGroups;
    private Map<String, List<CmsUser>> m_cacheUserList;
    private Map<String, Object> m_cacheVfsObject;
    private Map<String, byte[]> m_cacheXmlPermanentEntity;
    private Map<String, byte[]> m_cacheXmlTemporaryEntity;
    private CmsMemoryMonitorConfiguration m_configuration;
    private Map<CacheType, Boolean> m_disabled = new HashMap<CacheType, Boolean>();
    private int m_intervalEmail;
    private int m_intervalLog;
    private int m_intervalWarning;
    private long m_lastClearCache;
    private long m_lastEmailStatus;
    private long m_lastEmailWarning;
    private long m_lastLogStatus;
    private long m_lastLogWarning;
    private int m_logCount;
    private int m_maxUsagePercent;
    private CmsMemoryStatus m_memoryAverage;
    private CmsMemoryStatus m_memoryCurrent;
    private Map<String, Object> m_monitoredObjects = new HashMap<String, Object>();
    private Buffer m_publishHistory;
    private Buffer m_publishQueue;
    private boolean m_warningLoggedSinceLastStatus;
    private boolean m_warningSendSinceLastStatus;

    public static <T, V> Map<T, V> createLRUCacheMap(int capacity) {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(8).maximumSize((long)capacity);
        builder.build();
        return builder.build().asMap();
    }

    public static int getMemorySize(Object obj) {
        if (obj instanceof I_CmsMemoryMonitorable) {
            return ((I_CmsMemoryMonitorable)obj).getMemorySize();
        }
        if (obj instanceof byte[]) {
            return 8 + (int)(Math.ceil((double)((byte[])obj).length / 16.0) * 16.0);
        }
        if (obj instanceof String) {
            return 24 + (int)(Math.ceil((double)((String)obj).length() / 8.0) * 16.0);
        }
        if (obj instanceof CmsFile) {
            CmsFile f = (CmsFile)obj;
            if (f.getContents() != null) {
                return f.getContents().length + 1024;
            }
            return 1024;
        }
        if (obj instanceof CmsUUID) {
            return 184;
        }
        if (obj instanceof CmsPermissionSet) {
            return 16;
        }
        if (obj instanceof CmsResource) {
            return 1024;
        }
        if (obj instanceof CmsPublishedResource) {
            return 512;
        }
        if (obj instanceof CmsUser) {
            return 2048;
        }
        if (obj instanceof CmsGroup) {
            return 512;
        }
        if (obj instanceof CmsProject) {
            return 512;
        }
        if (obj instanceof Boolean) {
            return 8;
        }
        if (obj instanceof CmsProperty) {
            int size = 8;
            CmsProperty property = (CmsProperty)obj;
            size += CmsMemoryMonitor.getMemorySize(property.getName());
            if (property.getResourceValue() != null) {
                size += CmsMemoryMonitor.getMemorySize(property.getResourceValue());
            }
            if (property.getStructureValue() != null) {
                size += CmsMemoryMonitor.getMemorySize(property.getStructureValue());
            }
            if (property.getOrigin() != null) {
                size += CmsMemoryMonitor.getMemorySize(property.getOrigin());
            }
            return size;
        }
        if (obj instanceof CmsPropertyDefinition) {
            int size = 8;
            CmsPropertyDefinition propDef = (CmsPropertyDefinition)obj;
            size += CmsMemoryMonitor.getMemorySize(propDef.getName());
            return size += CmsMemoryMonitor.getMemorySize(propDef.getId());
        }
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    public static long getValueSize(List<?> listValue, int depth) {
        long totalSize;
        block8: {
            totalSize = 0L;
            try {
                for (Object object : listValue.toArray()) {
                    void var7_8;
                    void var7_11;
                    if (object instanceof CmsAccessControlList) {
                        Map<CmsUUID, CmsPermissionSetCustom> map = ((CmsAccessControlList)object).getPermissionMap();
                    }
                    if (var7_11 instanceof CmsFlexCache.CmsFlexCacheVariation) {
                        Map<String, I_CmsLruCacheObject> map = ((CmsFlexCache.CmsFlexCacheVariation)var7_11).m_map;
                    }
                    if (var7_8 instanceof Map && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((Map)var7_8, depth + 1);
                        continue;
                    }
                    if (var7_8 instanceof List && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((List)var7_8, depth + 1);
                        continue;
                    }
                    totalSize += (long)CmsMemoryMonitor.getMemorySize(var7_8);
                }
            }
            catch (ConcurrentModificationException values) {
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CAUGHT_THROWABLE_1", t.getMessage()));
            }
        }
        return totalSize;
    }

    /*
     * WARNING - void declaration
     */
    public static long getValueSize(Map<?, ?> mapValue, int depth) {
        long totalSize;
        block8: {
            totalSize = 0L;
            try {
                for (Object object : mapValue.values().toArray()) {
                    void var7_8;
                    void var7_11;
                    if (object instanceof CmsAccessControlList) {
                        Map<CmsUUID, CmsPermissionSetCustom> map = ((CmsAccessControlList)object).getPermissionMap();
                    }
                    if (var7_11 instanceof CmsFlexCache.CmsFlexCacheVariation) {
                        Map<String, I_CmsLruCacheObject> map = ((CmsFlexCache.CmsFlexCacheVariation)var7_11).m_map;
                    }
                    if (var7_8 instanceof Map && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((Map)var7_8, depth + 1);
                        continue;
                    }
                    if (var7_8 instanceof List && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((List)var7_8, depth + 1);
                        continue;
                    }
                    totalSize += (long)CmsMemoryMonitor.getMemorySize(var7_8);
                }
            }
            catch (ConcurrentModificationException values) {
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CAUGHT_THROWABLE_1", t.getMessage()));
            }
        }
        return totalSize;
    }

    public static long getValueSize(Object obj) {
        if (obj instanceof CmsLruCache) {
            return ((CmsLruCache)obj).size();
        }
        if (obj instanceof Map) {
            return CmsMemoryMonitor.getValueSize((Map)obj, 1);
        }
        if (obj instanceof List) {
            return CmsMemoryMonitor.getValueSize((List)obj, 1);
        }
        try {
            return CmsMemoryMonitor.getMemorySize(obj);
        }
        catch (Exception exc) {
            return 0L;
        }
    }

    public void cacheACL(String key, CmsAccessControlList acl) {
        if (this.m_disabled.get((Object)CacheType.ACL) != null) {
            return;
        }
        this.m_cacheAccessControlList.put(key, acl);
    }

    public void cacheContentDefinition(String key, CmsXmlContentDefinition contentDefinition) {
        if (this.m_disabled.get((Object)CacheType.CONTENT_DEFINITION) != null) {
            return;
        }
        this.m_cacheContentDefinitions.put(key, contentDefinition);
    }

    public void cacheGroup(CmsGroup group) {
        if (this.m_disabled.get((Object)CacheType.GROUP) != null) {
            return;
        }
        this.m_cacheGroup.put(group.getId().toString(), group);
        this.m_cacheGroup.put(group.getName(), group);
    }

    public void cacheLocale(String key, Locale locale) {
        if (this.m_cacheLocale != null) {
            if (this.m_disabled.get((Object)CacheType.LOCALE) != null) {
                return;
            }
            this.m_cacheLocale.put(key, locale);
        }
    }

    public void cacheLock(CmsLock lock) {
        if (this.m_disabled.get((Object)CacheType.LOCK) != null) {
            return;
        }
        this.m_cacheLock.put(lock.getResourceName(), lock);
    }

    public void cacheMemObject(String key, Object obj) {
        if (this.m_disabled.get((Object)CacheType.MEMORY_OBJECT) != null) {
            return;
        }
        this.m_cacheMemObject.put(key, obj);
    }

    public void cacheOrgUnit(CmsOrganizationalUnit orgUnit) {
        if (this.m_disabled.get((Object)CacheType.ORG_UNIT) != null) {
            return;
        }
        this.m_cacheOrgUnit.put(orgUnit.getId().toString(), orgUnit);
        this.m_cacheOrgUnit.put(orgUnit.getName(), orgUnit);
    }

    public void cachePermission(String key, I_CmsPermissionHandler.CmsPermissionCheckResult permission) {
        if (this.m_disabled.get((Object)CacheType.PERMISSION) != null) {
            return;
        }
        this.m_cachePermission.put(key, permission);
    }

    public void cacheProject(CmsProject project) {
        if (this.m_disabled.get((Object)CacheType.PROJECT) != null) {
            return;
        }
        this.m_cacheProject.put(project.getUuid().toString(), project);
        this.m_cacheProject.put(project.getName(), project);
    }

    public void cacheProjectResources(String key, List<CmsResource> projectResources) {
        if (this.m_disabled.get((Object)CacheType.PROJECT_RESOURCES) != null) {
            return;
        }
        this.m_cacheProjectResources.put(key, projectResources);
    }

    public void cacheProperty(String key, CmsProperty property) {
        if (this.m_disabled.get((Object)CacheType.PROPERTY) != null) {
            return;
        }
        this.m_cacheProperty.put(key, property);
    }

    public void cachePropertyList(String key, List<CmsProperty> propertyList) {
        if (this.m_disabled.get((Object)CacheType.PROPERTY_LIST) != null) {
            return;
        }
        this.m_cachePropertyList.put(key, propertyList);
    }

    public void cachePublishedResources(String cacheKey, List<CmsPublishedResource> publishedResources) {
        if (this.m_disabled.get((Object)CacheType.PUBLISHED_RESOURCES) != null) {
            return;
        }
        this.m_cachePublishedResources.put(cacheKey, publishedResources);
    }

    public void cachePublishJob(CmsPublishJobInfoBean publishJob) {
        if (this.m_disabled.get((Object)CacheType.PUBLISH_QUEUE) != null) {
            return;
        }
        this.m_publishQueue.add((Object)publishJob);
    }

    public void cachePublishJobInHistory(CmsPublishJobInfoBean publishJob) {
        if (this.m_disabled.get((Object)CacheType.PUBLISH_HISTORY) != null) {
            return;
        }
        this.m_publishHistory.add((Object)publishJob);
    }

    public void cacheResource(String key, CmsResource resource) {
        if (this.m_disabled.get((Object)CacheType.RESOURCE) != null) {
            return;
        }
        this.m_cacheResource.put(key, resource);
    }

    public void cacheResourceList(String key, List<CmsResource> resourceList) {
        if (this.m_disabled.get((Object)CacheType.RESOURCE_LIST) != null) {
            return;
        }
        this.m_cacheResourceList.put(key, resourceList);
    }

    public void cacheRole(String key, boolean hasRole) {
        if (this.m_disabled.get((Object)CacheType.HAS_ROLE) != null) {
            return;
        }
        this.m_cacheHasRoles.put(key, hasRole);
    }

    public void cacheRoleList(String key, List<CmsRole> roles) {
        if (this.m_disabled.get((Object)CacheType.ROLE_LIST) != null) {
            return;
        }
        this.m_cacheRoleLists.put(key, roles);
    }

    public void cacheUser(CmsUser user) {
        if (this.m_disabled.get((Object)CacheType.USER) != null) {
            return;
        }
        this.m_cacheUser.put(user.getId().toString(), user);
        this.m_cacheUser.put(user.getName(), user);
    }

    public void cacheUserGroups(String key, List<CmsGroup> userGroups) {
        if (this.m_disabled.get((Object)CacheType.USERGROUPS) != null) {
            return;
        }
        this.m_cacheUserGroups.put(key, userGroups);
    }

    public void cacheUserList(String key, List<CmsUser> userList) {
        if (this.m_disabled.get((Object)CacheType.USER_LIST) != null) {
            return;
        }
        this.m_cacheUserList.put(key, userList);
    }

    public void cacheVfsObject(String key, Object obj) {
        if (this.m_disabled.get((Object)CacheType.VFS_OBJECT) != null) {
            return;
        }
        this.m_cacheVfsObject.put(key, obj);
    }

    public void cacheXmlPermanentEntity(String systemId, byte[] content) {
        if (this.m_disabled.get((Object)CacheType.XML_ENTITY_PERM) != null) {
            return;
        }
        this.m_cacheXmlPermanentEntity.put(systemId, content);
    }

    public void cacheXmlTemporaryEntity(String key, byte[] content) {
        if (this.m_disabled.get((Object)CacheType.XML_ENTITY_TEMP) != null) {
            return;
        }
        this.m_cacheXmlTemporaryEntity.put(key, content);
    }

    public void clearAccessControlListCache() {
        this.flushCache(CacheType.ACL);
        this.flushCache(CacheType.PERMISSION);
        this.clearResourceCache();
    }

    public void clearCache() {
        this.clearPrincipalsCache();
        this.flushCache(CacheType.PROJECT);
        this.flushCache(CacheType.RESOURCE);
        this.flushCache(CacheType.RESOURCE_LIST);
        this.flushCache(CacheType.PROPERTY);
        this.flushCache(CacheType.PROPERTY_LIST);
        this.flushCache(CacheType.PROJECT_RESOURCES);
        this.flushCache(CacheType.PUBLISHED_RESOURCES);
    }

    public void clearPrincipalsCache() {
        this.flushCache(CacheType.USER);
        this.flushCache(CacheType.GROUP);
        this.flushCache(CacheType.ORG_UNIT);
        this.flushCache(CacheType.ACL);
        this.flushCache(CacheType.PERMISSION);
        this.flushCache(CacheType.HAS_ROLE);
        this.flushCache(CacheType.ROLE_LIST);
        this.flushCache(CacheType.USERGROUPS);
        this.flushCache(CacheType.USER_LIST);
    }

    public void clearResourceCache() {
        this.flushCache(CacheType.RESOURCE);
        this.flushCache(CacheType.RESOURCE_LIST);
        this.flushCache(CacheType.HAS_ROLE);
        this.flushCache(CacheType.ROLE_LIST);
    }

    public void clearUserCache(CmsUser user) {
        this.uncacheUser(user);
        this.flushCache(CacheType.RESOURCE_LIST);
    }

    public void disableCache(CacheType ... types) {
        for (CacheType type : types) {
            this.m_disabled.put(type, Boolean.TRUE);
        }
        this.flushCache(types);
    }

    public void enableCache(CacheType ... types) {
        for (CacheType type : types) {
            this.m_disabled.remove((Object)type);
        }
    }

    public boolean enabled() {
        return true;
    }

    @Deprecated
    public void flushACLs() {
        this.flushCache(CacheType.ACL);
    }

    public void flushCache(CacheType ... types) {
        block27: for (CacheType type : types) {
            switch (type) {
                case ACL: {
                    this.m_cacheAccessControlList.clear();
                    continue block27;
                }
                case CONTENT_DEFINITION: {
                    this.m_cacheContentDefinitions.clear();
                    continue block27;
                }
                case GROUP: {
                    this.m_cacheGroup.clear();
                    continue block27;
                }
                case HAS_ROLE: {
                    this.m_cacheHasRoles.clear();
                    continue block27;
                }
                case LOCALE: {
                    this.m_cacheLocale.clear();
                    continue block27;
                }
                case LOCK: {
                    this.m_cacheLock.clear();
                    continue block27;
                }
                case MEMORY_OBJECT: {
                    this.m_cacheMemObject.clear();
                    continue block27;
                }
                case ORG_UNIT: {
                    this.m_cacheOrgUnit.clear();
                    continue block27;
                }
                case PERMISSION: {
                    this.m_cachePermission.clear();
                    continue block27;
                }
                case PROJECT: {
                    this.m_cacheProject.clear();
                    continue block27;
                }
                case PROJECT_RESOURCES: {
                    this.m_cacheProjectResources.clear();
                    continue block27;
                }
                case PROPERTY: {
                    this.m_cacheProperty.clear();
                    continue block27;
                }
                case PROPERTY_LIST: {
                    this.m_cachePropertyList.clear();
                    continue block27;
                }
                case PUBLISHED_RESOURCES: {
                    this.m_cachePublishedResources.clear();
                    continue block27;
                }
                case PUBLISH_HISTORY: {
                    this.m_publishHistory.clear();
                    continue block27;
                }
                case PUBLISH_QUEUE: {
                    this.m_publishQueue.clear();
                    continue block27;
                }
                case RESOURCE: {
                    this.m_cacheResource.clear();
                    continue block27;
                }
                case RESOURCE_LIST: {
                    this.m_cacheResourceList.clear();
                    continue block27;
                }
                case ROLE_LIST: {
                    this.m_cacheRoleLists.clear();
                    continue block27;
                }
                case USER: {
                    this.m_cacheUser.clear();
                    continue block27;
                }
                case USERGROUPS: {
                    this.m_cacheUserGroups.clear();
                    continue block27;
                }
                case USER_LIST: {
                    this.m_cacheUserList.clear();
                    continue block27;
                }
                case VFS_OBJECT: {
                    this.m_cacheVfsObject.clear();
                    continue block27;
                }
                case XML_ENTITY_PERM: {
                    this.m_cacheXmlPermanentEntity.clear();
                    continue block27;
                }
                case XML_ENTITY_TEMP: {
                    this.m_cacheXmlTemporaryEntity.clear();
                    continue block27;
                }
            }
        }
    }

    @Deprecated
    public void flushContentDefinitions() {
        this.flushCache(CacheType.CONTENT_DEFINITION);
    }

    @Deprecated
    public void flushGroups() {
        this.flushCache(CacheType.GROUP);
    }

    @Deprecated
    public void flushLocales() {
        this.flushCache(CacheType.LOCALE);
    }

    public void flushLocks(Map<String, CmsLock> newLocks) {
        if (newLocks == null || newLocks.isEmpty()) {
            this.flushCache(CacheType.LOCK);
            return;
        }
        ConcurrentHashMap<String, CmsLock> newLockCache = new ConcurrentHashMap<String, CmsLock>(newLocks);
        this.register(CmsLockManager.class.getName(), newLockCache);
        Map<String, CmsLock> oldCache = this.m_cacheLock;
        this.m_cacheLock = newLockCache;
        oldCache.clear();
    }

    @Deprecated
    public void flushMemObjects() {
        this.flushCache(CacheType.MEMORY_OBJECT);
    }

    @Deprecated
    public void flushOrgUnits() {
        this.flushCache(CacheType.ORG_UNIT);
    }

    @Deprecated
    public void flushPermissions() {
        this.flushCache(CacheType.PERMISSION);
    }

    @Deprecated
    public void flushProjectResources() {
        this.flushCache(CacheType.PROJECT_RESOURCES);
    }

    @Deprecated
    public void flushProjects() {
        this.flushCache(CacheType.PROJECT);
    }

    @Deprecated
    public void flushProperties() {
        this.flushCache(CacheType.PROPERTY);
    }

    @Deprecated
    public void flushPropertyLists() {
        this.flushCache(CacheType.PROPERTY_LIST);
    }

    @Deprecated
    public void flushPublishedResources() {
        this.flushCache(CacheType.PUBLISHED_RESOURCES);
    }

    @Deprecated
    public void flushPublishJobHistory() {
        this.flushCache(CacheType.PUBLISH_HISTORY);
    }

    @Deprecated
    public void flushPublishJobs() {
        this.flushCache(CacheType.PUBLISH_QUEUE);
    }

    @Deprecated
    public void flushResourceLists() {
        this.flushCache(CacheType.RESOURCE_LIST);
    }

    @Deprecated
    public void flushResources() {
        this.flushCache(CacheType.RESOURCE);
    }

    @Deprecated
    public void flushRoleLists() {
        this.flushCache(CacheType.ROLE_LIST);
    }

    @Deprecated
    public void flushRoles() {
        this.flushCache(CacheType.HAS_ROLE);
    }

    @Deprecated
    public void flushUserGroups() {
        this.flushCache(CacheType.USERGROUPS);
        this.flushCache(CacheType.USER_LIST);
    }

    @Deprecated
    public void flushUsers() {
        this.flushCache(CacheType.USER);
    }

    @Deprecated
    public void flushVfsObjects() {
        this.flushCache(CacheType.VFS_OBJECT);
    }

    @Deprecated
    public void flushXmlPermanentEntities() {
        this.flushCache(CacheType.XML_ENTITY_PERM);
    }

    @Deprecated
    public void flushXmlTemporaryEntities() {
        this.flushCache(CacheType.XML_ENTITY_TEMP);
    }

    public List<String> getAllCachedLockPaths() {
        return new ArrayList<String>(this.m_cacheLock.keySet());
    }

    public List<CmsLock> getAllCachedLocks() {
        return new ArrayList<CmsLock>(this.m_cacheLock.values());
    }

    public List<CmsPublishJobInfoBean> getAllCachedPublishJobs() {
        return new ArrayList<CmsPublishJobInfoBean>((Collection<CmsPublishJobInfoBean>)this.m_publishQueue);
    }

    public List<CmsPublishJobInfoBean> getAllCachedPublishJobsInHistory() {
        return new ArrayList<CmsPublishJobInfoBean>((Collection<CmsPublishJobInfoBean>)this.m_publishHistory);
    }

    public CmsAccessControlList getCachedACL(String key) {
        return this.m_cacheAccessControlList.get(key);
    }

    public CmsXmlContentDefinition getCachedContentDefinition(String key) {
        return this.m_cacheContentDefinitions.get(key);
    }

    public CmsGroup getCachedGroup(String key) {
        return this.m_cacheGroup.get(key);
    }

    public Locale getCachedLocale(String key) {
        if (this.m_cacheLocale == null) {
            return null;
        }
        return this.m_cacheLocale.get(key);
    }

    public CmsLock getCachedLock(String rootPath) {
        return this.m_cacheLock.get(rootPath);
    }

    public Object getCachedMemObject(String key) {
        return this.m_cacheMemObject.get(key);
    }

    public CmsOrganizationalUnit getCachedOrgUnit(String key) {
        return this.m_cacheOrgUnit.get(key);
    }

    public I_CmsPermissionHandler.CmsPermissionCheckResult getCachedPermission(String key) {
        return this.m_cachePermission.get(key);
    }

    public CmsProject getCachedProject(String key) {
        return this.m_cacheProject.get(key);
    }

    public List<CmsResource> getCachedProjectResources(String key) {
        return this.m_cacheProjectResources.get(key);
    }

    public CmsProperty getCachedProperty(String key) {
        return this.m_cacheProperty.get(key);
    }

    public List<CmsProperty> getCachedPropertyList(String key) {
        return this.m_cachePropertyList.get(key);
    }

    public List<CmsPublishedResource> getCachedPublishedResources(String cacheKey) {
        return this.m_cachePublishedResources.get(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishJobInfoBean getCachedPublishJob(String key) {
        Buffer buffer = this.m_publishQueue;
        synchronized (buffer) {
            for (Object obj : this.m_publishQueue) {
                CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)obj;
                if (!publishJob.getPublishHistoryId().toString().equals(key)) continue;
                return publishJob;
            }
        }
        return null;
    }

    public CmsPublishJobInfoBean getCachedPublishJobInHistory(String key) {
        for (Object obj : this.m_publishHistory) {
            CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)obj;
            if (!publishJob.getPublishHistoryId().toString().equals(key)) continue;
            return publishJob;
        }
        return null;
    }

    public CmsResource getCachedResource(String key) {
        return this.m_cacheResource.get(key);
    }

    public List<CmsResource> getCachedResourceList(String key) {
        return this.m_cacheResourceList.get(key);
    }

    public Boolean getCachedRole(String key) {
        return this.m_cacheHasRoles.get(key);
    }

    public List<CmsRole> getCachedRoleList(String key) {
        return this.m_cacheRoleLists.get(key);
    }

    public CmsUser getCachedUser(String key) {
        return this.m_cacheUser.get(key);
    }

    public List<CmsGroup> getCachedUserGroups(String key) {
        return this.m_cacheUserGroups.get(key);
    }

    public List<CmsUser> getCachedUserList(String key) {
        return this.m_cacheUserList.get(key);
    }

    public Object getCachedVfsObject(String key) {
        return this.m_cacheVfsObject.get(key);
    }

    public byte[] getCachedXmlPermanentEntity(String systemId) {
        return this.m_cacheXmlPermanentEntity.get(systemId);
    }

    public byte[] getCachedXmlTemporaryEntity(String key) {
        return this.m_cacheXmlTemporaryEntity.get(key);
    }

    public CmsMemoryMonitorConfiguration getConfiguration() {
        return this.m_configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishJobInfoBean getFirstCachedPublishJob() {
        Buffer buffer = this.m_publishQueue;
        synchronized (buffer) {
            if (!this.m_publishQueue.isEmpty()) {
                return (CmsPublishJobInfoBean)this.m_publishQueue.get();
            }
            return null;
        }
    }

    public int getLogCount() {
        return this.m_logCount;
    }

    public CmsMemoryStatus getMemoryStatus() {
        this.m_memoryCurrent.update();
        return this.m_memoryCurrent;
    }

    public void initialize(CmsSystemConfiguration configuration) {
        CmsCacheSettings cacheSettings = configuration.getCacheSettings();
        this.m_memoryAverage = new CmsMemoryStatus();
        this.m_memoryCurrent = new CmsMemoryStatus();
        this.m_warningSendSinceLastStatus = false;
        this.m_warningLoggedSinceLastStatus = false;
        this.m_lastEmailWarning = 0L;
        this.m_lastEmailStatus = 0L;
        this.m_lastLogStatus = 0L;
        this.m_lastLogWarning = 0L;
        this.m_lastClearCache = 0L;
        this.m_configuration = configuration.getCmsMemoryMonitorConfiguration();
        this.m_intervalWarning = 43200000;
        this.m_maxUsagePercent = 90;
        this.m_intervalEmail = this.m_configuration.getEmailInterval() * 1000;
        this.m_intervalLog = this.m_configuration.getLogInterval() * 1000;
        if (this.m_configuration.getWarningInterval() > 0) {
            this.m_intervalWarning = this.m_configuration.getWarningInterval();
        }
        this.m_intervalWarning *= 1000;
        if (this.m_configuration.getMaxUsagePercent() > 0) {
            this.m_maxUsagePercent = this.m_configuration.getMaxUsagePercent();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_LOG_1", new Integer(this.m_intervalLog / 1000)));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_EMAIL_1", new Integer(this.m_intervalEmail / 1000)));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_WARNING_1", new Integer(this.m_intervalWarning / 1000)));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_MAX_USAGE_1", new Integer(this.m_maxUsagePercent)));
            if (this.m_configuration.getEmailReceiver() == null || this.m_configuration.getEmailSender() == null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_EMAIL_DISABLED_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_EMAIL_SENDER_1", this.m_configuration.getEmailSender()));
                Iterator<String> i = this.m_configuration.getEmailReceiver().iterator();
                int n = 0;
                while (i.hasNext()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_EMAIL_RECEIVER_2", new Integer(n + 1), i.next()));
                    ++n;
                }
            }
        }
        this.m_cacheXmlTemporaryEntity = CmsMemoryMonitor.createLRUCacheMap(128);
        this.register(CmsXmlEntityResolver.class.getName() + ".xmlEntityTemporaryCache", this.m_cacheXmlTemporaryEntity);
        this.m_cacheXmlPermanentEntity = new ConcurrentHashMap<String, byte[]>(32);
        this.register(CmsXmlEntityResolver.class.getName() + ".xmlEntityPermanentCache", this.m_cacheXmlPermanentEntity);
        this.m_cacheContentDefinitions = CmsMemoryMonitor.createLRUCacheMap(64);
        this.register(CmsXmlEntityResolver.class.getName() + ".contentDefinitionsCache", this.m_cacheContentDefinitions);
        this.m_cacheLock = new ConcurrentHashMap<String, CmsLock>();
        this.register(CmsLockManager.class.getName(), this.m_cacheLock);
        this.m_cacheLocale = new ConcurrentHashMap<String, Locale>();
        this.register(CmsLocaleManager.class.getName(), this.m_cacheLocale);
        this.m_cachePermission = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getPermissionCacheSize());
        this.register(CmsSecurityManager.class.getName(), this.m_cachePermission);
        this.m_cacheUser = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getUserCacheSize());
        this.register(CmsDriverManager.class.getName() + ".userCache", this.m_cacheUser);
        this.m_cacheUserList = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getUserCacheSize());
        this.register(CmsDriverManager.class.getName() + ".userListCache", this.m_cacheUserList);
        this.m_cacheGroup = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getGroupCacheSize());
        this.register(CmsDriverManager.class.getName() + ".groupCache", this.m_cacheGroup);
        this.m_cacheOrgUnit = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getOrgUnitCacheSize());
        this.register(CmsDriverManager.class.getName() + ".orgUnitCache", this.m_cacheOrgUnit);
        this.m_cacheUserGroups = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getUserGroupsCacheSize());
        this.register(CmsDriverManager.class.getName() + ".userGroupsCache", this.m_cacheUserGroups);
        this.m_cacheProject = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getProjectCacheSize());
        this.register(CmsDriverManager.class.getName() + ".projectCache", this.m_cacheProject);
        this.m_cacheProjectResources = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getProjectResourcesCacheSize());
        this.register(CmsDriverManager.class.getName() + ".projectResourcesCache", this.m_cacheProjectResources);
        int size = configuration.getPublishManager().getPublishHistorySize();
        Buffer buffer = CmsPublishHistory.getQueue(size);
        this.m_publishHistory = SynchronizedBuffer.decorate((Buffer)buffer);
        this.register(CmsPublishHistory.class.getName() + ".publishHistory", buffer);
        buffer = CmsPublishQueue.getQueue();
        this.m_publishQueue = SynchronizedBuffer.decorate((Buffer)buffer);
        this.register(CmsPublishQueue.class.getName() + ".publishQueue", buffer);
        this.m_cacheResource = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getResourceCacheSize());
        this.register(CmsDriverManager.class.getName() + ".resourceCache", this.m_cacheResource);
        this.m_cacheHasRoles = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getRolesCacheSize());
        this.register(CmsDriverManager.class.getName() + ".rolesCache", this.m_cacheHasRoles);
        this.m_cacheRoleLists = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getRolesCacheSize());
        this.register(CmsDriverManager.class.getName() + ".roleListsCache", this.m_cacheRoleLists);
        this.m_cacheResourceList = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getResourcelistCacheSize());
        this.register(CmsDriverManager.class.getName() + ".resourceListCache", this.m_cacheResourceList);
        this.m_cacheProperty = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getPropertyCacheSize());
        this.register(CmsDriverManager.class.getName() + ".propertyCache", this.m_cacheProperty);
        this.m_cachePropertyList = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getPropertyListsCacheSize());
        this.register(CmsDriverManager.class.getName() + ".propertyListCache", this.m_cachePropertyList);
        this.m_cachePublishedResources = CmsMemoryMonitor.createLRUCacheMap(5);
        this.register(CmsDriverManager.class.getName() + ".publishedResourcesCache", this.m_cachePublishedResources);
        this.m_cacheAccessControlList = CmsMemoryMonitor.createLRUCacheMap(cacheSettings.getAclCacheSize());
        this.register(CmsDriverManager.class.getName() + ".accessControlListCache", this.m_cacheAccessControlList);
        this.m_cacheVfsObject = new ConcurrentHashMap<String, Object>();
        this.register(CmsVfsMemoryObjectCache.class.getName(), this.m_cacheVfsObject);
        this.m_cacheMemObject = new ConcurrentHashMap<String, Object>();
        this.register(CmsMemoryObjectCache.class.getName(), this.m_cacheMemObject);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MM_CREATED_1", new Date(System.currentTimeMillis())));
        }
    }

    @Deprecated
    public boolean isCacheProperty() {
        return this.isEnabled(CacheType.PROPERTY);
    }

    @Deprecated
    public boolean isCachePropertyList() {
        return this.isEnabled(CacheType.PROPERTY_LIST);
    }

    @Deprecated
    public boolean isCacheResource() {
        return this.isEnabled(CacheType.RESOURCE);
    }

    @Deprecated
    public boolean isCacheResourceList() {
        return this.isEnabled(CacheType.RESOURCE_LIST);
    }

    public boolean isEnabled(CacheType type) {
        return this.m_disabled.get((Object)type) == null;
    }

    public boolean isMonitoring(String key) {
        return this.m_monitoredObjects.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        CmsMemoryMonitor monitor = OpenCms.getMemoryMonitor();
        if (m_currentlyRunning) {
            return null;
        }
        try {
            m_currentlyRunning = true;
            monitor.updateStatus();
            if (monitor.lowMemory()) {
                monitor.monitorWriteLog(true);
                monitor.monitorSendEmail(true);
                monitor.clearCaches();
            }
            if (System.currentTimeMillis() - monitor.m_lastLogStatus > (long)monitor.m_intervalLog) {
                monitor.monitorWriteLog(false);
            }
            if (System.currentTimeMillis() - monitor.m_lastEmailStatus > (long)monitor.m_intervalEmail) {
                monitor.monitorSendEmail(false);
            }
        }
        finally {
            m_currentlyRunning = false;
        }
        return null;
    }

    public boolean lowMemory() {
        return this.m_maxUsagePercent > 0 && this.m_memoryCurrent.getUsage() > (long)this.m_maxUsagePercent;
    }

    public void register(String objectName, Object object) {
        if (this.enabled()) {
            this.m_monitoredObjects.put(objectName, object);
        }
    }

    public boolean requiresPersistency() {
        return true;
    }

    @Deprecated
    public void setCacheProperty(boolean cacheProperty) {
        if (cacheProperty) {
            this.enableCache(CacheType.PROPERTY);
        } else {
            this.disableCache(CacheType.PROPERTY);
        }
    }

    @Deprecated
    public void setCachePropertyList(boolean cachePropertyList) {
        if (cachePropertyList) {
            this.enableCache(CacheType.PROPERTY_LIST);
        } else {
            this.disableCache(CacheType.PROPERTY_LIST);
        }
    }

    @Deprecated
    public void setCacheResource(boolean cacheResource) {
        if (cacheResource) {
            this.enableCache(CacheType.RESOURCE);
        } else {
            this.disableCache(CacheType.RESOURCE);
        }
    }

    @Deprecated
    public void setCacheResourceList(boolean cacheResourceList) {
        if (cacheResourceList) {
            this.enableCache(CacheType.RESOURCE_LIST);
        } else {
            this.disableCache(CacheType.RESOURCE_LIST);
        }
    }

    public void shutdown() throws Exception {
        for (CacheType type : CacheType.values()) {
            this.flushCache(type);
        }
    }

    public void uncacheContentDefinition(String key) {
        this.m_cacheContentDefinitions.remove(key);
    }

    public void uncacheGroup(CmsGroup group) {
        this.m_cacheGroup.remove(group.getId().toString());
        this.m_cacheGroup.remove(group.getName());
    }

    public void uncacheLock(String rootPath) {
        this.m_cacheLock.remove(rootPath);
    }

    public void uncacheOrgUnit(CmsOrganizationalUnit orgUnit) {
        this.m_cacheOrgUnit.remove(orgUnit.getId().toString());
        this.m_cacheOrgUnit.remove(orgUnit.getName());
    }

    public void uncacheProject(CmsProject project) {
        this.m_cacheProject.remove(project.getUuid().toString());
        this.m_cacheProject.remove(project.getName());
    }

    public void uncachePublishJob(CmsPublishJobInfoBean publishJob) {
        this.m_publishQueue.remove((Object)publishJob);
    }

    public void uncachePublishJobInHistory(CmsPublishJobInfoBean publishJob) {
        this.m_publishHistory.remove((Object)publishJob);
    }

    public void uncacheUser(CmsUser user) {
        this.m_cacheUser.remove(user.getId().toString());
        this.m_cacheUser.remove(user.getName());
    }

    public void uncacheVfsObject(String key) {
        this.m_cacheVfsObject.remove(key);
    }

    public void uncacheXmlTemporaryEntity(String key) {
        this.m_cacheXmlTemporaryEntity.remove(key);
    }

    protected void clearCaches() {
        if (this.m_lastClearCache + 600000L > System.currentTimeMillis()) {
            return;
        }
        this.m_lastClearCache = System.currentTimeMillis();
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_CLEAR_CACHE_MEM_CONS_0"));
        }
        OpenCms.fireCmsEvent(new CmsEvent(5, Collections.emptyMap()));
        System.gc();
    }

    protected long getCosts(Object obj) {
        long costs = 0L;
        if (obj instanceof CmsLruCache && (costs = (long)((CmsLruCache)obj).getObjectCosts()) < 0L) {
            costs = 0L;
        }
        return costs;
    }

    protected String getItems(Object obj) {
        if (obj instanceof CmsLruCache) {
            return Integer.toString(((CmsLruCache)obj).size());
        }
        if (obj instanceof Map) {
            return Integer.toString(((Map)obj).size());
        }
        return "-";
    }

    protected long getKeySize(Map<?, ?> map, int depth) {
        long keySize;
        block5: {
            keySize = 0L;
            try {
                for (Object obj : map.values().toArray()) {
                    if (!(obj instanceof Map) || depth >= 5) continue;
                    keySize += this.getKeySize((Map)obj, depth + 1);
                }
                Object[] values = null;
                for (Object obj : map.keySet().toArray()) {
                    if (!(obj instanceof String)) continue;
                    String st = (String)obj;
                    keySize += (long)(st.length() * 2);
                }
            }
            catch (ConcurrentModificationException values) {
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CAUGHT_THROWABLE_1", t.getMessage()));
            }
        }
        return keySize;
    }

    protected long getKeySize(Object obj) {
        if (obj instanceof Map) {
            return this.getKeySize((Map)obj, 1);
        }
        return 0L;
    }

    protected String getLimit(Object obj) {
        if (obj instanceof CmsLruCache) {
            return Long.toString(((CmsLruCache)obj).getMaxCacheCosts());
        }
        if (obj instanceof LRUMap) {
            return Integer.toString(((LRUMap)obj).maxSize());
        }
        return "-";
    }

    protected void monitorSendEmail(boolean warning) {
        CmsSessionManager sm;
        String subject;
        if (this.m_configuration.getEmailSender() == null || this.m_configuration.getEmailReceiver() == null) {
            return;
        }
        if (warning && this.m_warningSendSinceLastStatus && (this.m_intervalEmail > 0 || System.currentTimeMillis() >= this.m_lastEmailWarning + (long)this.m_intervalWarning)) {
            return;
        }
        if (!warning && this.m_intervalEmail <= 0) {
            return;
        }
        String date = CmsDateUtil.getDateTimeShort(System.currentTimeMillis());
        String content = "";
        if (warning) {
            this.m_warningSendSinceLastStatus = true;
            this.m_lastEmailWarning = System.currentTimeMillis();
            subject = "OpenCms Memory W A R N I N G [" + OpenCms.getSystemInfo().getServerName().toUpperCase() + "/" + date + "]";
            content = content + "W A R N I N G !\nOpenCms memory consumption on server " + OpenCms.getSystemInfo().getServerName().toUpperCase() + " has reached a critical level !\n\nThe configured limit is " + this.m_maxUsagePercent + "%\n\n";
        } else {
            this.m_warningSendSinceLastStatus = false;
            this.m_lastEmailStatus = System.currentTimeMillis();
            subject = "OpenCms Memory Status [" + OpenCms.getSystemInfo().getServerName().toUpperCase() + "/" + date + "]";
        }
        content = content + "Memory usage report of OpenCms server " + OpenCms.getSystemInfo().getServerName().toUpperCase() + " at " + date + "\n\nMemory maximum heap size: " + this.m_memoryCurrent.getMaxMemory() + " mb\nMemory current heap size: " + this.m_memoryCurrent.getTotalMemory() + " mb\n\nMemory currently used   : " + this.m_memoryCurrent.getUsedMemory() + " mb (" + this.m_memoryCurrent.getUsage() + "%)\nMemory currently unused : " + this.m_memoryCurrent.getFreeMemory() + " mb\n\n\n";
        if (warning) {
            content = content + "*** Please take action NOW to ensure that no OutOfMemoryException occurs.\n\n\n";
        }
        if ((sm = OpenCms.getSessionManager()) != null) {
            content = content + "Current status of the sessions:\n\n";
            content = content + "Logged in users          : " + sm.getSessionCountAuthenticated() + "\n";
            content = content + "Currently active sessions: " + sm.getSessionCountCurrent() + "\n";
            content = content + "Total created sessions   : " + sm.getSessionCountTotal() + "\n\n\n";
        }
        sm = null;
        content = content + "Current status of the caches:\n\n";
        ArrayList<String> keyList = new ArrayList<String>(this.m_monitoredObjects.keySet());
        Collections.sort(keyList);
        long totalSize = 0L;
        for (String key : keyList) {
            String[] shortKeys = key.split("\\.");
            String shortKey = shortKeys[shortKeys.length - 2] + '.' + shortKeys[shortKeys.length - 1];
            PrintfFormat form = new PrintfFormat("%9s");
            Object obj = this.m_monitoredObjects.get(key);
            long size = this.getKeySize(obj) + CmsMemoryMonitor.getValueSize(obj) + this.getCosts(obj);
            totalSize += size;
            content = content + new PrintfFormat("%-42.42s").sprintf(shortKey) + "  Entries: " + form.sprintf(this.getItems(obj)) + "   Limit: " + form.sprintf(this.getLimit(obj)) + "   Size: " + form.sprintf(Long.toString(size)) + "\n";
        }
        content = content + "\nTotal size of cache memory monitored: " + totalSize + " (" + totalSize / 0x100000L + ")\n\n";
        String from = this.m_configuration.getEmailSender();
        ArrayList<InternetAddress> receivers = new ArrayList<InternetAddress>();
        List<String> receiverEmails = this.m_configuration.getEmailReceiver();
        try {
            if (from != null && receiverEmails != null && !receiverEmails.isEmpty()) {
                Iterator<String> i = receiverEmails.iterator();
                while (i.hasNext()) {
                    receivers.add(new InternetAddress(i.next()));
                }
                CmsSimpleMail email = new CmsSimpleMail();
                email.setFrom(from);
                email.setTo(receivers);
                email.setSubject(subject);
                email.setMsg(content);
                new CmsMailTransport((Email)email).send();
            }
            if (LOG.isInfoEnabled()) {
                if (warning) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_WARNING_EMAIL_SENT_0"));
                } else {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_STATUS_EMAIL_SENT_0"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void monitorWriteLog(boolean warning) {
        if (!LOG.isWarnEnabled()) {
            return;
        }
        if (!warning && !LOG.isInfoEnabled()) {
            return;
        }
        if (warning && this.m_warningLoggedSinceLastStatus && (this.m_intervalLog > 0 || System.currentTimeMillis() >= this.m_lastLogWarning + (long)this.m_intervalWarning)) {
            return;
        }
        if (!warning && this.m_intervalLog <= 0) {
            return;
        }
        if (warning) {
            this.m_lastLogWarning = System.currentTimeMillis();
            this.m_warningLoggedSinceLastStatus = true;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_CONSUME_2", new Long(this.m_memoryCurrent.getUsage()), new Integer(this.m_maxUsagePercent)));
        } else {
            this.m_warningLoggedSinceLastStatus = false;
            this.m_lastLogStatus = System.currentTimeMillis();
        }
        if (warning) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_STATUS_6", new Object[]{new Long(this.m_memoryCurrent.getMaxMemory()), new Long(this.m_memoryCurrent.getTotalMemory()), new Long(this.m_memoryCurrent.getFreeMemory()), new Long(this.m_memoryCurrent.getUsedMemory()), new Long(this.m_memoryCurrent.getUsage()), new Integer(this.m_maxUsagePercent)}));
        } else {
            ++this.m_logCount;
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_LOG_INFO_2", OpenCms.getSystemInfo().getServerName().toUpperCase(), String.valueOf(this.m_logCount)));
            ArrayList<String> keyList = new ArrayList<String>(this.m_monitoredObjects.keySet());
            Collections.sort(keyList);
            long totalSize = 0L;
            for (String key : keyList) {
                Object obj = this.m_monitoredObjects.get(key);
                long size = this.getKeySize(obj) + CmsMemoryMonitor.getValueSize(obj) + this.getCosts(obj);
                totalSize += size;
                PrintfFormat name1 = new PrintfFormat("%-80s");
                PrintfFormat name2 = new PrintfFormat("%-50s");
                PrintfFormat form = new PrintfFormat("%9s");
                LOG.info((Object)Messages.get().getBundle().key("LOG_MM_NOWARN_STATUS_5", new Object[]{name1.sprintf(key), name2.sprintf(obj.getClass().getName()), form.sprintf(this.getItems(obj)), form.sprintf(this.getLimit(obj)), form.sprintf(Long.toString(size))}));
            }
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_STATUS_6", new Object[]{new Long(this.m_memoryCurrent.getMaxMemory()), new Long(this.m_memoryCurrent.getTotalMemory()), new Long(this.m_memoryCurrent.getFreeMemory()), new Long(this.m_memoryCurrent.getUsedMemory()), new Long(this.m_memoryCurrent.getUsage()), new Integer(this.m_maxUsagePercent), new Long(totalSize), new Long(totalSize / 0x100000L)}));
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_STATUS_AVG_6", new Object[]{new Long(this.m_memoryAverage.getMaxMemory()), new Long(this.m_memoryAverage.getTotalMemory()), new Long(this.m_memoryAverage.getFreeMemory()), new Long(this.m_memoryAverage.getUsedMemory()), new Long(this.m_memoryAverage.getUsage()), new Integer(this.m_memoryAverage.getCount())}));
            CmsSessionManager sm = OpenCms.getSessionManager();
            if (sm != null) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_MM_SESSION_STAT_3", String.valueOf(sm.getSessionCountAuthenticated()), String.valueOf(sm.getSessionCountCurrent()), String.valueOf(sm.getSessionCountTotal())));
            }
            sm = null;
            for (String poolname : OpenCms.getSqlManager().getDbPoolUrls()) {
                try {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_CONNECTIONS_3", poolname, Integer.toString(OpenCms.getSqlManager().getActiveConnections(poolname)), Integer.toString(OpenCms.getSqlManager().getIdleConnections(poolname))));
                }
                catch (Exception exc) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_CONNECTIONS_3", poolname, Integer.toString(-1), Integer.toString(-1)));
                }
            }
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_STARTUP_TIME_2", CmsDateUtil.getDateTimeShort(OpenCms.getSystemInfo().getStartupTime()), CmsStringUtil.formatRuntime(OpenCms.getSystemInfo().getRuntime())));
        }
    }

    protected void updateStatus() {
        this.m_memoryCurrent.update();
        this.m_memoryAverage.calculateAverage(this.m_memoryCurrent);
    }

    public static enum CacheType {
        ACL,
        CONTENT_DEFINITION,
        GROUP,
        HAS_ROLE,
        LOCALE,
        LOCK,
        MEMORY_OBJECT,
        ORG_UNIT,
        PERMISSION,
        PROJECT,
        PROJECT_RESOURCES,
        PROPERTY,
        PROPERTY_LIST,
        PUBLISH_HISTORY,
        PUBLISH_QUEUE,
        PUBLISHED_RESOURCES,
        RESOURCE,
        RESOURCE_LIST,
        ROLE_LIST,
        USER,
        USER_LIST,
        USERGROUPS,
        VFS_OBJECT,
        XML_ENTITY_PERM,
        XML_ENTITY_TEMP;

    }
}

