/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.notification.A_CmsNotification;
import org.opencms.notification.CmsExtendedNotificationCause;
import org.opencms.notification.Messages;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;

public class CmsContentNotification
extends A_CmsNotification {
    public static final String NOTIFICATION_CONTENT = "notification/notification";
    private static final Log LOG = CmsLog.getLog(CmsContentNotification.class);
    private CmsMessages m_messages;
    private List<CmsExtendedNotificationCause> m_notificationCauses;
    private CmsUser m_responsible;
    private String m_serverAndContext = OpenCms.getSiteManager().getWorkplaceServer() + OpenCms.getSystemInfo().getOpenCmsContext();
    private String m_uriWorkplace = this.m_serverAndContext + "/system/workplace/";
    private String m_uriWorkplaceJsp = this.m_serverAndContext + "/system/workplace/views/workplace.jsp";

    CmsContentNotification(CmsUser responsible, CmsObject cms) {
        super(cms, responsible);
        this.m_responsible = responsible;
    }

    public static boolean existsEditor(CmsResource resource) {
        int plainId;
        try {
            plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        }
        catch (CmsLoaderException e) {
            plainId = CmsResourceTypePlain.getStaticTypeId();
        }
        return CmsResourceTypeJsp.isJsp(resource) || resource.getTypeId() == plainId || CmsResourceTypeXmlPage.isXmlPage(resource);
    }

    public CmsUser getResponsible() {
        return this.m_responsible;
    }

    @Override
    protected String generateHtmlMsg() {
        this.m_messages = Messages.get().getBundle(this.getLocale());
        StringBuffer htmlMsg = new StringBuffer();
        htmlMsg.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">");
        htmlMsg.append("<tr><td colspan=\"5\"><br/>");
        GregorianCalendar tomorrow = new GregorianCalendar(TimeZone.getDefault(), CmsLocaleManager.getDefaultLocale());
        tomorrow.add(6, 1);
        ArrayList<CmsExtendedNotificationCause> outdatedResources = new ArrayList<CmsExtendedNotificationCause>();
        ArrayList<CmsExtendedNotificationCause> resourcesNextDay = new ArrayList<CmsExtendedNotificationCause>();
        ArrayList<CmsExtendedNotificationCause> resourcesNextWeek = new ArrayList<CmsExtendedNotificationCause>();
        for (CmsExtendedNotificationCause notificationCause : this.m_notificationCauses) {
            if (notificationCause.getCause() == 1) {
                outdatedResources.add(notificationCause);
                continue;
            }
            if (notificationCause.getDate().before(tomorrow.getTime())) {
                resourcesNextDay.add(notificationCause);
                continue;
            }
            resourcesNextWeek.add(notificationCause);
        }
        Collections.sort(resourcesNextDay);
        Collections.sort(resourcesNextWeek);
        Collections.sort(outdatedResources);
        this.appendResourceList(htmlMsg, resourcesNextDay, this.m_messages.key("GUI_WITHIN_NEXT_DAY_0"));
        this.appendResourceList(htmlMsg, resourcesNextWeek, this.m_messages.key("GUI_WITHIN_NEXT_WEEK_0"));
        this.appendResourceList(htmlMsg, outdatedResources, this.m_messages.key("GUI_FILES_NOT_UPDATED_1", String.valueOf(OpenCms.getSystemInfo().getNotificationTime())));
        htmlMsg.append("</td></tr></table>");
        String result = htmlMsg.toString();
        return result;
    }

    protected List<CmsExtendedNotificationCause> getNotificationCauses() {
        return this.m_notificationCauses;
    }

    @Override
    protected String getNotificationContent() {
        return OpenCms.getSystemInfo().getConfigFilePath(this.m_cms, NOTIFICATION_CONTENT);
    }

    protected void setNotificationCauses(List<CmsExtendedNotificationCause> resources) {
        this.m_notificationCauses = resources;
    }

    private void appendConfirmLink(StringBuffer buf, CmsExtendedNotificationCause notificationCause) {
        block2: {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            buf.append("<td>");
            try {
                String resourcePath = notificationCause.getResource().getRootPath();
                String siteRoot = OpenCms.getSiteManager().getSiteRoot(resourcePath);
                resourcePath = resourcePath.substring(siteRoot.length());
                buf.append("[<a href=\"");
                StringBuffer wpStartUri = new StringBuffer(this.m_uriWorkplace);
                wpStartUri.append("commons/confirm_content_notification.jsp?userId=");
                wpStartUri.append(this.m_responsible.getId());
                wpStartUri.append("&cause=");
                wpStartUri.append(notificationCause.getCause());
                wpStartUri.append("&resource=");
                wpStartUri.append(resourcePath);
                params.put("wpStart", new String[]{wpStartUri.toString()});
                params.put("wpExplorerResource", new String[]{CmsResource.getParentFolder(resourcePath)});
                params.put("wpSite", new String[]{siteRoot});
                CmsUUID projectId = this.getCmsObject().readProject(OpenCms.getSystemInfo().getNotificationProject()).getUuid();
                params.put("wpProject", new String[]{String.valueOf(projectId)});
                buf.append(CmsRequestUtil.appendParameters(this.m_uriWorkplaceJsp, params, true));
                buf.append("\">");
                buf.append(this.m_messages.key("GUI_CONFIRM_0"));
                buf.append("</a>]");
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)e);
            }
        }
        buf.append("</td>");
    }

    private void appendEditLink(StringBuffer buf, CmsExtendedNotificationCause notificationCause) {
        block3: {
            buf.append("<td>");
            if (CmsContentNotification.existsEditor(notificationCause.getResource())) {
                try {
                    String resourcePath = notificationCause.getResource().getRootPath();
                    String siteRoot = OpenCms.getSiteManager().getSiteRoot(resourcePath);
                    resourcePath = resourcePath.substring(siteRoot.length());
                    HashMap<String, String[]> params = new HashMap<String, String[]>();
                    CmsUUID projectId = this.getCmsObject().readProject(OpenCms.getSystemInfo().getNotificationProject()).getUuid();
                    params.put("wpProject", new String[]{String.valueOf(projectId)});
                    params.put("wpExplorerResource", new String[]{CmsResource.getParentFolder(resourcePath)});
                    params.put("wpSite", new String[]{siteRoot});
                    params.put("resource", new String[]{resourcePath});
                    buf.append("[<a href=\"");
                    buf.append(CmsRequestUtil.appendParameters(this.m_uriWorkplace + "editors/editor.jsp", params, false));
                    buf.append("\">");
                    buf.append(this.m_messages.key("GUI_EDIT_0"));
                    buf.append("</a>]");
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)e);
                }
            }
        }
        buf.append("</td>");
    }

    private void appendModifyLink(StringBuffer buf, CmsExtendedNotificationCause notificationCause) {
        block2: {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            buf.append("<td>");
            try {
                buf.append("[<a href=\"");
                String resourcePath = notificationCause.getResource().getRootPath();
                String siteRoot = OpenCms.getSiteManager().getSiteRoot(resourcePath);
                resourcePath = resourcePath.substring(siteRoot.length());
                StringBuffer wpStartUri = new StringBuffer(this.m_uriWorkplace);
                wpStartUri.append("commons/availability.jsp?resource=");
                wpStartUri.append(resourcePath);
                params.put("wpExplorerResource", new String[]{CmsResource.getParentFolder(resourcePath)});
                params.put("wpStart", new String[]{wpStartUri.toString()});
                params.put("wpSite", new String[]{siteRoot});
                CmsUUID projectId = this.getCmsObject().readProject(OpenCms.getSystemInfo().getNotificationProject()).getUuid();
                params.put("wpProject", new String[]{String.valueOf(projectId)});
                buf.append(CmsRequestUtil.appendParameters(this.m_uriWorkplaceJsp, params, true));
                buf.append("\">");
                buf.append(this.m_messages.key("GUI_MODIFY_0"));
                buf.append("</a>]");
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)e);
            }
        }
        buf.append("</td>");
    }

    private void appendResourceList(StringBuffer htmlMsg, List<CmsExtendedNotificationCause> notificationCauseList, String header) {
        if (!notificationCauseList.isEmpty()) {
            htmlMsg.append("<tr><td colspan=\"5\"><br/><p style=\"margin-top:20px;margin-bottom:10px;\"><b>");
            htmlMsg.append(header);
            htmlMsg.append("</b></p></td></tr><tr class=\"trow1\"><td><div style=\"padding-top:2px;padding-bottom:2px;\">");
            htmlMsg.append(this.m_messages.key("GUI_RESOURCE_0"));
            htmlMsg.append("</div></td><td><div style=\"padding-top:2px;padding-bottom:2px;padding-left:10px;\">");
            htmlMsg.append(this.m_messages.key("GUI_SITE_0"));
            htmlMsg.append("</div></td><td><div style=\"padding-top:2px;padding-bottom:2px;padding-left:10px;\">");
            htmlMsg.append(this.m_messages.key("GUI_ISSUE_0"));
            htmlMsg.append("</div></td><td colspan=\"2\"/></tr>");
            Iterator<CmsExtendedNotificationCause> notificationCauses = notificationCauseList.iterator();
            int i = 0;
            while (notificationCauses.hasNext()) {
                CmsExtendedNotificationCause notificationCause = notificationCauses.next();
                htmlMsg.append(this.buildNotificationListItem(notificationCause, i % 2 + 2));
                ++i;
            }
        }
    }

    private String buildNotificationListItem(CmsExtendedNotificationCause notificationCause, int row) {
        StringBuffer result = new StringBuffer("<tr class=\"trow");
        result.append(row);
        result.append("\"><td width=\"100%\">");
        String resourcePath = notificationCause.getResource().getRootPath();
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(resourcePath);
        resourcePath = resourcePath.substring(siteRoot.length());
        if (notificationCause.getResource().getDateReleased() < System.currentTimeMillis() && notificationCause.getResource().getDateExpired() > System.currentTimeMillis()) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("wpSite", new String[]{siteRoot});
            params.put("resource", new String[]{resourcePath});
            result.append("<a href=\"");
            result.append(CmsRequestUtil.appendParameters(this.m_uriWorkplace + "commons/displayresource.jsp", params, false));
            result.append("\">");
            result.append(resourcePath);
            result.append("</a>");
        } else {
            result.append(resourcePath);
        }
        result.append("</td><td><div style=\"white-space:nowrap;padding-left:10px;padding-right:10px;\">");
        result.append(siteRoot);
        result.append("</td><td><div style=\"white-space:nowrap;padding-left:10px;padding-right:10px;\">");
        if (notificationCause.getCause() == 0) {
            result.append(this.m_messages.key("GUI_EXPIRES_AT_1", new Object[]{notificationCause.getDate()}));
            result.append("</div></td>");
            this.appendConfirmLink(result, notificationCause);
            this.appendModifyLink(result, notificationCause);
        } else if (notificationCause.getCause() == 3) {
            result.append(this.m_messages.key("GUI_RELEASE_AT_1", new Object[]{notificationCause.getDate()}));
            result.append("</div></td>");
            this.appendConfirmLink(result, notificationCause);
            this.appendModifyLink(result, notificationCause);
        } else if (notificationCause.getCause() == 2) {
            result.append(this.m_messages.key("GUI_UPDATE_REQUIRED_1", new Object[]{notificationCause.getDate()}));
            result.append("</div></td>");
            this.appendConfirmLink(result, notificationCause);
            this.appendEditLink(result, notificationCause);
        } else {
            result.append(this.m_messages.key("GUI_UNCHANGED_SINCE_1", new Object[]{new Integer(CmsDateUtil.getDaysPassedSince(notificationCause.getDate()))}));
            result.append("</div></td>");
            this.appendConfirmLink(result, notificationCause);
            this.appendEditLink(result, notificationCause);
        }
        result.append("</tr>");
        return result.toString();
    }
}

