/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.Messages;
import org.opencms.util.CmsUUID;

public class CmsInternalLinksValidator {
    private static final Log LOG = CmsLog.getLog(CmsInternalLinksValidator.class);
    protected Map<String, List<CmsRelation>> m_brokenRelations;
    private CmsObject m_cms;
    private int m_notVisibleResourcesCount;
    private List<CmsResource> m_resourcesWithBrokenLinks;

    public CmsInternalLinksValidator(CmsObject cms, List<String> resourceNames) {
        this.m_cms = cms;
        this.m_brokenRelations = this.getBrokenRelations(resourceNames);
    }

    public List<CmsRelation> getBrokenLinksForResource(String resourceName) {
        return this.m_brokenRelations.get(resourceName);
    }

    public int getNotVisibleResourcesCount() {
        if (this.m_resourcesWithBrokenLinks == null) {
            this.getResourcesWithBrokenLinks();
        }
        return this.m_notVisibleResourcesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getResourcesWithBrokenLinks() {
        if (this.m_resourcesWithBrokenLinks == null) {
            ArrayList<String> resources = new ArrayList<String>(this.m_brokenRelations.keySet());
            Collections.sort(resources);
            this.m_resourcesWithBrokenLinks = new ArrayList<CmsResource>(resources.size());
            this.m_notVisibleResourcesCount = 0;
            CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireVisible();
            String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
            try {
                this.m_cms.getRequestContext().setSiteRoot("/");
                for (String resourceName : resources) {
                    try {
                        this.m_resourcesWithBrokenLinks.add(this.m_cms.readResource(resourceName, filter));
                    }
                    catch (Exception e) {
                        ++this.m_notVisibleResourcesCount;
                    }
                }
            }
            finally {
                this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return this.m_resourcesWithBrokenLinks;
    }

    public boolean isEmpty() {
        return this.m_brokenRelations.isEmpty();
    }

    private Map<String, List<CmsRelation>> getBrokenRelations(List<String> resourceNames) {
        HashMap<String, List<CmsRelation>> brokenRelations = new HashMap<String, List<CmsRelation>>();
        CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterIncludeChildren().filterStructureId(CmsUUID.getNullUUID());
        for (String folderName : resourceNames) {
            List<CmsRelation> relations;
            try {
                relations = this.m_cms.getRelationsForResource(folderName, filter);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_LINK_SEARCH_1", folderName), (Throwable)e);
                continue;
            }
            for (CmsRelation relation : relations) {
                String resourceName = relation.getSourcePath();
                ArrayList<CmsRelation> broken = (ArrayList<CmsRelation>)brokenRelations.get(resourceName);
                if (broken == null) {
                    broken = new ArrayList<CmsRelation>();
                    brokenRelations.put(resourceName, broken);
                }
                broken.add(relation);
            }
        }
        return brokenRelations;
    }
}

