/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.report.CmsReportUpdateItem;
import org.opencms.report.I_CmsReportUpdateFormatter;
import org.opencms.util.CmsStringUtil;

public class CmsVaadinHtmlReportUpdateFormatter
implements I_CmsReportUpdateFormatter {
    private static final Log LOG = CmsLog.getLog(CmsVaadinHtmlReportUpdateFormatter.class);
    private StringTemplateGroup m_templateGroup;

    public CmsVaadinHtmlReportUpdateFormatter() {
        try (InputStream stream = CmsVaadinHtmlReportUpdateFormatter.class.getResourceAsStream("report.st");){
            this.m_templateGroup = CmsStringUtil.readStringTemplateGroup(stream);
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public String formatReportUpdate(List<CmsReportUpdateItem> updateItem) {
        StringBuffer buffer = new StringBuffer();
        for (CmsReportUpdateItem entry : updateItem) {
            try {
                boolean needsParam;
                StringTemplate template = this.m_templateGroup.getInstanceOf(entry.getType().getFormatName());
                boolean bl = needsParam = template.getFormalArguments().get("message") != null;
                if (needsParam) {
                    template.setAttribute("message", entry.getMessage());
                }
                buffer.append(template.toString());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return buffer.toString();
    }
}

