/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.file.wrapper.I_CmsResourceWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.A_CmsRepository;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.repository.CmsRepositorySession;
import org.opencms.repository.I_CmsRepositorySession;
import org.opencms.workplace.CmsWorkplace;

public class CmsRepository
extends A_CmsRepository {
    private static final Log LOG = CmsLog.getLog(CmsRepository.class);
    private static final String PARAM_WRAPPER = "wrapper";
    private List<I_CmsResourceWrapper> m_wrappers = new ArrayList<I_CmsResourceWrapper>();

    @Override
    public void initConfiguration() throws CmsConfigurationException {
        CmsParameterConfiguration config = this.getConfiguration();
        List<I_CmsResourceWrapper> wrapperObjects = CmsRepositoryManager.createResourceWrappersFromConfiguration(config, PARAM_WRAPPER, LOG);
        this.m_wrappers = Collections.unmodifiableList(wrapperObjects);
        super.initConfiguration();
    }

    @Override
    public void initializeCms(CmsObject cms) {
    }

    @Override
    public I_CmsRepositorySession login(String userName, String password) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        cms.loginUser(userName, password);
        CmsUserSettings settings = new CmsUserSettings(cms);
        cms.getRequestContext().setSiteRoot(CmsWorkplace.getStartSiteRoot(cms, settings));
        cms.getRequestContext().setCurrentProject(cms.readProject(settings.getStartProject()));
        CmsObjectWrapper objWrapper = new CmsObjectWrapper(cms, this.m_wrappers);
        cms.getRequestContext().setAttribute("org.opencms.file.wrapper.CmsObjectWrapper", objWrapper);
        return new CmsRepositorySession(objWrapper, this.getFilter());
    }
}

