/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.rmi;

import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.main.CmsLog;
import org.opencms.main.Messages;
import org.opencms.rmi.CmsRemoteShell;
import org.opencms.rmi.CmsRemoteShellProvider;
import org.opencms.rmi.I_CmsRemoteShellProvider;

public class CmsRemoteShellServer {
    private static final Log LOG = CmsLog.getLog(CmsRemoteShellServer.class);
    private static boolean m_initialized;
    private int m_port = 1101;
    private I_CmsRemoteShellProvider m_provider;
    private Registry m_registry;

    public CmsRemoteShellServer(int port) {
        this.m_port = port;
    }

    public static CmsRemoteShellServer initialize(CmsSystemConfiguration systemConfiguration) {
        CmsRemoteShellServer result = null;
        if (systemConfiguration.getShellServerOptions() != null && systemConfiguration.getShellServerOptions().isEnabled()) {
            result = new CmsRemoteShellServer(systemConfiguration.getShellServerOptions().getPort());
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REMOTESHELL_ENABLED_1", new Integer(result.m_port)));
            }
            result.initServer();
        } else if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REMOTESHELL_DISABLED_0"));
        }
        return result;
    }

    public void initServer() {
        if (m_initialized) {
            return;
        }
        try {
            this.m_registry = LocateRegistry.createRegistry(this.m_port);
            this.m_provider = new CmsRemoteShellProvider(this.m_port);
            I_CmsRemoteShellProvider providerStub = (I_CmsRemoteShellProvider)UnicastRemoteObject.exportObject((Remote)this.m_provider, this.m_port);
            this.m_registry.bind("RemoteShellProvider", providerStub);
            m_initialized = true;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void shutDown() throws Exception {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
        for (String boundName : this.m_registry.list()) {
            this.m_registry.unbind(boundName);
        }
        UnicastRemoteObject.unexportObject(this.m_registry, true);
        UnicastRemoteObject.unexportObject(this.m_provider, true);
        CmsRemoteShell.unregisterAll();
    }
}

