/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.scheduler.CmsSchedulerException;
import org.opencms.scheduler.CmsSchedulerThreadPool;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.scheduler.Messages;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;

public class CmsScheduleManager
implements Job {
    public static final String SCHEDULER_JOB_INFO = "org.opencms.scheduler.CmsScheduledJobInfo";
    private static final Log LOG = CmsLog.getLog(CmsScheduleManager.class);
    private CmsObject m_adminCms;
    private List<CmsScheduledJobInfo> m_configuredJobs;
    private List<CmsScheduledJobInfo> m_jobs;
    private Scheduler m_scheduler;

    public CmsScheduleManager() {
    }

    public CmsScheduleManager(List<CmsScheduledJobInfo> configuredJobs) {
        this.m_configuredJobs = configuredJobs;
        int size = 0;
        if (this.m_configuredJobs != null) {
            size = this.m_configuredJobs.size();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SCHEDULER_CREATED_1", new Integer(size)));
        }
    }

    public void execute(JobExecutionContext context) {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        CmsScheduledJobInfo jobInfo = (CmsScheduledJobInfo)jobData.get((Object)SCHEDULER_JOB_INFO);
        if (jobInfo == null) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_JOB_1", ((JobDetailImpl)context.getJobDetail()).getFullName()));
            return;
        }
        jobInfo.setPreviousFireTime(context.getFireTime());
        jobInfo.setNextFireTime(context.getNextFireTime());
        this.executeJob(jobInfo);
    }

    public void executeDirectly(String jobId) {
        final CmsScheduledJobInfo jobInfo = this.getJob(jobId).clone();
        if (jobInfo == null) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_JOB_1", "null"));
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                CmsScheduleManager.this.executeJob(jobInfo);
            }
        };
        thread.start();
    }

    public CmsScheduledJobInfo getJob(String id) {
        for (CmsScheduledJobInfo job : this.m_jobs) {
            if (!job.getId().equals(id)) continue;
            return job;
        }
        return null;
    }

    public List<CmsScheduledJobInfo> getJobs() {
        return Collections.unmodifiableList(this.m_jobs);
    }

    public synchronized void initialize(CmsObject adminCms) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(adminCms, CmsRole.WORKPLACE_MANAGER);
        }
        this.m_jobs = new ArrayList<CmsScheduledJobInfo>();
        this.m_adminCms = adminCms;
        Properties properties = new Properties();
        properties.put("org.quartz.scheduler.instanceName", "OpenCmsScheduler");
        properties.put("org.quartz.scheduler.threadName", "OpenCms: Scheduler");
        properties.put("org.quartz.scheduler.rmi.export", CmsStringUtil.FALSE);
        properties.put("org.quartz.scheduler.rmi.proxy", CmsStringUtil.FALSE);
        properties.put("org.quartz.threadPool.class", CmsSchedulerThreadPool.class.getName());
        properties.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        properties.put("org.quartz.scheduler.jmx.export", CmsStringUtil.FALSE);
        properties.put("org.quartz.scheduler.jmx.proxy", CmsStringUtil.FALSE);
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
            this.m_scheduler = schedulerFactory.getScheduler();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NO_SCHEDULER_0"), (Throwable)e);
            this.m_scheduler = null;
            return;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SCHEDULER_INITIALIZED_0"));
        }
        if (this.m_configuredJobs != null) {
            for (int i = 0; i < this.m_configuredJobs.size(); ++i) {
                try {
                    CmsScheduledJobInfo job = this.m_configuredJobs.get(i);
                    this.scheduleJob(adminCms, job);
                    continue;
                }
                catch (CmsSchedulerException cmsSchedulerException) {
                    // empty catch block
                }
            }
        }
        try {
            this.m_scheduler.start();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CANNOT_START_SCHEDULER_0"), (Throwable)e);
            this.m_scheduler = null;
            return;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SCHEDULER_STARTED_0"));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SCHEDULER_CONFIG_FINISHED_0"));
        }
    }

    public synchronized void scheduleJob(CmsObject cms, CmsScheduledJobInfo jobInfo) throws CmsRoleViolationException, CmsSchedulerException {
        Trigger trigger;
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_MANAGER);
        }
        if (jobInfo == null || jobInfo.getClassName() == null) {
            CmsMessageContainer message = Messages.get().container("ERR_INVALID_JOB_CONFIGURATION_0");
            LOG.error((Object)message.key());
            throw new CmsSchedulerException(message);
        }
        if (this.m_scheduler == null) {
            CmsMessageContainer message = Messages.get().container("ERR_NO_SCHEDULER_1", jobInfo.getJobName());
            LOG.error((Object)message.key());
            throw new CmsSchedulerException(message);
        }
        try {
            Class<?> jobClass = Class.forName(jobInfo.getClassName());
            if (!I_CmsScheduledJob.class.isAssignableFrom(jobClass)) {
                CmsMessageContainer message = Messages.get().container("ERR_JOB_CLASS_BAD_INTERFACE_2", jobInfo.getClassName(), I_CmsScheduledJob.class.getName());
                LOG.error((Object)message.key());
                if (OpenCms.getRunLevel() > 2) {
                    throw new CmsIllegalArgumentException(message);
                }
                jobInfo.setActive(false);
            }
        }
        catch (ClassNotFoundException e) {
            CmsMessageContainer message = Messages.get().container("ERR_JOB_CLASS_NOT_FOUND_1", jobInfo.getClassName());
            LOG.error((Object)message.key());
            if (OpenCms.getRunLevel() > 2) {
                throw new CmsIllegalArgumentException(message);
            }
            jobInfo.setActive(false);
        }
        String jobId = jobInfo.getId();
        boolean idCreated = false;
        if (jobId == null) {
            CmsUUID jobUUID = new CmsUUID();
            jobId = "OpenCmsJob_".concat(jobUUID.toString());
            jobInfo.setId(jobId);
            idCreated = true;
        }
        try {
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)jobInfo.getCronExpression());
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withSchedule((ScheduleBuilder)scheduleBuilder);
            triggerBuilder.withIdentity(jobId, "DEFAULT");
            trigger = triggerBuilder.build();
        }
        catch (Exception e) {
            if (idCreated) {
                jobInfo.setId(null);
            }
            CmsMessageContainer message = Messages.get().container("ERR_BAD_CRON_EXPRESSION_2", jobInfo.getJobName(), jobInfo.getCronExpression());
            LOG.error((Object)message.key());
            throw new CmsSchedulerException(message);
        }
        CmsScheduledJobInfo oldJob = null;
        if (!idCreated) {
            oldJob = this.unscheduleJob(cms, jobId);
            if (oldJob == null) {
                CmsMessageContainer message = Messages.get().container("ERR_JOB_WITH_ID_DOES_NOT_EXIST_1", jobId);
                LOG.warn((Object)message.key());
                throw new CmsSchedulerException(message);
            }
            jobInfo.setFrozen(false);
        }
        if (jobInfo.isActive()) {
            JobDetailImpl jobDetail = (JobDetailImpl)JobBuilder.newJob(CmsScheduleManager.class).build();
            jobDetail.setName(jobInfo.getId());
            jobDetail.setGroup("DEFAULT");
            jobInfo.setTrigger(trigger);
            JobDataMap jobData = new JobDataMap();
            jobData.put(SCHEDULER_JOB_INFO, (Object)jobInfo);
            jobDetail.setJobDataMap(jobData);
            try {
                this.m_scheduler.scheduleJob((JobDetail)jobDetail, trigger);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_JOB_SCHEDULED_4", new Object[]{new Integer(this.m_jobs.size()), jobInfo.getJobName(), jobInfo.getClassName(), jobInfo.getContextInfo().getUserName()}));
                    Date nextExecution = jobInfo.getExecutionTimeNext();
                    if (nextExecution != null) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_JOB_NEXT_EXECUTION_2", jobInfo.getJobName(), nextExecution));
                    }
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
                if (idCreated) {
                    jobInfo.setId(null);
                }
                CmsMessageContainer message = Messages.get().container("ERR_COULD_NOT_SCHEDULE_JOB_2", jobInfo.getJobName(), jobInfo.getClassName());
                if (oldJob != null) {
                    jobDetail = (JobDetailImpl)JobBuilder.newJob(CmsScheduleManager.class).build();
                    jobDetail.setName(oldJob.getId());
                    jobDetail.setGroup("DEFAULT");
                    jobDetail.setJobDataMap(jobData);
                    try {
                        this.m_scheduler.scheduleJob((JobDetail)jobDetail, oldJob.getTrigger());
                        this.m_jobs.add(oldJob);
                    }
                    catch (SchedulerException e2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e2.getMessage(), (Throwable)e2);
                        }
                        message = Messages.get().container("ERR_COULD_NOT_RESCHEDULE_JOB_2", jobInfo.getJobName(), jobInfo.getClassName());
                    }
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)message.key());
                }
                throw new CmsSchedulerException(message);
            }
        }
        jobInfo.initConfiguration();
        this.m_jobs.add(jobInfo);
    }

    public synchronized void shutDown() {
        this.m_adminCms = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
        if (this.m_scheduler != null) {
            try {
                this.m_scheduler.shutdown();
            }
            catch (SchedulerException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_SHUTDOWN_ERROR_0"));
            }
        }
        this.m_scheduler = null;
    }

    public synchronized CmsScheduledJobInfo unscheduleJob(CmsObject cms, String jobId) throws CmsRoleViolationException {
        CmsScheduledJobInfo jobInfo;
        block8: {
            if (OpenCms.getRunLevel() > 1) {
                OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_MANAGER);
            }
            jobInfo = null;
            if (this.m_jobs.size() > 0) {
                for (int i = this.m_jobs.size() - 1; i >= 0; --i) {
                    CmsScheduledJobInfo job = this.m_jobs.get(i);
                    if (!jobId.equals(job.getId())) continue;
                    this.m_jobs.remove(i);
                    if (jobInfo != null) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_MULTIPLE_JOBS_FOUND_1", jobId));
                    }
                    jobInfo = job;
                }
            }
            if (jobInfo != null && jobInfo.isActive()) {
                try {
                    this.m_scheduler.unscheduleJob(new TriggerKey(jobId, "DEFAULT"));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_UNSCHEDULED_JOB_1", jobId));
                    }
                }
                catch (SchedulerException e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_UNSCHEDULING_ERROR_1", jobId));
                }
            }
        }
        return jobInfo;
    }

    protected void executeJob(CmsScheduledJobInfo jobInfo) {
        I_CmsScheduledJob job;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_JOB_STARTING_1", jobInfo.getJobName()));
        }
        if ((job = jobInfo.getJobInstance()) != null) {
            try {
                String result;
                CmsObject cms = null;
                jobInfo.updateContextRequestTime();
                if (OpenCms.getRunLevel() >= 3) {
                    cms = OpenCms.initCmsObject(OpenCms.getScheduleManager().getAdminCms(), jobInfo.getContextInfo());
                }
                if (CmsStringUtil.isNotEmpty(result = job.launch(cms, jobInfo.getParameters())) && LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_JOB_EXECUTION_OK_2", jobInfo.getJobName(), result));
                }
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_JOB_EXECUTION_ERROR_1", jobInfo.getJobName()), t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_JOB_EXECUTED_1", jobInfo.getJobName()));
            Date nextExecution = jobInfo.getExecutionTimeNext();
            if (nextExecution != null) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_JOB_NEXT_EXECUTION_2", jobInfo.getJobName(), nextExecution));
            }
        }
    }

    private synchronized CmsObject getAdminCms() {
        return this.m_adminCms;
    }
}

