/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.htmlparser.util.ParserException;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.Messages;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.util.CmsHtmlExtractor;
import org.opencms.util.CmsStringUtil;

public final class CmsSearchUtil {
    private static final DateFormat DATEFORMAT_ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Log LOG = CmsLog.getLog(CmsSearchUtil.class);
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final Collection<String> DEFAULT_HTTP_CLIENT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");
    public static final Collection<String> DEFAULT_DATE_FORMATS = new ArrayList<String>();
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;

    private CmsSearchUtil() {
    }

    public static List<String> computeScopeFolders(CmsObject cms, CmsGallerySearchParameters params) {
        String subsite = null;
        if (params.getReferencePath() != null) {
            subsite = OpenCms.getADEManager().getSubSiteRoot(cms, cms.getRequestContext().addSiteRoot(params.getReferencePath()));
            if (subsite != null) {
                subsite = cms.getRequestContext().removeSiteRoot(subsite);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_GALLERIES_COULD_NOT_EVALUATE_SUBSITE_1", params.getReferencePath()));
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_GALLERIES_NO_REFERENCE_PATH_PROVIDED_0"));
        }
        List<String> scopeFolders = CmsSearchUtil.getSearchRootsForScope(params.getScope(), cms.getRequestContext().getSiteRoot(), subsite);
        return scopeFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateAsIso8601(Date date) {
        Class<CmsSearchUtil> clazz = CmsSearchUtil.class;
        synchronized (CmsSearchUtil.class) {
            if (DATEFORMAT_ISO_8601.getTimeZone() != TIMEZONE_UTC) {
                DATEFORMAT_ISO_8601.setTimeZone(TIMEZONE_UTC);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DATEFORMAT_ISO_8601.format(date);
        }
    }

    public static String getDateAsIso8601(long date) {
        if (date > Long.MIN_VALUE && date < Long.MAX_VALUE) {
            Date d_date = new Date(date);
            return CmsSearchUtil.getDateAsIso8601(d_date);
        }
        return null;
    }

    public static String getDateCreatedTimeRangeFilterQuery(String searchField, long startTime, long endTime) {
        String sStartTime = null;
        String sEndTime = null;
        if (startTime > Long.MIN_VALUE && startTime < Long.MAX_VALUE) {
            sStartTime = CmsSearchUtil.getDateAsIso8601(new Date(startTime));
        }
        if (endTime > Long.MIN_VALUE && endTime < Long.MAX_VALUE) {
            sEndTime = CmsSearchUtil.getDateAsIso8601(new Date(endTime));
        }
        String rangeString = CmsSearchUtil.getSolrRangeString(sStartTime, sEndTime);
        return String.format("%s:%s", searchField, rangeString);
    }

    public static List<String> getSearchRootsForScope(CmsGallerySearchScope scope, String siteParam, String subSiteParam) {
        ArrayList<String> result = new ArrayList<String>();
        if (scope == CmsGallerySearchScope.everything) {
            result.add("/");
            return result;
        }
        if (scope.isIncludeSite()) {
            result.add(siteParam);
        }
        if (scope.isIncludeSubSite()) {
            if (subSiteParam == null) {
                result.add(siteParam);
            } else {
                result.add(CmsStringUtil.joinPaths(siteParam, subSiteParam));
            }
        }
        if (scope.isIncludeShared()) {
            String sharedFolder = OpenCms.getSiteManager().getSharedFolder();
            if (sharedFolder != null) {
                result.add(sharedFolder);
            }
            result.add("/system/shared/");
        }
        return result;
    }

    public static String getSolrRangeString(String from, String to) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(from)) {
            from = "*";
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(to)) {
            to = "*";
        }
        return String.format("[%s TO %s]", from, to);
    }

    public static Date parseDate(String d) throws ParseException {
        return CmsSearchUtil.parseDate(d, DEFAULT_DATE_FORMATS);
    }

    public static Date parseDate(String d, Collection<String> fmts) throws ParseException {
        if (d.endsWith("Z") && d.length() > 20) {
            return DATEFORMAT_ISO_8601.parse(d);
        }
        return CmsSearchUtil.parseDate(d, fmts, null);
    }

    public static Date parseDate(String dateValue, Collection<String> dateFormats, Date startDate) throws ParseException {
        if (dateValue == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (dateFormats == null) {
            dateFormats = DEFAULT_HTTP_CLIENT_PATTERNS;
        }
        if (startDate == null) {
            startDate = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        for (String format : dateFormats) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, Locale.ENGLISH);
                dateParser.setTimeZone(TIMEZONE_GMT);
                dateParser.set2DigitYearStart(startDate);
            } else {
                dateParser.applyPattern(format);
            }
            try {
                return dateParser.parse(dateValue);
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Unable to parse the date " + dateValue, 0);
    }

    public static String stripHtmlFromPropertyIfNecessary(String propertyName, String value) {
        if (propertyName.equals("Description.html")) {
            try {
                return CmsHtmlExtractor.extractText(value, "UTF-8");
            }
            catch (UnsupportedEncodingException | ParserException e) {
                LOG.warn((Object)"Could not strip HTML from property value. Returning the original value.", e);
            }
        }
        return value;
    }

    public static Collection<ContentStream> toContentStreams(String str, String contentType) {
        if (str == null) {
            return null;
        }
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        ContentStreamBase.StringStream ccc = new ContentStreamBase.StringStream(str);
        ccc.setContentType(contentType);
        streams.add((ContentStream)ccc);
        return streams;
    }

    @Deprecated
    public static SolrDocument toSolrDocument(SolrInputDocument d) {
        SolrDocument doc = new SolrDocument();
        for (SolrInputField field : d) {
            doc.setField(field.getName(), field.getValue());
        }
        if (d.getChildDocuments() != null) {
            for (SolrInputDocument in : d.getChildDocuments()) {
                doc.addChildDocument(CmsSearchUtil.toSolrDocument(in));
            }
        }
        return doc;
    }

    @Deprecated
    public static SolrInputDocument toSolrInputDocument(SolrDocument d) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        d.getFieldNames().forEach(name -> doc.addField(name, d.getFieldValue(name)));
        return doc;
    }

    static {
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd hh:mm:ss");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("EEE MMM d hh:mm:ss z yyyy");
        DEFAULT_DATE_FORMATS.addAll(DEFAULT_HTTP_CLIENT_PATTERNS);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
    }
}

