/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.search.CmsIndexException;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractorPdf;
import org.opencms.search.extractors.I_CmsExtractionResult;

public class CmsDocumentPdf
extends A_CmsVfsDocument {
    public CmsDocumentPdf(String name) {
        super(name);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index) throws CmsIndexException, CmsException {
        this.logContentExtraction(resource, index);
        CmsFile file = this.readFile(cms, resource);
        try {
            return CmsExtractorPdf.getExtractor().extractText(file.getContents());
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("EncryptedDocumentException")) {
                throw new CmsIndexException(Messages.get().container("ERR_DECRYPTING_RESOURCE_1", resource.getRootPath()), (Throwable)e);
            }
            if (e instanceof InvalidPasswordException) {
                throw new CmsIndexException(Messages.get().container("ERR_PWD_PROTECTED_1", resource.getRootPath()), (Throwable)e);
            }
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return false;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }
}

