/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsObjectFunctionTransformer;
import org.opencms.jsp.util.CmsStringTemplateRenderer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsGalleryNameMacroResolver
extends CmsMacroResolver {
    private static final Log LOG = CmsLog.getLog(CmsGalleryNameMacroResolver.class);
    public static final String PREFIX_VALUE = "value:";
    public static final String PAGE_TITLE = "page_title";
    public static final String PAGE_NAV = "page_nav";
    public static final String NO_PREFIX = "no_prefix";
    public static final Pattern NO_PREFIX_PATTERN = Pattern.compile("%\\(no_prefix:(.*?)\\)");
    public static final String PREFIX_STRINGTEMPLATE = "stringtemplate:";
    private A_CmsXmlDocument m_content;
    private Locale m_contentLocale;
    private final Function<String, String> m_defaultStringTemplateSource = s -> this.m_content.getHandler().getParameter((String)s);
    private Function<String, String> m_stringTemplateSource = this.m_defaultStringTemplateSource;

    public CmsGalleryNameMacroResolver(CmsObject cms, A_CmsXmlDocument content, Locale locale) {
        this.setCmsObject(cms);
        CmsMultiMessages message = new CmsMultiMessages(locale);
        message.addMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        message.addMessages(content.getContentDefinition().getContentHandler().getMessages(locale));
        this.setMessages(message);
        this.m_content = content;
        this.m_contentLocale = locale;
    }

    @Override
    public String getMacroValue(String macro) {
        if (macro.startsWith(PREFIX_VALUE)) {
            String path = macro.substring(PREFIX_VALUE.length());
            I_CmsXmlContentValue contentValue = this.m_content.getValue(path, this.m_contentLocale);
            String value = null;
            if (contentValue != null) {
                value = contentValue.getStringValue(this.m_cms);
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
        if (macro.equals(PAGE_TITLE)) {
            return this.getContainerPageProperty("Title");
        }
        if (macro.equals(PAGE_NAV)) {
            return this.getContainerPageProperty("NavText");
        }
        if (macro.startsWith(PREFIX_STRINGTEMPLATE)) {
            return this.resolveStringTemplate(macro.substring(PREFIX_STRINGTEMPLATE.length()));
        }
        if (macro.startsWith(NO_PREFIX)) {
            return "%(" + macro + ")";
        }
        return super.getMacroValue(macro);
    }

    @Override
    public String resolveMacros(String input) {
        if (input == null) {
            return null;
        }
        String result = super.resolveMacros(input);
        Matcher matcher = NO_PREFIX_PATTERN.matcher(result);
        if (matcher.find()) {
            StringBuffer resultBuffer = new StringBuffer();
            matcher.appendReplacement(resultBuffer, matcher.start() == 0 ? "" : result.substring(matcher.start(1), matcher.end(1)));
            matcher.appendTail(resultBuffer);
            result = resultBuffer.toString();
        }
        return result;
    }

    public void setStringTemplateSource(Function<String, String> stringtemplateSource) {
        if (stringtemplateSource == null) {
            stringtemplateSource = this.m_defaultStringTemplateSource;
        }
        this.m_stringTemplateSource = stringtemplateSource;
    }

    protected String getContainerPageProperty(String propName) {
        try {
            List<CmsRelation> relations = this.m_cms.readRelations(CmsRelationFilter.relationsToStructureId(this.m_content.getFile().getStructureId()));
            HashMap pagePropsByLocale = Maps.newHashMap();
            for (CmsRelation relation : relations) {
                CmsResource source = relation.getSource(this.m_cms, CmsResourceFilter.IGNORE_EXPIRATION);
                if (!CmsResourceTypeXmlContainerPage.isContainerPage(source)) continue;
                List<CmsProperty> pagePropertiesList = this.m_cms.readPropertyObjects(source, true);
                Map<String, CmsProperty> pageProperties = CmsProperty.toObjectMap(pagePropertiesList);
                Locale pageLocale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, source);
                CmsProperty pagePropCandidate = pageProperties.get(propName);
                if (pagePropCandidate == null) continue;
                if (pagePropsByLocale.get(pageLocale) == null) {
                    pagePropsByLocale.put(pageLocale, pagePropCandidate.getValue());
                    continue;
                }
                return "";
            }
            Locale matchingLocale = OpenCms.getLocaleManager().getBestMatchingLocale(this.m_contentLocale, OpenCms.getLocaleManager().getDefaultLocales(), Lists.newArrayList(pagePropsByLocale.keySet()));
            String result = (String)pagePropsByLocale.get(matchingLocale);
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String resolveStringTemplate(String stMacro) {
        String template = this.m_stringTemplateSource.apply(stMacro.trim());
        if (template == null) {
            return "";
        }
        CmsJspContentAccessBean jspContentAccess = new CmsJspContentAccessBean(this.m_cms, this.m_contentLocale, this.m_content);
        HashMap params = Maps.newHashMap();
        params.put("fn", CmsCollectionsGenericWrapper.createLazyMap(new CmsObjectFunctionTransformer(this.m_cms)));
        params.put(PAGE_TITLE, new Object(){

            public String toString() {
                return CmsGalleryNameMacroResolver.this.getContainerPageProperty("Title");
            }
        });
        params.put(PAGE_NAV, new Object(){

            public String toString() {
                return CmsGalleryNameMacroResolver.this.getContainerPageProperty("NavText");
            }
        });
        String result = CmsStringTemplateRenderer.renderTemplate(this.m_cms, template, jspContentAccess, (Map<String, Object>)params);
        return result;
    }
}

