/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsGallerySearch {
    protected transient CmsObject m_cms;
    private CmsSolrIndex m_index;

    public static CmsGallerySearchResult searchById(CmsObject cms, CmsUUID structureId, Locale locale) throws CmsException {
        CmsGallerySearch gallerySearch = new CmsGallerySearch();
        gallerySearch.init(cms);
        gallerySearch.setIndexForProject(cms);
        return gallerySearch.searchById(structureId, locale);
    }

    public static CmsGallerySearchResult searchByPath(CmsObject cms, String rootPath, Locale locale) throws CmsException {
        CmsGallerySearch gallerySearch = new CmsGallerySearch();
        gallerySearch.init(cms);
        gallerySearch.setIndexForProject(cms);
        return gallerySearch.searchByPath(rootPath, locale);
    }

    public String getIndex() {
        return this.getSearchIndex().getName();
    }

    public CmsGallerySearchResultList getResult(CmsGallerySearchParameters params) throws CmsException {
        CmsGallerySearchResultList result = null;
        if (this.m_cms == null || this.m_index == null) {
            throw new CmsException(Messages.get().container("ERR_SEARCH_NOT_INITIALIZED_0"));
        }
        result = this.m_index.gallerySearch(this.m_cms, params);
        if (result.size() > 0) {
            result.calculatePages(params.getResultPage(), params.getMatchesPerPage());
        } else {
            result = new CmsGallerySearchResultList();
        }
        return result;
    }

    public CmsSolrIndex getSearchIndex() {
        return this.m_index;
    }

    public void init(CmsObject cms) {
        this.m_cms = cms;
    }

    public CmsGallerySearchResult searchById(CmsUUID id, Locale locale) throws CmsException {
        I_CmsSearchDocument sDoc = this.m_index.getDocument("id", id.toString(), CmsGallerySearchResult.getRequiredSolrFields());
        CmsGallerySearchResult result = null;
        if (sDoc != null && sDoc.getDocument() != null) {
            result = new CmsGallerySearchResult(sDoc, this.m_cms, 100, locale);
        } else {
            CmsResource res = this.m_cms.readResource(id, CmsResourceFilter.ALL);
            result = new CmsGallerySearchResult(this.m_cms, res);
        }
        return result;
    }

    public CmsGallerySearchResult searchByPath(String path, Locale locale) throws CmsException {
        I_CmsSearchDocument sDoc = this.m_index.getDocument("path", path);
        CmsGallerySearchResult result = null;
        if (sDoc != null && sDoc.getDocument() != null) {
            result = new CmsGallerySearchResult(sDoc, this.m_cms, 100, locale);
        } else {
            CmsResource res = this.m_cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
            result = new CmsGallerySearchResult(this.m_cms, res);
        }
        return result;
    }

    public void setIndex(String indexName) throws CmsException {
        if (CmsStringUtil.isEmpty(indexName)) {
            throw new CmsException(Messages.get().container("ERR_INDEXSOURCE_CREATE_MISSING_NAME_0"));
        }
        CmsSolrIndex index = OpenCms.getSearchManager().getIndexSolr(indexName);
        if (index == null) {
            throw new CmsException(Messages.get().container("ERR_INDEX_NOT_FOUND_1", indexName));
        }
        this.m_index = index;
    }

    public void setIndexForProject(CmsObject cms) throws CmsException {
        this.setIndex(cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline");
    }
}

