/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchUtil;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsUUID;

public class CmsGallerySearchParameters {
    private Collection<CmsUUID> m_allowedFunctions;
    private List<String> m_categories;
    private List<String> m_containerTypes;
    private CmsGallerySearchTimeRange m_dateCreatedTimeRange;
    private CmsGallerySearchTimeRange m_dateLastModifiedTimeRange;
    private List<String> m_folders;
    private List<String> m_foldersToSearchIn;
    private List<String> m_galleries;
    private boolean m_ignoreSearchExclude;
    private String m_locale;
    private int m_matchesPerPage = 10;
    private String m_referencePath;
    private List<String> m_resourceTypes;
    private int m_resultPage = 1;
    private CmsGallerySearchScope m_scope;
    private CmsGallerySortParam m_sortOrder;
    private String m_words;

    public List<String> getCategories() {
        return this.m_categories;
    }

    public List<String> getContainerTypes() {
        return this.m_containerTypes;
    }

    public CmsGallerySearchTimeRange getDateCreatedRange() {
        if (this.m_dateCreatedTimeRange == null) {
            this.m_dateCreatedTimeRange = new CmsGallerySearchTimeRange();
        }
        return this.m_dateCreatedTimeRange;
    }

    public CmsGallerySearchTimeRange getDateLastModifiedRange() {
        if (this.m_dateLastModifiedTimeRange == null) {
            this.m_dateLastModifiedTimeRange = new CmsGallerySearchTimeRange();
        }
        return this.m_dateLastModifiedTimeRange;
    }

    public List<String> getFolders() {
        return this.m_folders;
    }

    public List<String> getGalleries() {
        return this.m_galleries;
    }

    public String getLocale() {
        if (this.m_locale == null) {
            this.m_locale = CmsLocaleManager.getDefaultLocale().toString();
        }
        return this.m_locale;
    }

    public int getMatchesPerPage() {
        return this.m_matchesPerPage;
    }

    public CmsSolrQuery getQuery(CmsObject cms) {
        CmsSolrQuery query = new CmsSolrQuery();
        query.setCategories(this.m_categories);
        if (null != this.m_containerTypes) {
            query.addFilterQuery("container_types", this.m_containerTypes, false, false);
        }
        query.addFilterQuery(new String[]{CmsSearchUtil.getDateCreatedTimeRangeFilterQuery("created", this.getDateCreatedRange().m_startTime, this.getDateCreatedRange().m_endTime)});
        query.addFilterQuery(new String[]{CmsSearchUtil.getDateCreatedTimeRangeFilterQuery("lastmodified", this.getDateLastModifiedRange().m_startTime, this.getDateLastModifiedRange().m_endTime)});
        this.m_foldersToSearchIn = new ArrayList<String>();
        this.addFoldersToSearchIn(this.m_folders);
        this.addFoldersToSearchIn(this.m_galleries);
        this.setSearchFolders(cms);
        query.addFilterQuery("parent-folders", new ArrayList<String>(this.m_foldersToSearchIn), false, true);
        if (!this.m_ignoreSearchExclude) {
            query.addFilterQuery("-search_exclude", Arrays.asList("all", "gallery"), false, true);
        }
        query.setRows(new Integer(this.m_matchesPerPage));
        if (null != this.m_resourceTypes) {
            ArrayList<String> resourceTypes = new ArrayList<String>(this.m_resourceTypes);
            if (this.m_resourceTypes.contains("function_config") && !this.m_resourceTypes.contains("function")) {
                resourceTypes.add("function");
            }
            query.setResourceTypes(resourceTypes);
        }
        query.setStart(new Integer((this.m_resultPage - 1) * this.m_matchesPerPage));
        if (null != this.m_locale) {
            query.setLocales(CmsLocaleManager.getLocale(this.m_locale));
        }
        if (null != this.m_words) {
            query.setQuery(this.m_words);
        }
        query.setSort(this.getSort().getFirst(), this.getSort().getSecond());
        query.addFilterQuery(new String[]{"{!collapse field=id}"});
        query.setFields(CmsGallerySearchResult.getRequiredSolrFields());
        if (this.m_allowedFunctions != null && !this.m_allowedFunctions.isEmpty()) {
            String functionFilter = "((-type:(function OR function_config)) OR (id:(";
            Iterator<CmsUUID> it = this.m_allowedFunctions.iterator();
            while (it.hasNext()) {
                CmsUUID id = it.next();
                functionFilter = functionFilter + id.toString();
                if (!it.hasNext()) continue;
                functionFilter = functionFilter + " OR ";
            }
            functionFilter = functionFilter + ")))";
            query.addFilterQuery(new String[]{functionFilter});
        }
        return query;
    }

    public String getReferencePath() {
        return this.m_referencePath;
    }

    public List<String> getResourceTypes() {
        return this.m_resourceTypes;
    }

    public int getResultPage() {
        return this.m_resultPage;
    }

    public CmsGallerySearchScope getScope() {
        if (this.m_scope == null) {
            return OpenCms.getWorkplaceManager().getGalleryDefaultScope();
        }
        return this.m_scope;
    }

    public String getSearchWords() {
        return this.m_words;
    }

    public CmsGallerySortParam getSortOrder() {
        if (this.m_sortOrder == null) {
            this.m_sortOrder = CmsGallerySortParam.DEFAULT;
        }
        return this.m_sortOrder;
    }

    public boolean isIgnoreSearchExclude() {
        return this.m_ignoreSearchExclude;
    }

    public void setAllowedFunctions(Collection<CmsUUID> allowedFunctions) {
        this.m_allowedFunctions = allowedFunctions;
    }

    public void setCategories(List<String> categories) {
        this.m_categories = categories;
    }

    public void setContainerTypes(List<String> containerTypes) {
        this.m_containerTypes = containerTypes;
    }

    public void setDateCreatedTimeRange(long startTime, long endTime) {
        if (this.m_dateCreatedTimeRange == null) {
            this.m_dateCreatedTimeRange = new CmsGallerySearchTimeRange(startTime, endTime);
        }
    }

    public void setDateLastModifiedTimeRange(long startTime, long endTime) {
        if (this.m_dateLastModifiedTimeRange == null) {
            this.m_dateLastModifiedTimeRange = new CmsGallerySearchTimeRange(startTime, endTime);
        }
    }

    public void setFolders(List<String> folders) {
        this.m_folders = folders;
    }

    public void setGalleries(List<String> galleries) {
        this.m_galleries = galleries;
    }

    public void setIgnoreSearchExclude(boolean excludeForPageEditor) {
        this.m_ignoreSearchExclude = excludeForPageEditor;
    }

    public void setMatchesPerPage(int matchesPerPage) {
        this.m_matchesPerPage = matchesPerPage;
    }

    public void setReferencePath(String referencePath) {
        this.m_referencePath = referencePath;
    }

    public void setResourceTypes(List<String> resourceTypes) {
        this.m_resourceTypes = resourceTypes;
    }

    public void setResultPage(int resultPage) {
        this.m_resultPage = resultPage;
    }

    public void setScope(CmsGallerySearchScope scope) {
        this.m_scope = scope;
    }

    public void setSearchLocale(String locale) {
        this.m_locale = locale;
    }

    public void setSearchWords(String words) {
        this.m_words = words;
    }

    public void setSortOrder(CmsGallerySortParam sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    private void addFoldersToSearchIn(List<String> folders) {
        if (null == folders) {
            return;
        }
        for (String folder : folders) {
            if (!CmsResource.isFolder(folder)) {
                folder = folder + "/";
            }
            this.m_foldersToSearchIn.add(folder);
        }
    }

    private boolean containsFunctionType(List<String> resourceTypes) {
        if (resourceTypes.contains("function")) {
            return true;
        }
        return resourceTypes.contains("function_config");
    }

    private CmsPair<String, SolrQuery.ORDER> getSort() {
        String sortTitle = CmsSearchFieldConfiguration.getLocaleExtendedName("title", this.getLocale()) + "_s";
        switch (this.getSortOrder()) {
            case dateCreated_asc: {
                return CmsPair.create("created", SolrQuery.ORDER.asc);
            }
            case dateCreated_desc: {
                return CmsPair.create("created", SolrQuery.ORDER.desc);
            }
            case dateExpired_asc: {
                return CmsPair.create("expired", SolrQuery.ORDER.asc);
            }
            case dateExpired_desc: {
                return CmsPair.create("expired", SolrQuery.ORDER.desc);
            }
            case dateLastModified_asc: {
                return CmsPair.create("lastmodified", SolrQuery.ORDER.asc);
            }
            case dateLastModified_desc: {
                return CmsPair.create("lastmodified", SolrQuery.ORDER.desc);
            }
            case dateReleased_asc: {
                return CmsPair.create("released", SolrQuery.ORDER.asc);
            }
            case dateReleased_desc: {
                return CmsPair.create("released", SolrQuery.ORDER.desc);
            }
            case length_asc: {
                return CmsPair.create("size", SolrQuery.ORDER.asc);
            }
            case length_desc: {
                return CmsPair.create("size", SolrQuery.ORDER.desc);
            }
            case path_asc: {
                return CmsPair.create("path", SolrQuery.ORDER.asc);
            }
            case path_desc: {
                return CmsPair.create("path", SolrQuery.ORDER.desc);
            }
            case score: {
                return CmsPair.create("score", SolrQuery.ORDER.asc);
            }
            case state_asc: {
                return CmsPair.create("state", SolrQuery.ORDER.asc);
            }
            case state_desc: {
                return CmsPair.create("state", SolrQuery.ORDER.desc);
            }
            case title_asc: {
                return CmsPair.create(sortTitle, SolrQuery.ORDER.asc);
            }
            case title_desc: {
                return CmsPair.create(sortTitle, SolrQuery.ORDER.desc);
            }
            case type_asc: {
                return CmsPair.create("type", SolrQuery.ORDER.asc);
            }
            case type_desc: {
                return CmsPair.create("type", SolrQuery.ORDER.desc);
            }
            case userCreated_asc: {
                return CmsPair.create("userCreated", SolrQuery.ORDER.asc);
            }
            case userCreated_desc: {
                return CmsPair.create("userCreated", SolrQuery.ORDER.desc);
            }
            case userLastModified_asc: {
                return CmsPair.create("userLastModified", SolrQuery.ORDER.asc);
            }
            case userLastModified_desc: {
                return CmsPair.create("userLastModified", SolrQuery.ORDER.desc);
            }
        }
        return CmsPair.create(sortTitle, SolrQuery.ORDER.asc);
    }

    private void setSearchFolders(CmsObject obj) {
        if (this.m_foldersToSearchIn.isEmpty()) {
            this.setSearchScopeFilter(obj);
        }
    }

    private void setSearchScopeFilter(CmsObject cms) {
        List<String> searchRoots = CmsSearchUtil.computeScopeFolders(cms, this);
        if (null != this.getResourceTypes() && this.containsFunctionType(this.getResourceTypes())) {
            searchRoots.add("/system/modules/");
        }
        this.addFoldersToSearchIn(searchRoots);
    }

    class CmsGallerySearchTimeRange {
        long m_endTime;
        long m_startTime;

        public CmsGallerySearchTimeRange() {
            this.m_startTime = Long.MIN_VALUE;
            this.m_endTime = Long.MAX_VALUE;
        }

        public CmsGallerySearchTimeRange(long startTime, long endTime) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
        }

        public long getEndTime() {
            return this.m_endTime;
        }

        public long getStartTime() {
            return this.m_startTime;
        }
    }

    public static enum CmsGallerySortParam {
        dateCreated_asc,
        dateCreated_desc,
        dateExpired_asc,
        dateExpired_desc,
        dateLastModified_asc,
        dateLastModified_desc,
        dateReleased_asc,
        dateReleased_desc,
        length_asc,
        length_desc,
        path_asc,
        path_desc,
        score,
        state_asc,
        state_desc,
        title_asc,
        title_desc,
        type_asc,
        type_desc,
        userCreated_asc,
        userCreated_desc,
        userLastModified_asc,
        userLastModified_desc;

        public static final CmsGallerySortParam DEFAULT;

        static {
            DEFAULT = title_asc;
        }
    }
}

