/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrIndexWriter;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.search.solr.I_CmsSolrPostSearchProcessor;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSolrIndex
extends CmsSearchIndex {
    private static final long serialVersionUID = -1570077792574476721L;
    public static final String DEFAULT_INDEX_NAME_OFFLINE = "Solr Offline";
    public static final String DEFAULT_INDEX_NAME_ONLINE = "Solr Online";
    public static final String POST_PROCESSOR = "search.solr.postProcessor";
    public static final String SOLR_SEARCH_MAX_PROCESSED_RESULTS = "search.solr.maxProcessedResults";
    public static final String SOLR_HANDLER_ALLOWED_FIELDS = "handle.solr.allowedFields";
    public static final String SOLR_HANDLER_MAX_ALLOWED_RESULTS_PER_PAGE = "handle.solr.maxAllowedResultsPerPage";
    public static final String SOLR_HANDLER_MAX_ALLOWED_RESULTS_AT_ALL = "handle.solr.maxAllowedResultsAtAll";
    private static final String SOLR_HANDLER_DISABLE_SELECT = "handle.solr.disableSelectHandler";
    private static final String SOLR_HANDLER_DEBUG_SECRET_FILE = "handle.solr.debugSecretFile";
    private static final String SOLR_HANDLER_DISABLE_SPELL = "handle.solr.disableSpellHandler";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_SOLR = "solr";
    public static final int ROWS_MAX = 50;
    public static final int MAX_RESULTS_UNLIMITED = -1;
    public static final int MAX_RESULTS_GALLERY = 10000;
    protected static final int DEBUG_PADDING_RIGHT = 50;
    private static final String HEADER_PARAMS_NAME = "params";
    private static final Log LOG = CmsLog.getLog(CmsSolrIndex.class);
    private static final CmsResource PSEUDO_RES = new CmsResource(null, null, null, 0, false, 0, null, null, 0L, null, 0L, null, 0L, 0L, 0, 0, 0L, 0);
    private static final String QUERY_RESPONSE_NAME = "response";
    private static final String QUERY_TIME_NAME = "QTime";
    private static final String QUERY_HIGHLIGHTING_NAME = "highlighting";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String REQUEST_PARAM_DEBUG_SECRET = "_debug";
    private static final String QUERY_SPELLCHECK_NAME = "spellcheck";
    private static final String QUERY_SORT_NAME = "sort";
    private static final String QUERY_PARAM_EXPAND = "expand";
    transient SolrClient m_solr;
    private transient I_CmsSolrPostSearchProcessor m_postProcessor;
    private transient String m_coreName;
    private String[] m_handlerAllowedFields;
    private int m_handlerMaxAllowedResultsPerPage = -1;
    private int m_handlerMaxAllowedResultsAtAll = -1;
    private boolean m_handlerSelectDisabled;
    private String m_handlerDebugSecretFile;
    private boolean m_handlerSpellDisabled;
    int m_maxProcessedResults = -2;

    public CmsSolrIndex() {
    }

    public CmsSolrIndex(String name) throws CmsIllegalArgumentException {
        super(name);
    }

    public static final String getType(CmsObject cms, String rootPath) {
        I_CmsSearchDocument doc;
        String type = null;
        CmsSolrIndex index = CmsSearchManager.getIndexSolr(cms, null);
        if (index != null && (doc = index.getDocument("path", rootPath)) != null) {
            type = doc.getFieldValueAsString("type");
        }
        return type;
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
        switch (key) {
            case "search.solr.postProcessor": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                try {
                    this.setPostProcessor((I_CmsSolrPostSearchProcessor)Class.forName(value).newInstance());
                }
                catch (Exception e) {
                    CmsException ex = new CmsException(org.opencms.search.solr.Messages.get().container("LOG_SOLR_ERR_POST_PROCESSOR_NOT_EXIST_1", value), (Throwable)e);
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
                break;
            }
            case "handle.solr.allowedFields": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                this.m_handlerAllowedFields = (String[])Stream.of(value.split(",")).map(v -> v.trim()).toArray(String[]::new);
                break;
            }
            case "handle.solr.maxAllowedResultsPerPage": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                try {
                    this.m_handlerMaxAllowedResultsPerPage = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Could not parse parameter \"handle.solr.maxAllowedResultsPerPage\" for index \"" + this.getName() + "\". Results per page will not be restricted."));
                }
                break;
            }
            case "handle.solr.maxAllowedResultsAtAll": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                try {
                    this.m_handlerMaxAllowedResultsAtAll = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Could not parse parameter \"handle.solr.maxAllowedResultsAtAll\" for index \"" + this.getName() + "\". Results per page will not be restricted."));
                }
                break;
            }
            case "handle.solr.disableSelectHandler": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                this.m_handlerSelectDisabled = value.trim().toLowerCase().equals("true");
                break;
            }
            case "handle.solr.debugSecretFile": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                this.m_handlerDebugSecretFile = value.trim();
                break;
            }
            case "handle.solr.disableSpellHandler": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                this.m_handlerSpellDisabled = value.trim().toLowerCase().equals("true");
                break;
            }
            case "search.solr.maxProcessedResults": {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) break;
                try {
                    this.m_maxProcessedResults = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Could not parse parameter \"search.solr.maxProcessedResults\" for index \"" + this.getName() + "\". The global configuration will be used instead."));
                }
                break;
            }
            default: {
                super.addConfigurationParameter(key, value);
            }
        }
    }

    @Override
    public I_CmsSearchDocument createEmptyDocument(CmsResource resource) {
        CmsSolrDocument doc = new CmsSolrDocument(new SolrInputDocument(new String[0]));
        doc.setId(resource.getStructureId());
        return doc;
    }

    @Override
    public I_CmsIndexWriter createIndexWriter(boolean create, I_CmsReport report) {
        return new CmsSolrIndexWriter(this.m_solr, this);
    }

    @Override
    public boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        block7: {
            if (resource.isFolder() || resource.isTemporaryFile()) {
                return true;
            }
            if (this.getName().equals(DEFAULT_INDEX_NAME_OFFLINE)) {
                return false;
            }
            boolean isOnlineIndex = this.getProject().equals("Online");
            if (isOnlineIndex && resource.getDateExpired() <= System.currentTimeMillis()) {
                return true;
            }
            try {
                String propValue = cms.readPropertyObject(resource, "search.exclude", true).getValue();
                if (propValue != null && !"false".equalsIgnoreCase(propValue.trim())) {
                    return true;
                }
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_PROPERTY_1", resource.getRootPath()));
            }
        }
        if (!"all".equalsIgnoreCase(this.getLocale().getLanguage())) {
            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
            Locale match = OpenCms.getLocaleManager().getFirstMatchingLocale(Collections.singletonList(this.getLocale()), locales);
            return match == null;
        }
        return false;
    }

    public CmsGallerySearchResultList gallerySearch(CmsObject cms, CmsGallerySearchParameters params) {
        CmsGallerySearchResultList resultList = new CmsGallerySearchResultList();
        try {
            CmsSolrResultList list = this.search(cms, params.getQuery(cms), false, null, true, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED, 10000);
            if (null == list) {
                return null;
            }
            resultList.setHitCount(Long.valueOf(list.getNumFound()).intValue());
            for (CmsSearchResource resource : list) {
                I_CmsSearchDocument document = resource.getDocument();
                Locale locale = CmsLocaleManager.getLocale(params.getLocale());
                CmsGallerySearchResult result = new CmsGallerySearchResult(document, cms, (int)document.getScore(), locale);
                resultList.add(result);
            }
        }
        catch (CmsSearchException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultList;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = super.getConfiguration();
        if (this.getPostProcessor() != null) {
            result.put(POST_PROCESSOR, this.getPostProcessor().getClass().getName());
        }
        return result;
    }

    public String getCoreName() {
        return this.m_coreName;
    }

    @Override
    public synchronized I_CmsSearchDocument getDocument(String fieldname, String term) {
        return this.getDocument(fieldname, term, null);
    }

    public synchronized I_CmsSearchDocument getDocument(String fieldname, String term, String[] fls) {
        try {
            SolrDocumentList sdl;
            QueryResponse res;
            SolrQuery query = new SolrQuery();
            if ("path".equals(fieldname)) {
                query.setQuery(fieldname + ":\"" + term + "\"");
            } else {
                query.setQuery(fieldname + ":" + term);
            }
            query.addFilterQuery(new String[]{"{!collapse field=" + fieldname + "}"});
            if (null != fls) {
                query.setFields(fls);
            }
            if ((res = this.m_solr.query((SolrParams)query)) != null && (sdl = this.m_solr.query((SolrParams)query).getResults()).getNumFound() > 0L && sdl.get(0) != null) {
                return new CmsSolrDocument((SolrDocument)sdl.get(0));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        if (this.isIndexing(res)) {
            I_CmsDocumentFactory defaultFactory = super.getDocumentFactory(res);
            if (null == defaultFactory) {
                if (OpenCms.getResourceManager().getResourceType(res) instanceof CmsResourceTypeXmlContainerPage) {
                    return OpenCms.getSearchManager().getDocumentFactory("containerpage-solr", "text/html");
                }
                if (CmsResourceTypeXmlContent.isXmlContent(res)) {
                    return OpenCms.getSearchManager().getDocumentFactory("xmlcontent-solr", "text/html");
                }
            }
            return defaultFactory;
        }
        return null;
    }

    @Override
    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        Locale result = null;
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        if (availableLocales != null && availableLocales.size() > 0) {
            result = OpenCms.getLocaleManager().getBestMatchingLocale(defaultLocales.get(0), defaultLocales, availableLocales);
        }
        if (result == null) {
            result = availableLocales != null && availableLocales.isEmpty() ? availableLocales.get(0) : defaultLocales.get(0);
        }
        return result;
    }

    public int getMaxProcessedResults() {
        return this.m_maxProcessedResults;
    }

    public I_CmsSolrPostSearchProcessor getPostProcessor() {
        return this.m_postProcessor;
    }

    @Override
    public void initialize() throws CmsSearchException {
        super.initialize();
        if (this.m_maxProcessedResults == -2) {
            this.m_maxProcessedResults = OpenCms.getSearchManager().getSolrServerConfiguration().getMaxProcessedResults();
        }
        try {
            OpenCms.getSearchManager().registerSolrIndex(this);
        }
        catch (CmsConfigurationException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.setEnabled(false);
        }
    }

    public boolean isNoSolrServerSet() {
        return null == this.m_solr;
    }

    @Override
    @Deprecated
    public synchronized CmsSearchResultList search(CmsObject cms, CmsSearchParameters params) {
        throw new UnsupportedOperationException();
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query) throws CmsSearchException {
        return this.search(cms, query, false);
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows) throws CmsSearchException {
        return this.search(cms, query, ignoreMaxRows, null, false, null);
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows, CmsResourceFilter filter) throws CmsSearchException {
        return this.search(cms, query, ignoreMaxRows, null, false, filter);
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows, ServletResponse response, boolean ignoreSearchExclude, CmsResourceFilter filter) throws CmsSearchException {
        return this.search(cms, query, ignoreMaxRows, response, ignoreSearchExclude, filter, this.getMaxProcessedResults());
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows, ServletResponse response, boolean ignoreSearchExclude, CmsResourceFilter filter, int maxNumResults) throws CmsSearchException {
        int rows;
        int start;
        CmsSolrResultList result = null;
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_DEBUG_ORIGINAL_QUERY_2", (Object)query, this.getName()));
        }
        int previousPriority = Thread.currentThread().getPriority();
        if (this.getPriority() > 0) {
            Thread.currentThread().setPriority(this.getPriority());
        }
        this.checkOfflineAccess(cms);
        if (!ignoreSearchExclude) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_INFO_ADDING_SEARCH_EXCLUDE_FILTER_FOR_QUERY_2", (Object)query, this.getName()));
            }
            query.addFilterQuery(new String[]{"search_exclude:\"false\""});
        }
        int n = start = null == query.getStart() ? 0 : query.getStart();
        if (start < 0) {
            query.setStart(0);
            start = 0;
        }
        if (maxNumResults < 0) {
            maxNumResults = Integer.MAX_VALUE;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_INFO_LIMITING_MAX_PROCESSED_RESULTS_3", (Object)query, this.getName(), maxNumResults));
            }
        }
        int n2 = rows = null == query.getRows() ? CmsSolrQuery.DEFAULT_ROWS.intValue() : query.getRows().intValue();
        if (rows + start > maxNumResults || rows + start < 0) {
            rows = maxNumResults - start;
        }
        if (!ignoreMaxRows && rows > 50) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_INFO_LIMITING_MAX_ROWS_4", new Object[]{query, this.getName(), rows, 50}));
            }
            rows = 50;
        }
        if (rows < 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_INFO_CORRECTING_ROWS_4", new Object[]{query, this.getName(), rows, 0}));
            }
            rows = 0;
        }
        query.setRows(rows);
        if (null != query.getParams(QUERY_PARAM_EXPAND)) {
            LOG.info((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_INFO_REMOVING_EXPAND_2", (Object)query, this.getName()));
            query.remove(QUERY_PARAM_EXPAND);
        }
        float maxScore = 0.0f;
        LocalSolrQueryRequest solrQueryRequest = null;
        SolrCore core = null;
        String[] sortParamValues = query.getParams(QUERY_SORT_NAME);
        boolean sortByScoreDesc = null == sortParamValues || sortParamValues.length == 0 || Objects.equal((Object)sortParamValues[0], (Object)"score desc");
        try {
            CmsObject searchCms = OpenCms.initCmsObject(cms);
            CmsSolrQuery checkQuery = query.clone();
            int end = start + rows;
            int itemsToCheck = 0 == end ? 0 : Math.max(10, end + end / 5);
            HashSet<Object> resultSolrIds = new HashSet<Object>(rows);
            int cnt = 0;
            long hitCount = 0L;
            long visibleHitCount = 0L;
            int processedResults = 0;
            long solrPermissionTime = 0L;
            checkQuery.setHighlight(false);
            checkQuery.setRows(Math.min(maxNumResults - processedResults, itemsToCheck));
            checkQuery.setStart(processedResults);
            checkQuery.setFields(new String[]{"type", "solr_id", "path"});
            List<String> originalFields = Arrays.asList(query.getFields().split(","));
            if (originalFields.contains("score")) {
                checkQuery.addField("score");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_DEBUG_CHECK_QUERY_2", (Object)checkQuery, this.getName()));
            }
            long solrCheckTime = System.currentTimeMillis();
            QueryResponse checkQueryResponse = this.m_solr.query((SolrParams)checkQuery);
            solrCheckTime = System.currentTimeMillis() - solrCheckTime;
            solrPermissionTime += solrCheckTime;
            hitCount = checkQueryResponse.getResults().getNumFound();
            int maxToProcess = Long.valueOf(Math.min(hitCount, (long)maxNumResults)).intValue();
            visibleHitCount = hitCount;
            for (SolrDocument doc : checkQueryResponse.getResults()) {
                try {
                    CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                    if (this.needsPermissionCheck(searchDoc) && !this.hasPermissions(searchCms, searchDoc, filter)) {
                        --visibleHitCount;
                        continue;
                    }
                    if (cnt >= start) {
                        resultSolrIds.add(searchDoc.getFieldValueAsString("solr_id"));
                    }
                    if (sortByScoreDesc && searchDoc.getScore() > maxScore) {
                        maxScore = searchDoc.getScore();
                    }
                    if (++cnt < end) continue;
                    break;
                }
                catch (Exception e) {
                    --visibleHitCount;
                    LOG.warn((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                }
            }
            if (resultSolrIds.size() < rows && (processedResults += checkQueryResponse.getResults().size()) < maxToProcess) {
                CmsSolrQuery secondCheckQuery = checkQuery.clone();
                secondCheckQuery.setFacet(false);
                secondCheckQuery.setMoreLikeThis(false);
                secondCheckQuery.set(QUERY_SPELLCHECK_NAME, false);
                block12: do {
                    itemsToCheck = itemsToCheck < 3000 ? itemsToCheck * 4 : itemsToCheck;
                    secondCheckQuery.setRows(Long.valueOf(Math.min(maxToProcess - processedResults, itemsToCheck)).intValue());
                    secondCheckQuery.setStart(processedResults);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_DEBUG_SECONDCHECK_QUERY_2", (Object)secondCheckQuery, this.getName()));
                    }
                    long solrSecondCheckTime = System.currentTimeMillis();
                    QueryResponse secondCheckQueryResponse = this.m_solr.query((SolrParams)secondCheckQuery);
                    processedResults += secondCheckQueryResponse.getResults().size();
                    solrSecondCheckTime = System.currentTimeMillis() - solrSecondCheckTime;
                    solrPermissionTime += solrCheckTime;
                    for (SolrDocument doc : secondCheckQueryResponse.getResults()) {
                        try {
                            CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                            String docSolrId = searchDoc.getFieldValueAsString("solr_id");
                            if (this.needsPermissionCheck(searchDoc) && !this.hasPermissions(searchCms, searchDoc, filter) || resultSolrIds.contains(docSolrId)) {
                                --visibleHitCount;
                                continue;
                            }
                            if (cnt >= start) {
                                resultSolrIds.add(docSolrId);
                            }
                            if (sortByScoreDesc && searchDoc.getScore() > maxScore) {
                                maxScore = searchDoc.getScore();
                            }
                            if (++cnt < end) continue;
                            continue block12;
                        }
                        catch (Exception e) {
                            --visibleHitCount;
                            LOG.warn((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                        }
                    }
                } while (resultSolrIds.size() < rows && processedResults < maxToProcess);
            }
            ArrayList<CmsSearchResource> resourceDocumentList = new ArrayList<CmsSearchResource>(resultSolrIds.size());
            SolrDocumentList solrDocumentList = new SolrDocumentList();
            long solrResultTime = 0L;
            if (this.m_postProcessor != null) {
                this.m_postProcessor.init();
            }
            SolrQuery queryForResults = new SolrQuery();
            queryForResults.setFields(new String[]{query.getFields()});
            queryForResults.setQuery(query.getQuery());
            if (!resultSolrIds.isEmpty()) {
                Optional<String> queryFilterString = resultSolrIds.stream().map(a -> '\"' + a + '\"').reduce((a, b) -> a + " OR " + b);
                queryForResults.addFilterQuery(new String[]{"solr_id:(" + queryFilterString.get() + ")"});
            }
            queryForResults.setRows(Integer.valueOf(resultSolrIds.size()));
            queryForResults.setStart(Integer.valueOf(0));
            queryForResults.setSorts(query.getSorts());
            if (null != sortParamValues) {
                queryForResults.add(QUERY_SORT_NAME, sortParamValues);
            }
            if (query.getHighlight()) {
                for (String paramName : query.getParameterNames()) {
                    if (!paramName.startsWith("hl")) continue;
                    queryForResults.add(paramName, query.getParams(paramName));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_DEBUG_RESULT_QUERY_2", queryForResults, this.getName()));
            }
            solrResultTime = System.currentTimeMillis();
            QueryResponse resultQueryResponse = this.m_solr.query((SolrParams)queryForResults);
            solrResultTime = System.currentTimeMillis() - solrResultTime;
            ArrayList<String> filteredResultIds = new ArrayList<String>(5);
            for (SolrDocument doc : resultQueryResponse.getResults()) {
                try {
                    CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                    if (this.needsPermissionCheck(searchDoc)) {
                        CmsResource resource;
                        CmsResource cmsResource = resource = filter == null ? this.getResource(searchCms, searchDoc) : this.getResource(searchCms, searchDoc, filter);
                        if (null != resource) {
                            if (this.m_postProcessor != null) {
                                doc = this.m_postProcessor.process(searchCms, resource, (SolrInputDocument)searchDoc.getDocument());
                            }
                            resourceDocumentList.add(new CmsSearchResource(resource, searchDoc));
                            solrDocumentList.add((Object)doc);
                            continue;
                        }
                        filteredResultIds.add(searchDoc.getFieldValueAsString("solr_id"));
                        continue;
                    }
                    resourceDocumentList.add(new CmsSearchResource(PSEUDO_RES, searchDoc));
                    solrDocumentList.add((Object)doc);
                    --visibleHitCount;
                }
                catch (Exception e) {
                    --visibleHitCount;
                    LOG.warn((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                }
            }
            long processTime = System.currentTimeMillis() - startTime - solrPermissionTime - solrResultTime;
            solrDocumentList.setStart((long)start);
            Float finalMaxScore = sortByScoreDesc ? new Float(maxScore) : checkQueryResponse.getResults().getMaxScore();
            solrDocumentList.setMaxScore(finalMaxScore);
            solrDocumentList.setNumFound(visibleHitCount);
            NamedList params = (NamedList)checkQueryResponse.getHeader().get(HEADER_PARAMS_NAME);
            params.clear();
            for (Object paramName : query.getParameterNames()) {
                params.add((String)paramName, (Object)query.get((String)paramName));
            }
            checkQueryResponse.getResponse().setVal(checkQueryResponse.getResponse().indexOf(QUERY_RESPONSE_NAME, 0), (Object)solrDocumentList);
            checkQueryResponse.getResponseHeader().setVal(checkQueryResponse.getResponseHeader().indexOf(QUERY_TIME_NAME, 0), (Object)new Integer(new Long(System.currentTimeMillis() - startTime).intValue()));
            if (query.getHighlight()) {
                NamedList highlighting = (NamedList)resultQueryResponse.getResponse().get(QUERY_HIGHLIGHTING_NAME);
                for (String filteredId : filteredResultIds) {
                    highlighting.remove(filteredId);
                }
                NamedList completeResponse = new NamedList(1);
                completeResponse.addAll(checkQueryResponse.getResponse());
                completeResponse.add(QUERY_HIGHLIGHTING_NAME, (Object)highlighting);
                checkQueryResponse.setResponse(completeResponse);
            }
            result = new CmsSolrResultList(query, checkQueryResponse, solrDocumentList, resourceDocumentList, start, new Integer(rows), Math.min(end, start + solrDocumentList.size()), rows > 0 ? start / rows + 1 : 0, visibleHitCount, finalMaxScore, startTime, System.currentTimeMillis());
            if (LOG.isDebugEnabled()) {
                Object[] logParams = new Object[]{new Long(System.currentTimeMillis() - startTime), new Long(result.getNumFound()), new Long(solrPermissionTime + solrResultTime), new Long(processTime), new Long(result.getHighlightEndTime() != 0L ? result.getHighlightEndTime() - startTime : 0L)};
                LOG.debug((Object)(query.toString() + "\n" + org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_SEARCH_EXECUTED_5", logParams)));
            }
            if (response != null) {
                core = this.m_solr instanceof EmbeddedSolrServer ? ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getCoreName()) : null;
                solrQueryRequest = new LocalSolrQueryRequest(core, (SolrParams)query);
                SolrQueryResponse solrQueryResponse = new SolrQueryResponse();
                solrQueryResponse.setAllValues(checkQueryResponse.getResponse());
                this.writeResp(response, (SolrQueryRequest)solrQueryRequest, solrQueryResponse);
            }
        }
        catch (Exception e) {
            throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("LOG_SOLR_ERR_SEARCH_EXECUTION_FAILD_1", CmsEncoder.decode(query.toString()), e), (Throwable)e);
        }
        finally {
            if (solrQueryRequest != null) {
                solrQueryRequest.close();
            }
            if (null != core) {
                core.close();
            }
            Thread.currentThread().setPriority(previousPriority);
        }
        return result;
    }

    public CmsSolrResultList search(CmsObject cms, SolrQuery query) throws CmsSearchException {
        return this.search(cms, CmsEncoder.decode(query.toString()));
    }

    public CmsSolrResultList search(CmsObject cms, String solrQuery) throws CmsSearchException {
        return this.search(cms, new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(solrQuery)), false);
    }

    public void select(ServletResponse response, CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows) throws Exception {
        this.throwExceptionIfSafetyRestrictionsAreViolated(cms, query, false);
        boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
        CmsResourceFilter filter = isOnline ? null : CmsResourceFilter.IGNORE_EXPIRATION;
        this.search(cms, query, ignoreMaxRows, response, false, filter);
    }

    @Override
    public void setName(String name) throws CmsIllegalArgumentException {
        super.setName(name);
        this.updateCoreName();
    }

    public void setPostProcessor(I_CmsSolrPostSearchProcessor postProcessor) {
        this.m_postProcessor = postProcessor;
    }

    public void setSolrServer(SolrClient client) {
        this.m_solr = client;
    }

    public void spellCheck(ServletResponse res, CmsObject cms, CmsSolrQuery q) throws CmsSearchException {
        this.throwExceptionIfSafetyRestrictionsAreViolated(cms, q, true);
        SolrCore core = null;
        LocalSolrQueryRequest solrQueryRequest = null;
        try {
            q.setRequestHandler("/spell");
            q.setRows(0);
            QueryResponse queryResponse = this.m_solr.query((SolrParams)q);
            ArrayList<CmsSearchResource> resourceDocumentList = new ArrayList<CmsSearchResource>();
            SolrDocumentList solrDocumentList = new SolrDocumentList();
            if (this.m_postProcessor != null) {
                for (int i = 0; i < queryResponse.getResults().size(); ++i) {
                    try {
                        CmsResource resource;
                        SolrDocument doc = (SolrDocument)queryResponse.getResults().get(i);
                        CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                        if (!this.needsPermissionCheck(searchDoc) || (resource = this.getResource(cms, searchDoc)) == null) continue;
                        if (this.m_postProcessor != null) {
                            doc = this.m_postProcessor.process(cms, resource, (SolrInputDocument)searchDoc.getDocument());
                        }
                        resourceDocumentList.add(new CmsSearchResource(resource, searchDoc));
                        solrDocumentList.add((Object)doc);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)org.opencms.search.solr.Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                    }
                }
                queryResponse.getResponse().setVal(queryResponse.getResponse().indexOf(QUERY_RESPONSE_NAME, 0), (Object)solrDocumentList);
            }
            core = this.m_solr instanceof EmbeddedSolrServer ? ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getCoreName()) : null;
            SolrQueryResponse solrQueryResponse = new SolrQueryResponse();
            solrQueryResponse.setAllValues(queryResponse.getResponse());
            solrQueryRequest = new LocalSolrQueryRequest(core, solrQueryResponse.getResponseHeader());
            solrQueryRequest.setParams((SolrParams)q);
            this.writeResp(res, (SolrQueryRequest)solrQueryRequest, solrQueryResponse);
        }
        catch (Exception e) {
            throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("LOG_SOLR_ERR_SEARCH_EXECUTION_FAILD_1", (Object)q), (Throwable)e);
        }
        finally {
            if (solrQueryRequest != null) {
                solrQueryRequest.close();
            }
            if (core != null) {
                core.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String createIndexBackup() {
        EmbeddedSolrServer ser;
        CoreContainer con;
        SolrCore core;
        if (!this.isBackupReindexing()) {
            return null;
        }
        if (this.m_solr instanceof EmbeddedSolrServer && (core = (con = (ser = (EmbeddedSolrServer)this.m_solr).getCoreContainer()).getCore(this.getCoreName())) != null) {
            try {
                SolrRequestHandler h = core.getRequestHandler("/replication");
                if (h instanceof ReplicationHandler) {
                    h.handleRequest((SolrQueryRequest)new LocalSolrQueryRequest(core, CmsRequestUtil.createParameterMap("?command=backup")), new SolrQueryResponse());
                }
            }
            finally {
                core.close();
            }
        }
        return null;
    }

    protected boolean hasPermissions(CmsObject cms, CmsSolrDocument doc, CmsResourceFilter filter) {
        return null != (filter == null ? this.getResource(cms, doc) : this.getResource(cms, doc, filter));
    }

    @Override
    protected void indexSearcherClose() {
    }

    @Override
    protected void indexSearcherOpen(String path) {
    }

    @Override
    protected void indexSearcherUpdate() {
    }

    @Override
    protected boolean isIndexing(CmsResource res) {
        if (res != null && this.getSources() != null) {
            I_CmsDocumentFactory documentFactory = OpenCms.getSearchManager().getDocumentFactory(res);
            for (CmsSearchIndexSource source : this.getSources()) {
                if (!source.isIndexing(res.getRootPath(), "containerpage-solr") && !source.isIndexing(res.getRootPath(), "xmlcontent-solr") && (documentFactory == null || !source.isIndexing(res.getRootPath(), documentFactory.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    private void checkOfflineAccess(CmsObject cms) throws CmsSearchException {
        if (!"Online".equals(this.getProject())) {
            try {
                OpenCms.getRoleManager().checkRole(cms, CmsRole.ELEMENT_AUTHOR);
            }
            catch (CmsRoleViolationException e) {
                throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("LOG_SOLR_ERR_SEARCH_PERMISSION_VIOLATION_2", this.getName(), cms.getRequestContext().getCurrentUser()), (Throwable)e);
            }
        }
    }

    private String generateCoreName(String name) {
        if (name != null) {
            return name.replace(" ", "-");
        }
        return null;
    }

    private boolean isDebug(CmsObject cms, CmsSolrQuery query) {
        String debugSecret;
        String[] debugSecretValues = query.remove(REQUEST_PARAM_DEBUG_SECRET);
        String string = debugSecret = debugSecretValues == null || debugSecretValues.length < 1 ? null : debugSecretValues[0];
        if (null != debugSecret && !debugSecret.trim().isEmpty() && null != this.m_handlerDebugSecretFile) {
            try {
                CmsFile secretFile = cms.readFile(this.m_handlerDebugSecretFile);
                String secret = new String(secretFile.getContents(), CmsFileUtil.getEncoding(cms, secretFile));
                return secret.trim().equals(debugSecret.trim());
            }
            catch (Exception e) {
                LOG.info((Object)("Failed to read secret file for index \"" + this.getName() + "\" at path \"" + this.m_handlerDebugSecretFile + "\"."));
            }
        }
        return false;
    }

    private void throwExceptionIfSafetyRestrictionsAreViolated(CmsObject cms, CmsSolrQuery query, boolean isSpell) throws CmsSearchException {
        if (!this.isDebug(cms, query)) {
            if (isSpell) {
                if (this.m_handlerSpellDisabled) {
                    throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("GUI_HANDLER_REQUEST_NOT_ALLOWED_0"));
                }
            } else {
                int rows;
                if (this.m_handlerSelectDisabled) {
                    throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("GUI_HANDLER_REQUEST_NOT_ALLOWED_0"));
                }
                int start = null != query.getStart() ? query.getStart() : 0;
                int n = rows = null != query.getRows() ? query.getRows().intValue() : CmsSolrQuery.DEFAULT_ROWS.intValue();
                if (this.m_handlerMaxAllowedResultsAtAll >= 0 && rows + start > this.m_handlerMaxAllowedResultsAtAll) {
                    throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("GUI_HANDLER_TOO_MANY_RESULTS_REQUESTED_AT_ALL_2", this.m_handlerMaxAllowedResultsAtAll, rows + start));
                }
                if (this.m_handlerMaxAllowedResultsPerPage >= 0 && rows > this.m_handlerMaxAllowedResultsPerPage) {
                    throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("GUI_HANDLER_TOO_MANY_RESULTS_REQUESTED_PER_PAGE_2", this.m_handlerMaxAllowedResultsPerPage, rows));
                }
                if (null != this.m_handlerAllowedFields && Stream.of(this.m_handlerAllowedFields).anyMatch(x -> true)) {
                    if (query.getFields().equals("*,score")) {
                        query.setFields(this.m_handlerAllowedFields);
                    } else {
                        for (String requestedField : query.getFields().split(",")) {
                            if (!Stream.of(this.m_handlerAllowedFields).noneMatch(allowedField -> allowedField.equals(requestedField))) continue;
                            throw new CmsSearchException(org.opencms.search.solr.Messages.get().container("GUI_HANDLER_REQUESTED_FIELD_NOT_ALLOWED_2", requestedField, Stream.of(this.m_handlerAllowedFields).reduce("", (a, b) -> a + "," + b)));
                        }
                    }
                }
            }
        }
    }

    private void updateCoreName() {
        this.m_coreName = this.generateCoreName(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResp(ServletResponse response, SolrQueryRequest queryRequest, SolrQueryResponse queryResponse) throws IOException, UnsupportedEncodingException {
        if (this.m_solr instanceof EmbeddedSolrServer) {
            SolrCore core = ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getCoreName());
            Writer out = null;
            try {
                QueryResponseWriter responseWriter = core.getQueryResponseWriter(queryRequest);
                String ct = responseWriter.getContentType(queryRequest, queryResponse);
                if (null != ct) {
                    response.setContentType(ct);
                }
                if (responseWriter instanceof BinaryQueryResponseWriter) {
                    BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                    binWriter.write((OutputStream)response.getOutputStream(), queryRequest, queryResponse);
                }
                String charset = ContentStreamBase.getCharsetFromContentType((String)ct);
                out = charset == null || charset.equalsIgnoreCase(UTF8.toString()) ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                out = new FastWriter(out);
                responseWriter.write(out, queryRequest, queryResponse);
                out.flush();
            }
            finally {
                core.close();
                if (out != null) {
                    out.close();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

