/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsUUID;

public class CmsAccessControlList
implements Serializable {
    private static final long serialVersionUID = -8772251229957990081L;
    private Map<CmsUUID, CmsPermissionSetCustom> m_permissions = new HashMap<CmsUUID, CmsPermissionSetCustom>();

    public void add(CmsAccessControlEntry entry) {
        CmsPermissionSetCustom p = this.m_permissions.get(entry.getPrincipal());
        if (p == null) {
            p = new CmsPermissionSetCustom();
            this.m_permissions.put(entry.getPrincipal(), p);
        }
        p.addPermissions(entry.getPermissions());
    }

    public Object clone() {
        CmsAccessControlList acl = new CmsAccessControlList();
        for (CmsUUID id : this.m_permissions.keySet()) {
            acl.m_permissions.put(id, (CmsPermissionSetCustom)this.m_permissions.get(id).clone());
        }
        return acl;
    }

    public Map<CmsUUID, CmsPermissionSetCustom> getPermissionMap() {
        return this.m_permissions;
    }

    public CmsPermissionSetCustom getPermissions(CmsUser user, List<CmsGroup> groups, List<CmsRole> roles) {
        int i;
        int size;
        CmsPermissionSetCustom sum = new CmsPermissionSetCustom();
        boolean hasPermissions = false;
        CmsPermissionSet p = this.m_permissions.get(user.getId());
        if (p != null) {
            sum.addPermissions(p);
            hasPermissions = true;
        }
        if (groups != null) {
            size = groups.size();
            for (i = 0; i < size; ++i) {
                I_CmsPrincipal principal = groups.get(i);
                p = this.m_permissions.get(principal.getId());
                if (p == null) continue;
                sum.addPermissions(p);
                hasPermissions = true;
            }
        }
        if (roles != null) {
            size = roles.size();
            for (i = 0; i < size; ++i) {
                CmsRole role = roles.get(i);
                p = this.m_permissions.get(role.getId());
                if (p == null) continue;
                sum.addPermissions(p);
                hasPermissions = true;
            }
        }
        if (!hasPermissions && (p = (CmsPermissionSet)this.m_permissions.get(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) != null) {
            sum.addPermissions(p);
        }
        return sum;
    }

    public CmsPermissionSetCustom getPermissions(CmsUUID principalId) {
        return this.m_permissions.get(principalId);
    }

    public String getPermissionString(CmsUser user, List<CmsGroup> groups, List<CmsRole> roles) {
        return this.getPermissions(user, groups, roles).getPermissionString();
    }

    public List<CmsUUID> getPrincipals() {
        ArrayList<CmsUUID> principals = new ArrayList<CmsUUID>(this.m_permissions.keySet());
        Collections.sort(principals, CmsAccessControlEntry.COMPARATOR_PRINCIPALS);
        return principals;
    }

    public void setAllowedPermissions(CmsAccessControlEntry entry) {
        CmsPermissionSetCustom p = this.m_permissions.get(entry.getPrincipal());
        if (p == null) {
            p = new CmsPermissionSetCustom();
            this.m_permissions.put(entry.getPrincipal(), p);
        }
        p.setPermissions(entry.getAllowedPermissions(), p.getDeniedPermissions());
    }

    public void setDeniedPermissions(CmsAccessControlEntry entry) {
        CmsPermissionSetCustom p = this.m_permissions.get(entry.getPrincipal());
        if (p == null) {
            p = new CmsPermissionSetCustom();
            this.m_permissions.put(entry.getPrincipal(), p);
        }
        p.setPermissions(p.getAllowedPermissions(), entry.getDeniedPermissions());
    }
}

