/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsDefaultPasswordHandler;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPasswordSecurityEvaluator;
import org.opencms.security.Messages;

public class CmsAdvancedPasswordHandler
extends CmsDefaultPasswordHandler {
    private static final Log LOG = CmsLog.getLog(CmsAdvancedPasswordHandler.class);

    @Override
    public I_CmsPasswordSecurityEvaluator.SecurityLevel evaluatePasswordSecurity(String password) {
        try {
            this.validatePassword(password);
        }
        catch (CmsSecurityException sE) {
            return I_CmsPasswordSecurityEvaluator.SecurityLevel.invalid;
        }
        if (password.length() < 10) {
            return I_CmsPasswordSecurityEvaluator.SecurityLevel.weak;
        }
        if (password.equals(password.toUpperCase())) {
            return I_CmsPasswordSecurityEvaluator.SecurityLevel.weak;
        }
        return I_CmsPasswordSecurityEvaluator.SecurityLevel.strong;
    }

    @Override
    public String getPasswordSecurityHint(Locale locale) {
        return Messages.get().container("GUI_PWD_HINT_0").key(locale);
    }

    @Override
    public void validatePassword(String password) throws CmsSecurityException {
        if (password == null) {
            CmsMessageContainer message = Messages.get().container("ERR_PWD_NULL_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key());
            }
            throw new CmsSecurityException(message);
        }
        if (password.length() < 8 || password.length() > 16) {
            CmsMessageContainer message = Messages.get().container("ERR_PWD_INVALID_SIZE_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key());
            }
            throw new CmsSecurityException(message);
        }
        if (password.equals(password.toLowerCase())) {
            CmsMessageContainer message = Messages.get().container("ERR_PWD_NO_CAPITAL_LETTER_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key());
            }
            throw new CmsSecurityException(message);
        }
        char[] pw = password.toCharArray();
        int letters = 0;
        int specialCharacter = 0;
        for (int i = 0; i < pw.length; ++i) {
            if (Character.isLetter(pw[i])) {
                ++letters;
                continue;
            }
            ++specialCharacter;
        }
        if (letters < 2 || specialCharacter < 2) {
            CmsMessageContainer message = null;
            message = letters < 2 ? Messages.get().container("ERR_PWD_NO_LETTERS_0") : Messages.get().container("ERR_PWD_NO_SPECIAL_CHARS_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key());
            }
            throw new CmsSecurityException(message);
        }
        char last = pw[0];
        int ascending = 0;
        int descending = 0;
        int equals = 0;
        for (int i = 1; i < pw.length; ++i) {
            char current = pw[i];
            ascending = last + '\u0001' == current ? ++ascending : 0;
            descending = last - '\u0001' == current ? ++descending : 0;
            equals = last == current ? ++equals : 0;
            if (descending > 1 || ascending > 1 || equals > 1) {
                Object[] msgArgs = new Object[]{new Character(last), new Character(current), new Integer(descending), new Integer(ascending), new Integer(equals)};
                CmsMessageContainer message = Messages.get().container("ERR_PWD_CHARS_IN_A_ROW_5", msgArgs);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key());
                }
                throw new CmsSecurityException(message);
            }
            last = current;
        }
    }
}

