/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.opencms.file.CmsObject;
import org.opencms.main.A_CmsAuthorizationHandler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.OpenCms;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.Messages;

public class CmsDefaultAuthorizationHandler
extends A_CmsAuthorizationHandler {
    public static final String AUTHORIZATION_BASIC_PREFIX = "BASIC ";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String SEPARATOR_CREDENTIALS = ":";

    @Override
    public String getLoginFormURL(String loginFormURL, String params, String callbackURL) {
        if (loginFormURL != null) {
            StringBuffer fullURL = new StringBuffer(loginFormURL);
            if (callbackURL != null) {
                fullURL.append("?");
                fullURL.append("requestedResource");
                fullURL.append("=");
                fullURL.append(callbackURL);
            }
            if (params != null) {
                fullURL.append(callbackURL != null ? "&" : "?");
                fullURL.append(params);
            }
            return fullURL.toString();
        }
        return null;
    }

    @Override
    public CmsObject initCmsObject(HttpServletRequest request) {
        CmsObject cms = this.checkBasicAuthorization(request);
        if (cms != null) {
            try {
                return this.registerSession(request, cms);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public CmsObject initCmsObject(HttpServletRequest request, I_CmsAuthorizationHandler.I_PrivilegedLoginAction loginAction) {
        return this.initCmsObject(request);
    }

    @Override
    public CmsObject initCmsObject(HttpServletRequest request, String userName, String pwd) throws CmsException {
        CmsObject cms = this.initCmsObjectFromSession(request);
        if (cms != null) {
            return cms;
        }
        cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        cms.loginUser(userName, pwd);
        return this.registerSession(request, cms);
    }

    @Override
    public void requestAuthorization(HttpServletRequest req, HttpServletResponse res, String loginFormURL) throws IOException {
        CmsHttpAuthenticationSettings httpAuthenticationSettings = OpenCms.getSystemInfo().getHttpAuthenticationSettings();
        if (loginFormURL == null) {
            if (httpAuthenticationSettings.useBrowserBasedHttpAuthentication()) {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"" + OpenCms.getSystemInfo().getOpenCmsContext() + "\"");
                res.setStatus(401);
                return;
            }
            if (httpAuthenticationSettings.getFormBasedHttpAuthenticationUri() != null) {
                loginFormURL = httpAuthenticationSettings.getFormBasedHttpAuthenticationUri();
            } else {
                LOG.error((Object)Messages.get().getBundle().key("ERR_UNSUPPORTED_AUTHENTICATION_MECHANISM_1", httpAuthenticationSettings.getBrowserBasedAuthenticationMechanism()));
                res.setStatus(500);
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_AUTHENTICATE_PROPERTY_2", loginFormURL, req.getRequestURI()));
        }
        res.sendRedirect(loginFormURL);
    }

    protected CmsObject checkBasicAuthorization(HttpServletRequest req) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Checking for basic authorization.");
        }
        try {
            CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            if (OpenCms.getSystemInfo().getHttpAuthenticationSettings().getBrowserBasedAuthenticationMechanism() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Browser based authorization not enabled.");
                }
                return cms;
            }
            String auth = req.getHeader(HEADER_AUTHORIZATION);
            if (auth == null || !auth.toUpperCase().startsWith(AUTHORIZATION_BASIC_PREFIX)) {
                return cms;
            }
            String base64Token = auth.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = null;
            String password = null;
            int pos = token.indexOf(SEPARATOR_CREDENTIALS);
            if (pos != -1) {
                username = token.substring(0, pos);
                password = token.substring(pos + 1);
            }
            cms.loginUser(username, password);
            req.getSession(true);
            return cms;
        }
        catch (CmsException e) {
            return null;
        }
    }
}

