/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.security.CmsDefaultAuthorizationHandler;
import org.opencms.security.CmsPersistentLoginTokenHandler;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.util.CmsRequestUtil;

public class CmsPersistentLoginAuthorizationHandler
extends CmsDefaultAuthorizationHandler {
    public static final String COOKIE_NAME = "ocmsLoginToken";
    private static final Log LOG = CmsLog.getLog(CmsPersistentLoginAuthorizationHandler.class);

    @Override
    public CmsObject initCmsObject(HttpServletRequest request, I_CmsAuthorizationHandler.I_PrivilegedLoginAction loginAction) {
        CmsObject cms = this.initCmsObjectFromToken(request, loginAction);
        if (cms == null) {
            cms = super.initCmsObject(request, loginAction);
        }
        return cms;
    }

    public CmsObject initCmsObjectFromToken(HttpServletRequest request, I_CmsAuthorizationHandler.I_PrivilegedLoginAction loginAction) {
        CmsObject cms = null;
        CmsPersistentLoginTokenHandler tokenHandler = new CmsPersistentLoginTokenHandler();
        try {
            CmsUser user = tokenHandler.validateToken(CmsRequestUtil.getCookieValue(request.getCookies(), COOKIE_NAME));
            if (user != null) {
                OpenCms.getMemoryMonitor().uncacheUser(user);
                OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.PERMISSION, CmsMemoryMonitor.CacheType.ROLE_LIST);
                loginAction.getCmsObject().getRequestContext().setAttribute("__FORCE_UPDATE_MEMBERSHIP", Boolean.TRUE);
                cms = loginAction.doLogin(request, user.getName());
                OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.PERMISSION, CmsMemoryMonitor.CacheType.ROLE_LIST);
                cms = this.registerSession(request, cms);
                LOG.info((Object)("Successfully authenticated user '" + cms.getRequestContext().getCurrentUser().getName() + "' using a login token."));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return cms;
    }
}

