/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import java.util.ArrayList;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;

public enum CmsSSLMode {
    NO("no", "GUI_SSL_MODE_NOSSL_0"),
    MANUAL("manual", "GUI_SSL_MODE_MANUAL_0"),
    MANUAL_EP_TERMINATION("manual-ep-termination", "GUI_SSL_MODE_MANUAL_EP_0"),
    LETS_ENCRYPT("lets-encrypt", "GUI_SSL_MODE_LETS_ENCRYPT_0"),
    SECURE_SERVER("secure-server", "GUI_SSL_MODE_SECURE_SERVER_0");

    private String m_message;
    private String m_xmlValue;

    private CmsSSLMode(String xmlValue, String message) {
        this.m_xmlValue = xmlValue;
        this.m_message = message;
    }

    public static List<CmsSSLMode> availableModes(boolean includeOldStyle, boolean includeLetsEncrypt) {
        includeOldStyle &= OpenCms.getSiteManager().isOldStyleSecureServerAllowed();
        ArrayList<CmsSSLMode> res = new ArrayList<CmsSSLMode>();
        block4: for (CmsSSLMode mode : CmsSSLMode.values()) {
            switch (mode) {
                case SECURE_SERVER: {
                    if (!includeOldStyle) continue block4;
                    res.add(mode);
                    continue block4;
                }
                case LETS_ENCRYPT: {
                    if (!includeLetsEncrypt) continue block4;
                    res.add(mode);
                    continue block4;
                }
                default: {
                    res.add(mode);
                }
            }
        }
        return res;
    }

    public static CmsSSLMode getDefault() {
        if (OpenCms.getSiteManager().isOldStyleSecureServerAllowed()) {
            return SECURE_SERVER;
        }
        return NO;
    }

    public static CmsSSLMode getModeFromXML(String xmlValue) {
        for (CmsSSLMode mode : CmsSSLMode.values()) {
            if (!mode.getXMLValue().equals(xmlValue)) continue;
            return mode;
        }
        return SECURE_SERVER;
    }

    public String getLocalizedMessage() {
        return CmsVaadinUtils.getMessageText(this.m_message, new Object[0]);
    }

    public String getXMLValue() {
        return this.m_xmlValue;
    }

    public boolean isSecure() {
        return this.equals((Object)MANUAL_EP_TERMINATION) || this.equals((Object)MANUAL) || this.equals((Object)LETS_ENCRYPT);
    }
}

