/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.util.CmsUUID;

public class CmsUgcConfiguration {
    private Optional<CmsUser> m_userForGuests;
    private CmsUUID m_id;
    private CmsGroup m_projectGroup;
    private Optional<Long> m_queueInterval;
    private Optional<Integer> m_maxQueueLength;
    private String m_namePattern;
    private CmsResource m_contentParentFolder;
    private Optional<CmsResource> m_uploadParentFolder;
    private Optional<Long> m_maxUploadSize;
    private Optional<Integer> m_maxContentNumber;
    private boolean m_isAutoPublish;
    private Optional<List<String>> m_validExtensions;
    private Locale m_locale;
    private String m_resourceType;
    private String m_path;

    public CmsUgcConfiguration(CmsUUID id, Optional<CmsUser> userForGuests, CmsGroup projectGroup, String resourceType, CmsResource contentParentFolder, String namePattern, Locale locale, Optional<CmsResource> uploadParent, Optional<Long> maxUploadSize, Optional<Integer> maxContents, Optional<Long> queueTimeout, Optional<Integer> maxQueueLength, boolean autoPublish, Optional<List<String>> validExtensions) {
        this.m_id = id;
        this.m_userForGuests = userForGuests;
        this.m_projectGroup = projectGroup;
        this.m_resourceType = resourceType;
        this.m_contentParentFolder = contentParentFolder;
        this.m_namePattern = namePattern;
        this.m_locale = locale;
        this.m_uploadParentFolder = uploadParent;
        this.m_maxUploadSize = maxUploadSize;
        this.m_maxContentNumber = maxContents;
        this.m_queueInterval = queueTimeout;
        this.m_maxQueueLength = maxQueueLength;
        this.m_isAutoPublish = autoPublish;
        this.m_validExtensions = validExtensions;
    }

    public CmsResource getContentParentFolder() {
        return this.m_contentParentFolder;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Optional<Integer> getMaxContentNumber() {
        return this.m_maxContentNumber;
    }

    public Optional<Integer> getMaxQueueLength() {
        return this.m_maxQueueLength;
    }

    public Optional<Long> getMaxUploadSize() {
        return this.m_maxUploadSize;
    }

    public String getNamePattern() {
        return this.m_namePattern;
    }

    public String getPath() {
        return this.m_path;
    }

    public CmsGroup getProjectGroup() {
        return this.m_projectGroup;
    }

    public Optional<Long> getQueueInterval() {
        return this.m_queueInterval;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public Optional<CmsResource> getUploadParentFolder() {
        return this.m_uploadParentFolder;
    }

    public Optional<CmsUser> getUserForGuests() {
        return this.m_userForGuests;
    }

    public Optional<List<String>> getValidExtensions() {
        return this.m_validExtensions;
    }

    public boolean isAutoPublish() {
        return this.m_isAutoPublish;
    }

    public boolean needsQueue() {
        return this.m_maxQueueLength.isPresent() || this.m_queueInterval.isPresent();
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

