/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsSessionDestroyHandler;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.ugc.CmsUgcConfiguration;
import org.opencms.ugc.CmsUgcSessionSecurityUtil;
import org.opencms.ugc.CmsUgcUploadHelper;
import org.opencms.ugc.Messages;
import org.opencms.ugc.shared.CmsUgcConstants;
import org.opencms.ugc.shared.CmsUgcException;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsUgcSession
implements I_CmsSessionDestroyHandler {
    private static final Log LOG = CmsLog.getLog(CmsUgcSession.class);
    private CmsUgcUploadHelper m_uploadHelper = new CmsUgcUploadHelper();
    private CmsObject m_cms;
    private CmsUgcConfiguration m_configuration;
    private CmsResource m_editResource;
    private CmsObject m_adminCms;
    private boolean m_finished;
    private Map<String, CmsResource> m_uploadResourcesByField = Maps.newHashMap();
    private boolean m_requiresCleanup = true;

    public CmsUgcSession(CmsObject adminCms, CmsObject cms, CmsUgcConfiguration configuration) throws CmsException {
        this.m_adminCms = OpenCms.initCmsObject(adminCms);
        this.m_configuration = configuration;
        if (cms.getRequestContext().getCurrentUser().isGuestUser() && this.m_configuration.getUserForGuests().isPresent()) {
            this.m_cms = OpenCms.initCmsObject(adminCms, new CmsContextInfo(((CmsUser)this.m_configuration.getUserForGuests().get()).getName()));
            this.m_cms.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
        } else {
            this.m_cms = OpenCms.initCmsObject(cms);
        }
        for (CmsObject currentCms : new CmsObject[]{this.m_cms, this.m_adminCms}) {
            currentCms.getRequestContext().setLocale(this.getMessageLocale());
        }
        CmsProject project = this.m_adminCms.createProject(this.generateProjectName(), "User generated content project for " + configuration.getPath(), this.m_configuration.getProjectGroup().getName(), this.m_configuration.getProjectGroup().getName());
        project.setDeleteAfterPublishing(true);
        project.setFlags(8);
        this.m_adminCms.writeProject(project);
        this.m_cms.getRequestContext().setCurrentProject(project);
    }

    public CmsUgcSession(CmsObject cms, CmsUgcConfiguration configuration) throws CmsException {
        this(cms, cms, configuration);
    }

    protected CmsUgcSession(CmsObject cms) {
        this.m_cms = cms;
    }

    public CmsResource createUploadResource(String fieldName, String rawFileName, byte[] content) throws CmsUgcException {
        CmsMacroResolver resolver;
        String realSitePath;
        int dotPos;
        CmsResource result = null;
        CmsUgcSessionSecurityUtil.checkCreateUpload(this.m_cms, this.m_configuration, rawFileName, content.length);
        String baseName = rawFileName;
        int lastSlashPos = Math.max(baseName.lastIndexOf(47), baseName.lastIndexOf(92));
        if (lastSlashPos != -1) {
            baseName = baseName.substring(1 + lastSlashPos);
        }
        baseName = (dotPos = (baseName = OpenCms.getResourceManager().getFileTranslator().translateResource(baseName)).lastIndexOf(46)) == -1 ? baseName + "_%(random)" : baseName.substring(0, dotPos) + "_%(random)" + baseName.substring(dotPos);
        String uploadRootPath = ((CmsResource)this.m_configuration.getUploadParentFolder().get()).getRootPath();
        String sitePath = CmsStringUtil.joinPaths(this.m_cms.getRequestContext().removeSiteRoot(uploadRootPath), baseName);
        do {
            resolver = new CmsMacroResolver();
            resolver.addMacro("random", RandomStringUtils.random((int)8, (String)"0123456789abcdefghijklmnopqrstuvwxyz"));
        } while (this.m_cms.existsResource(realSitePath = resolver.resolveMacros(sitePath)));
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getDefaultTypeForName(realSitePath);
            result = this.m_cms.createResource(realSitePath, resType, content, null);
            this.updateUploadResource(fieldName, result);
            return result;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsUgcException(e, CmsUgcConstants.ErrorCode.errMisc, e.getLocalizedMessage());
        }
    }

    public CmsResource createXmlContent() throws CmsUgcException {
        this.checkNotFinished();
        this.checkEditResourceNotSet();
        CmsUgcSessionSecurityUtil.checkCreateContent(this.m_cms, this.m_configuration);
        try {
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(this.m_configuration.getResourceType());
            this.m_editResource = this.m_cms.createResource(this.getNewContentName(), type);
            return this.m_editResource;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsUgcException(e, CmsUgcConstants.ErrorCode.errMisc, e.getLocalizedMessage());
        }
    }

    public void disableCleanup() {
        this.m_requiresCleanup = false;
    }

    public void finish() throws CmsException {
        this.m_finished = true;
        this.m_requiresCleanup = false;
        CmsProject project = this.getProject();
        CmsObject projectCms = OpenCms.initCmsObject(this.m_adminCms);
        projectCms.getRequestContext().setCurrentProject(project);
        if (this.m_configuration.isAutoPublish()) {
            List<CmsResource> projectResources = projectCms.readProjectView(project.getUuid(), CmsResource.STATE_KEEP);
            for (CmsResource projectResource : projectResources) {
                CmsLock lock = projectCms.getLock(projectResource);
                if (lock.isUnlocked() || lock.isLockableBy(projectCms.getRequestContext().getCurrentUser())) continue;
                projectCms.changeLock(projectResource);
            }
            OpenCms.getPublishManager().publishProject(projectCms, new CmsLogReport(Locale.ENGLISH, CmsUgcSession.class));
        } else {
            projectCms.unlockProject(project.getUuid());
        }
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public CmsUgcUploadHelper getFormUploadHelper() {
        return this.m_uploadHelper;
    }

    public CmsUUID getId() {
        return this.getProject().getUuid();
    }

    public Locale getMessageLocale() {
        return this.m_configuration.getLocale();
    }

    public CmsProject getProject() {
        return this.m_cms.getRequestContext().getCurrentProject();
    }

    public CmsResource getResource() {
        return this.m_editResource;
    }

    public Map<String, String> getValues() throws CmsException {
        Locale locale;
        CmsFile file = this.m_cms.readFile(this.m_editResource);
        CmsXmlContent content = this.unmarshalXmlContent(file);
        if (!content.hasLocale(locale = this.m_cms.getRequestContext().getLocale())) {
            content.addLocale(this.m_cms, locale);
        }
        return this.getContentValues(content, locale);
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    public CmsResource loadXmlContent(String fileName) throws CmsUgcException {
        this.checkNotFinished();
        this.checkEditResourceNotSet();
        if (fileName.contains("/")) {
            String message = Messages.get().container("ERR_INVALID_FILE_NAME_TO_LOAD_1", fileName).key(this.getCmsObject().getRequestContext().getLocale());
            throw new CmsUgcException(CmsUgcConstants.ErrorCode.errMisc, message);
        }
        try {
            String contentSitePath = this.m_cms.getRequestContext().removeSiteRoot(this.m_configuration.getContentParentFolder().getRootPath());
            String path = CmsStringUtil.joinPaths(contentSitePath, fileName);
            this.m_editResource = this.m_cms.readResource(path);
            CmsLock lock = this.m_cms.getLock(this.m_editResource);
            if (!lock.isOwnedBy(this.m_cms.getRequestContext().getCurrentUser())) {
                this.m_cms.lockResourceTemporary(this.m_editResource);
            }
            return this.m_editResource;
        }
        catch (CmsException e) {
            throw new CmsUgcException(CmsUgcConstants.ErrorCode.errMisc, e.getLocalizedMessage());
        }
    }

    @Override
    public void onSessionDestroyed() {
        if (this.m_requiresCleanup) {
            this.cleanupProject();
        } else {
            this.cleanupProjectIfEmpty();
        }
    }

    public CmsXmlContentErrorHandler saveContent(Map<String, String> contentValues) throws CmsUgcException {
        this.checkNotFinished();
        try {
            CmsFile file = this.m_cms.readFile(this.m_editResource);
            CmsXmlContent content = this.addContentValues(file, contentValues);
            CmsXmlContentErrorHandler errorHandler = content.validate(this.m_cms);
            if (!errorHandler.hasErrors()) {
                file.setContents(content.marshal());
                file = this.m_cms.writeFile(file);
            }
            return errorHandler;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsUgcException(e, CmsUgcConstants.ErrorCode.errMisc, e.getLocalizedMessage());
        }
    }

    public CmsXmlContentErrorHandler validateContent(Map<String, String> contentValues) throws CmsUgcException {
        this.checkNotFinished();
        try {
            CmsFile file = this.m_cms.readFile(this.m_editResource);
            CmsXmlContent content = this.addContentValues(file, contentValues);
            return content.validate(this.m_cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsUgcException(e, CmsUgcConstants.ErrorCode.errMisc, e.getLocalizedMessage());
        }
    }

    protected void addContentValue(CmsXmlContent content, Locale locale, String path, String value) {
        boolean hasValue = content.hasValue(path, locale);
        if (!hasValue) {
            String[] pathElements = path.split("/");
            String currentPath = pathElements[0];
            for (int i = 0; i < pathElements.length; ++i) {
                if (i > 0) {
                    currentPath = CmsStringUtil.joinPaths(currentPath, pathElements[i]);
                }
                while (!content.hasValue(currentPath, locale)) {
                    content.addValue(this.m_cms, currentPath, locale, CmsXmlUtils.getXpathIndexInt(currentPath) - 1);
                }
            }
        }
        content.getValue(path, locale).setStringValue(this.m_cms, value);
    }

    protected CmsXmlContent addContentValues(CmsFile file, Map<String, String> contentValues) throws CmsException {
        CmsXmlContent content = this.unmarshalXmlContent(file);
        Locale locale = this.m_cms.getRequestContext().getLocale();
        this.addContentValues(content, locale, contentValues);
        return content;
    }

    protected void addContentValues(CmsXmlContent content, Locale locale, Map<String, String> contentValues) throws CmsXmlException {
        if (!content.hasLocale(locale)) {
            content.addLocale(this.m_cms, locale);
        }
        ArrayList<String> paths = new ArrayList<String>(contentValues.keySet());
        Collections.sort(paths, new PathComparator(true));
        String lastDelete = "///";
        for (String path : paths) {
            if (contentValues.get(path) != null || path.startsWith(lastDelete)) continue;
            lastDelete = path;
            this.deleteContentValue(content, locale, path);
        }
        Collections.sort(paths, new PathComparator(false));
        for (String path : paths) {
            String value = contentValues.get(path);
            if (value == null) continue;
            this.addContentValue(content, locale, path, value);
        }
    }

    protected void deleteContentValue(CmsXmlContent content, Locale locale, String path) {
        boolean hasValue = content.hasValue(path, locale);
        if (hasValue) {
            I_CmsXmlContentValue val;
            int index = CmsXmlUtils.getXpathIndexInt(path) - 1;
            if (index >= (val = content.getValue(path, locale)).getMinOccurs()) {
                content.removeValue(path, locale, index);
            } else {
                val.setStringValue(this.m_cms, "");
            }
        }
    }

    protected Map<String, String> getContentValues(CmsXmlContent content, Locale locale) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<I_CmsXmlContentValue> values = content.getValues(locale);
        for (I_CmsXmlContentValue value : values) {
            if (!value.isSimpleType()) continue;
            result.put(value.getPath(), value.getStringValue(this.m_cms));
        }
        return result;
    }

    private void checkEditResourceNotSet() throws CmsUgcException {
        if (this.m_editResource != null) {
            String message = Messages.get().container("ERR_CANT_EDIT_MULTIPLE_CONTENTS_IN_SESSION_0").key(this.getCmsObject().getRequestContext().getLocale());
            throw new CmsUgcException(CmsUgcConstants.ErrorCode.errInvalidAction, message);
        }
    }

    private void checkNotFinished() throws CmsUgcException {
        if (this.m_finished) {
            String message = Messages.get().container("ERR_FORM_SESSION_ALREADY_FINISHED_0").key(this.getCmsObject().getRequestContext().getLocale());
            throw new CmsUgcException(CmsUgcConstants.ErrorCode.errInvalidAction, message);
        }
    }

    private void cleanupProject() {
        CmsObject cms;
        this.m_requiresCleanup = false;
        try {
            cms = OpenCms.initCmsObject(this.m_adminCms);
            cms.readProject(this.getProject().getUuid());
        }
        catch (CmsException e) {
            return;
        }
        try {
            cms = OpenCms.initCmsObject(this.m_adminCms);
            cms.getRequestContext().setCurrentProject(this.getProject());
            CmsUUID projectId = this.getProject().getUuid();
            List<CmsResource> projectResources = cms.readProjectView(projectId, CmsResource.STATE_KEEP);
            if (this.hasOnlyNewResources(projectResources)) {
                for (CmsResource res : projectResources) {
                    LOG.info((Object)("Deleting resource for timed out form session: " + res.getRootPath()));
                    this.deleteResourceFromProject(cms, res);
                }
                LOG.info((Object)("Deleting project for timed out form session: " + this.getProject().getName() + " [" + this.getProject().getUuid() + "]"));
                cms.deleteProject(projectId);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void cleanupProjectIfEmpty() {
        CmsObject cms;
        this.m_requiresCleanup = false;
        try {
            cms = OpenCms.initCmsObject(this.m_adminCms);
            cms.readProject(this.getProject().getUuid());
        }
        catch (CmsException e) {
            return;
        }
        try {
            cms = OpenCms.initCmsObject(this.m_adminCms);
            cms.getRequestContext().setCurrentProject(this.getProject());
            CmsUUID projectId = this.getProject().getUuid();
            List<CmsResource> projectResources = cms.readProjectView(projectId, CmsResource.STATE_KEEP);
            if (projectResources.isEmpty()) {
                cms.deleteProject(projectId);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void deleteResourceFromProject(CmsObject cms, CmsResource res) throws CmsException {
        CmsLock lock = cms.getLock(res);
        if (lock.isUnlocked() || lock.isLockableBy(cms.getRequestContext().getCurrentUser())) {
            cms.lockResourceTemporary(res);
        } else {
            cms.changeLock(res);
        }
        cms.deleteResource(cms.getSitePath(res), CmsResource.DELETE_PRESERVE_SIBLINGS);
    }

    private String generateProjectName() {
        return "Edit project " + new Date();
    }

    private String getNewContentName() throws CmsException {
        String sitePath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(this.m_cms, CmsStringUtil.joinPaths(this.m_cms.getRequestContext().removeSiteRoot(this.m_configuration.getContentParentFolder().getRootPath()), this.m_configuration.getNamePattern()), 5);
        return sitePath;
    }

    private boolean hasOnlyNewResources(List<CmsResource> projectResources) {
        boolean hasOnlyNewResources = true;
        for (CmsResource projectRes : projectResources) {
            if (projectRes.getState().isNew()) continue;
            hasOnlyNewResources = false;
            break;
        }
        return hasOnlyNewResources;
    }

    private CmsXmlContent unmarshalXmlContent(CmsFile file) throws CmsXmlException {
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        content.setAutoCorrectionEnabled(true);
        content.correctXmlStructure(this.m_cms);
        return content;
    }

    private void updateUploadResource(String fieldName, CmsResource upload) {
        CmsResource prevUploadResource = this.m_uploadResourcesByField.get(fieldName);
        if (prevUploadResource != null) {
            try {
                this.m_cms.deleteResource(this.m_cms.getSitePath(prevUploadResource), CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            catch (Exception e) {
                LOG.error((Object)("Couldn't delete previous upload resource: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        this.m_uploadResourcesByField.put(fieldName, upload);
    }

    public static class PathComparator
    implements Comparator<String> {
        private Ordering<String> m_elementOrdering;

        public PathComparator(boolean isDeleteOrder) {
            this.m_elementOrdering = isDeleteOrder ? new Ordering<String>(){

                public int compare(String first, String second) {
                    return ComparisonChain.start().compare((Comparable)((Object)CmsXmlUtils.removeXpathIndex(first)), (Comparable)((Object)CmsXmlUtils.removeXpathIndex(second))).compare(CmsXmlUtils.getXpathIndexInt(second), CmsXmlUtils.getXpathIndexInt(first)).result();
                }
            } : new Ordering<String>(){

                public int compare(String first, String second) {
                    return ComparisonChain.start().compare((Comparable)((Object)CmsXmlUtils.removeXpathIndex(first)), (Comparable)((Object)CmsXmlUtils.removeXpathIndex(second))).compare(CmsXmlUtils.getXpathIndexInt(first), CmsXmlUtils.getXpathIndexInt(second)).result();
                }
            };
        }

        @Override
        public int compare(String o1, String o2) {
            int result = -1;
            if (o1 == null) {
                result = 1;
            } else if (o2 == null) {
                result = -1;
            } else {
                String[] o1Elements = o1.split("/");
                String[] o2Elements = o2.split("/");
                result = this.m_elementOrdering.lexicographical().compare(Arrays.asList(o1Elements), Arrays.asList(o2Elements));
            }
            return result;
        }
    }
}

