/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;

public class CmsGalleryDialogAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "gallery";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.VISIBLE;
    private static final String[] GALLERY_TYPES = new String[]{"imagegallery", "downloadgallery", "linkgallery"};

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        try {
            CmsGwtDialogExtension dialogExtension = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    ArrayList updatedIds = Lists.newArrayList();
                    for (String item : updatedItems) {
                        updatedIds.add(new CmsUUID(item));
                    }
                    context.finish(updatedIds);
                }
            });
            dialogExtension.openGalleryDialog(context.getResources().get(0));
        }
        catch (Exception e) {
            context.error(e);
        }
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        CmsResource res;
        if (resources.size() == 1 && (res = resources.get(0)).isFolder()) {
            String type = OpenCms.getResourceManager().getResourceType(res).getTypeName();
            if (Arrays.asList(GALLERY_TYPES).contains(type)) {
                return VISIBILITY.getVisibility(cms, resources);
            }
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_OPENGALLERY_0";
    }
}

