/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.CmsLockedResourcesList;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.util.CmsUUID;

public class CmsLockAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "lock";
    static final Log LOG = CmsLog.getLog(CmsLockAction.class);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        new Context(context).executeAction();
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return CmsStandardVisibilityCheck.LOCK.getVisibility(cms, resources);
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_LOCK_0";
    }

    class Context {
        I_CmsDialogContext m_context;

        public Context(I_CmsDialogContext context) {
            this.m_context = context;
        }

        protected void doLock() {
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsException storedException = null;
            ArrayList changedIds = Lists.newArrayList();
            for (CmsResource res : this.m_context.getResources()) {
                try {
                    cms.lockResource(res);
                    changedIds.add(res.getStructureId());
                }
                catch (CmsException e) {
                    if (storedException == null) {
                        storedException = e;
                    }
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (storedException != null) {
                this.m_context.finish(changedIds);
                this.m_context.error(storedException);
            } else {
                this.m_context.finish(changedIds);
            }
        }

        void executeAction() {
            CmsObject cms = A_CmsUI.getCmsObject();
            ArrayList blockingLocked = Lists.newArrayList();
            for (CmsResource res : this.m_context.getResources()) {
                try {
                    List<CmsResource> blockingLockedForCurrentResource = cms.getBlockingLockedResources(res);
                    blockingLocked.addAll(blockingLockedForCurrentResource);
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (blockingLocked.isEmpty()) {
                this.doLock();
            } else {
                String messageKey = this.m_context.getResources().size() > 1 ? "GUI_LOCK_MULTI_INFO_LOCKEDSUBRESOURCES_0" : "GUI_LOCK_INFO_LOCKEDSUBRESOURCES_0";
                CmsLockedResourcesList widget = new CmsLockedResourcesList(cms, blockingLocked, CmsVaadinUtils.getMessageText(messageKey, new Object[0]), new ActionOk(), new ActionCancel());
                widget.displayResourceInfo(this.m_context.getResources());
                this.m_context.start(CmsVaadinUtils.getMessageText("GUI_LOCK_DIALOG_TITLE_0", new Object[0]), (Component)widget);
            }
        }

        class ActionOk
        implements Runnable {
            ActionOk() {
            }

            @Override
            public void run() {
                Context.this.doLock();
            }
        }

        class ActionCancel
        implements Runnable {
            ActionCancel() {
            }

            @Override
            public void run() {
                Context.this.m_context.finish(new ArrayList<CmsUUID>());
            }
        }
    }
}

