/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;

public class CmsReplaceDialogAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    public static final String ACTION_ID = "replace";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.REPLACE);

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        final CmsUUID structureId = context.getResources().get(0).getStructureId();
        if (!this.hasBlockingLocks(context)) {
            CmsGwtDialogExtension gwtExt = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    context.finish(Arrays.asList(structureId));
                }
            });
            gwtExt.openReplaceDialog(structureId);
        }
    }

    @Override
    public String getCommandClassName() {
        return "org.opencms.gwt.client.ui.contextmenu.CmsReplace";
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        return null;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_REPLACE_0";
    }
}

