/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;

public final class CmsResourceInfoAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    public static final String ACTION_ID = "resourceinfo";
    private I_CmsHasMenuItemVisibility m_visibility = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.VISIBLE);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        this.openDialog(context, null);
    }

    @Override
    public String getCommandClassName() {
        return "org.opencms.gwt.client.ui.contextmenu.CmsResourceInfo";
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        return null;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return this.m_visibility.getVisibility(cms, resources);
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    public void openDialog(final I_CmsDialogContext context, String tabId) {
        CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

            @Override
            public void onUpdate(List<String> updatedItems) {
                ArrayList ids = Lists.newArrayList();
                for (String item : updatedItems) {
                    ids.add(new CmsUUID(item));
                }
                context.finish(ids);
            }
        });
        extension.openInfoDialog(context.getResources().get(0), tabId);
    }

    @Override
    protected String getTitleKey() {
        return "GUI_RESOURCE_INFO_0";
    }
}

