/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.event.Action;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspTagEdit;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsHasShortcutActions;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.editors.I_CmsEditor;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsEditor
implements I_CmsWorkplaceApp,
ViewChangeListener,
I_CmsWindowCloseListener,
I_CmsHasShortcutActions {
    public static final String BACK_LINK_PREFIX = "backLink";
    public static final String PLAIN_TEXT_PREFIX = "plainText";
    public static final String RESOURCE_ID_PREFIX = "resourceId";
    public static final String RESOURCE_PATH_PREFIX = "resourcePath";
    private static final Log LOG = CmsLog.getLog(CmsEditor.class);
    private static final long serialVersionUID = 7503052469189004387L;
    private I_CmsAppUIContext m_context;
    private I_CmsEditor m_editorInstance;

    public static String getEditState(CmsUUID resourceId, boolean plainText, String backLink) {
        try {
            backLink = URLEncoder.encode(backLink, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String state = "";
        state = A_CmsWorkplaceApp.addParamToState(state, RESOURCE_ID_PREFIX, resourceId.toString());
        state = A_CmsWorkplaceApp.addParamToState(state, PLAIN_TEXT_PREFIX, String.valueOf(plainText));
        state = A_CmsWorkplaceApp.addParamToState(state, BACK_LINK_PREFIX, backLink);
        return state;
    }

    public static String getEditStateForNew(CmsObject cms, I_CmsResourceType resourceType, String contextPath, String modelFilePath, boolean plainText, String backLink) {
        String state = "";
        state = A_CmsWorkplaceApp.addParamToState(state, "newlink", CmsJspTagEdit.getNewLink(cms, resourceType, contextPath));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(modelFilePath)) {
            state = A_CmsWorkplaceApp.addParamToState(state, "modelfile", modelFilePath);
            state = A_CmsWorkplaceApp.addParamToState(state, "mode", "copy");
        }
        state = A_CmsWorkplaceApp.addParamToState(state, RESOURCE_PATH_PREFIX, contextPath);
        state = A_CmsWorkplaceApp.addParamToState(state, PLAIN_TEXT_PREFIX, String.valueOf(plainText));
        try {
            backLink = URLEncoder.encode(backLink, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        state = A_CmsWorkplaceApp.addParamToState(state, BACK_LINK_PREFIX, backLink);
        return state;
    }

    public static void openBackLink(String backlink) {
        try {
            backlink = URLDecoder.decode(backlink, "UTF-8");
            String current = Page.getCurrent().getLocation().toString();
            if (current.contains("#")) {
                current = current.substring(0, current.indexOf("#"));
            }
            if (backlink.startsWith(current)) {
                String target = backlink.substring(backlink.indexOf("#") + 1);
                CmsAppWorkplaceUi.get().getNavigator().navigateTo(target);
            } else {
                Page.getCurrent().setLocation(backlink);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        if (this.m_editorInstance instanceof ViewChangeListener) {
            ((ViewChangeListener)this.m_editorInstance).afterViewChange(event);
        }
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        if (this.m_editorInstance instanceof ViewChangeListener) {
            return ((ViewChangeListener)this.m_editorInstance).beforeViewChange(event);
        }
        return true;
    }

    @Override
    public Map<Action, Runnable> getShortcutActions() {
        if (this.m_editorInstance instanceof I_CmsHasShortcutActions) {
            return ((I_CmsHasShortcutActions)((Object)this.m_editorInstance)).getShortcutActions();
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        this.m_context = context;
    }

    @Override
    public void onStateChange(String state) {
        CmsUUID resId = this.getResourceIdFromState(state);
        String path = null;
        if (resId == null) {
            path = this.getResourcePathFromState(state);
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        final String backlink = this.getBackLinkFromState(state);
        try {
            CmsResource resource = null;
            if (resId != null) {
                resource = cms.readResource(resId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(path)) {
                resource = cms.readResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            Map<String, String> params = A_CmsWorkplaceApp.getParamsFromState(state);
            String newLink = params.get("newlink");
            I_CmsEditor editor = null;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(newLink)) {
                OpenCms.getRoleManager().checkRoleForResource(cms, CmsRole.ELEMENT_AUTHOR, cms.getSitePath(resource));
                editor = OpenCms.getWorkplaceAppManager().getEditorForResource(resource, this.isPlainText(state));
            } else {
                String typeName = CmsJspTagEdit.getTypeFromNewLink(newLink);
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(typeName);
                editor = OpenCms.getWorkplaceAppManager().getEditorForType(type, this.isPlainText(state));
                String rootPath = CmsJspTagEdit.getRootPathFromNewLink(newLink);
                CmsADEConfigData data = OpenCms.getADEManager().lookupConfiguration(cms, rootPath);
                CmsResourceTypeConfig typeConfig = data.getResourceType(typeName);
                if (!typeConfig.checkCreatable(cms, rootPath)) {
                    throw new RuntimeException();
                }
            }
            if (editor != null) {
                this.m_editorInstance = editor.newInstance();
                params.remove(BACK_LINK_PREFIX);
                params.remove(RESOURCE_ID_PREFIX);
                params.remove(RESOURCE_PATH_PREFIX);
                params.remove(PLAIN_TEXT_PREFIX);
                this.m_editorInstance.initUI(this.m_context, resource, backlink, params);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing the editor.", (Throwable)e);
            CmsErrorDialog.showErrorDialog(e, new Runnable(){

                @Override
                public void run() {
                    CmsEditor.openBackLink(backlink);
                }
            });
        }
    }

    @Override
    public void onWindowClose() {
        if (this.m_editorInstance instanceof I_CmsWindowCloseListener) {
            ((I_CmsWindowCloseListener)((Object)this.m_editorInstance)).onWindowClose();
        }
    }

    private String getBackLinkFromState(String state) {
        return A_CmsWorkplaceApp.getParamFromState(state, BACK_LINK_PREFIX);
    }

    private CmsUUID getResourceIdFromState(String state) {
        CmsUUID result = null;
        String id = A_CmsWorkplaceApp.getParamFromState(state, RESOURCE_ID_PREFIX);
        if (CmsUUID.isValidUUID(id)) {
            result = new CmsUUID(id);
        }
        return result;
    }

    private String getResourcePathFromState(String state) {
        return A_CmsWorkplaceApp.getParamFromState(state, RESOURCE_PATH_PREFIX);
    }

    private boolean isPlainText(String state) {
        String val = A_CmsWorkplaceApp.getParamFromState(state, PLAIN_TEXT_PREFIX);
        return Boolean.parseBoolean(val);
    }
}

