/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.cacheadmin.CmsCacheViewApp;
import org.opencms.ui.apps.cacheadmin.CmsVariationsDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;

public class CmsFlexCacheTable
extends Table {
    private static final String PROP_ICON = "icon";
    private static final String PROP_KEY = "key";
    private static final String PROP_PROJECT = "project";
    private static final String PROP_RESOURCENAME = "name";
    private static final String PROP_VARIATIONS = "variations";
    private static final long serialVersionUID = 836377854954208442L;
    CmsContextMenu m_menu;
    private CmsFlexCache m_cache = OpenCms.getFlexCache();
    private IndexedContainer m_container;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private CmsObject m_rootCms;

    public CmsFlexCacheTable() {
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new IndexedContainer();
        this.m_container.addContainerProperty((Object)PROP_ICON, Resource.class, (Object)new CmsCssIcon("oc-icon-24-cache"));
        this.m_container.addContainerProperty((Object)PROP_RESOURCENAME, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_PROJECT, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_KEY, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_VARIATIONS, Integer.class, (Object)new Integer(0));
        this.setContainerDataSource((Container)this.m_container);
        this.setColumnHeader(PROP_RESOURCENAME, CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LIST_COLS_RESOURCE_0", new Object[0]));
        this.setColumnHeader(PROP_PROJECT, CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LIST_COLS_PROJECT_0", new Object[0]));
        this.setColumnHeader(PROP_KEY, CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LIST_COLS_KEY_0", new Object[0]));
        this.setColumnHeader(PROP_VARIATIONS, CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LIST_COLS_VARCOUNT_0", new Object[0]));
        this.setItemIconPropertyId(PROP_ICON);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setColumnWidth(PROP_VARIATIONS, 90);
        this.setSelectable(true);
        this.loadTableEntries();
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -4738296706762013443L;

            public void itemClick(ItemClickEvent event) {
                CmsFlexCacheTable.this.setValue(null);
                CmsFlexCacheTable.this.select(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    CmsFlexCacheTable.this.m_menu.setEntries(CmsFlexCacheTable.this.getMenuEntries(), Collections.singleton((String)CmsFlexCacheTable.this.getValue()));
                    CmsFlexCacheTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsFlexCacheTable.this);
                }
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) & CmsFlexCacheTable.PROP_RESOURCENAME.equals(event.getPropertyId())) {
                    CmsFlexCacheTable.this.showVariationsWindow((String)CmsFlexCacheTable.this.getValue());
                }
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (CmsFlexCacheTable.PROP_RESOURCENAME.equals(propertyId)) {
                    return " o-hover-column";
                }
                return null;
            }
        });
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)PROP_RESOURCENAME, search, true, false), new SimpleStringFilter((Object)PROP_KEY, search, true, false)}));
        }
        if (this.getValue() != null) {
            this.setCurrentPageFirstItemId(this.getValue());
        }
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryVariations());
        }
        return this.m_menuEntries;
    }

    CmsObject getRootCms() {
        try {
            if (this.m_rootCms == null) {
                this.m_rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                this.m_rootCms.getRequestContext().setSiteRoot("");
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return this.m_rootCms;
    }

    void showVariationsWindow(String resource) {
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
        CmsVariationsDialog variationsDialog = new CmsVariationsDialog(resource, new Runnable(){

            @Override
            public void run() {
                window.close();
            }
        }, CmsCacheViewApp.Mode.FlexCache);
        try {
            CmsResource resourceObject = this.getRootCms().readResource(CmsFlexCacheKey.getResourceName(resource));
            variationsDialog.displayResourceInfo(Collections.singletonList(resourceObject));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_CACHE_VIEW_FLEX_VARIATIONS_1", resource));
        window.setContent((Component)variationsDialog);
        UI.getCurrent().addWindow(window);
    }

    private void loadTableEntries() {
        this.setVisibleColumns(new Object[]{PROP_RESOURCENAME, PROP_PROJECT, PROP_KEY, PROP_VARIATIONS});
        Iterator<String> itResources = new ArrayList<String>(this.m_cache.getCachedResources(A_CmsUI.getCmsObject())).iterator();
        while (itResources.hasNext()) {
            String resource;
            String resName = resource = itResources.next();
            String project = "";
            String key = "";
            if (resource.endsWith(" [offline]")) {
                resName = resource.substring(0, resource.length() - " [offline]".length());
                project = "Offline";
            }
            if (resource.endsWith(" [online]")) {
                resName = resource.substring(0, resource.length() - " [online]".length());
                project = "Online";
            }
            key = this.m_cache.getCachedKey(resource, A_CmsUI.getCmsObject()).toString();
            Item item = this.m_container.addItem((Object)resource);
            item.getItemProperty((Object)PROP_RESOURCENAME).setValue((Object)resName);
            item.getItemProperty((Object)PROP_PROJECT).setValue((Object)project);
            item.getItemProperty((Object)PROP_KEY).setValue((Object)key);
            item.getItemProperty((Object)PROP_VARIATIONS).setValue((Object)new Integer(this.m_cache.getCachedVariations(resource, A_CmsUI.getCmsObject()).size()));
        }
    }

    class EntryVariations
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryVariations() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String resource = data.iterator().next();
            CmsFlexCacheTable.this.showVariationsWindow(resource);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_STATS_VARIATIONS_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }
}

